/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.memory.MemoryFileSystemFactory;
import io.trino.metadata.TableHandle;
import io.trino.metastore.Column;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveBucketHandle;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HivePageSource;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.Schema;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingHandles;
import io.trino.type.InternalTypeManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestNodeLocalDynamicSplitPruning {
    private static final String SCHEMA_NAME = "test";
    private static final String TABLE_NAME = "test";
    private static final Column BUCKET_COLUMN = new Column("l_orderkey", HiveType.HIVE_INT, Optional.empty(), (Map)ImmutableMap.of());
    private static final Column PARTITION_COLUMN = new Column("l_partkey", HiveType.HIVE_INT, Optional.empty(), (Map)ImmutableMap.of());
    private static final HiveColumnHandle BUCKET_HIVE_COLUMN_HANDLE = new HiveColumnHandle(BUCKET_COLUMN.getName(), 0, BUCKET_COLUMN.getType(), (Type)IntegerType.INTEGER, Optional.empty(), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
    private static final HiveColumnHandle PARTITION_HIVE_COLUMN_HANDLE = new HiveColumnHandle(PARTITION_COLUMN.getName(), 0, PARTITION_COLUMN.getType(), (Type)IntegerType.INTEGER, Optional.empty(), HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());

    TestNodeLocalDynamicSplitPruning() {
    }

    @Test
    void testDynamicBucketPruning() throws IOException {
        HiveConfig config = new HiveConfig();
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        try (ConnectorPageSource emptyPageSource = TestNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, config, TestNodeLocalDynamicSplitPruning.getDynamicFilter(TestNodeLocalDynamicSplitPruning.getTupleDomainForBucketSplitPruning()));){
            Assertions.assertThat((Class)emptyPageSource.getClass()).isEqualTo(EmptyPageSource.class);
        }
        try (ConnectorPageSource nonEmptyPageSource = TestNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, config, TestNodeLocalDynamicSplitPruning.getDynamicFilter(TestNodeLocalDynamicSplitPruning.getNonSelectiveBucketTupleDomain()));){
            Assertions.assertThat((Class)nonEmptyPageSource.getClass()).isEqualTo(HivePageSource.class);
        }
    }

    @Test
    void testDynamicPartitionPruning() throws IOException {
        HiveConfig config = new HiveConfig();
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        try (ConnectorPageSource emptyPageSource = TestNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, config, TestNodeLocalDynamicSplitPruning.getDynamicFilter(TestNodeLocalDynamicSplitPruning.getTupleDomainForPartitionSplitPruning()));){
            Assertions.assertThat((Class)emptyPageSource.getClass()).isEqualTo(EmptyPageSource.class);
        }
        try (ConnectorPageSource nonEmptyPageSource = TestNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, config, TestNodeLocalDynamicSplitPruning.getDynamicFilter(TestNodeLocalDynamicSplitPruning.getNonSelectivePartitionTupleDomain()));){
            Assertions.assertThat((Class)nonEmptyPageSource.getClass()).isEqualTo(HivePageSource.class);
        }
    }

    private static ConnectorPageSource createTestingPageSource(HiveTransactionHandle transaction, HiveConfig hiveConfig, DynamicFilter dynamicFilter) throws IOException {
        Location location = Location.of((String)"memory:///file");
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test")).newOutputFile(location).create().close();
        HiveSplit split = new HiveSplit("", location.toString(), 0L, 0L, 0L, 0L, new Schema(hiveConfig.getHiveStorageFormat().getSerde(), false, (Map)ImmutableMap.of()), (List)ImmutableList.of((Object)new HivePartitionKey(PARTITION_COLUMN.getName(), "42")), (List)ImmutableList.of(), OptionalInt.of(1), OptionalInt.of(1), false, (Map)ImmutableMap.of(), Optional.empty(), Optional.empty(), Optional.empty(), SplitWeight.standard());
        TableHandle tableHandle = new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new HiveTableHandle("test", "test", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of((Object)BUCKET_HIVE_COLUMN_HANDLE), Optional.of(new HiveBucketHandle((List)ImmutableList.of((Object)BUCKET_HIVE_COLUMN_HANDLE), HiveBucketing.BucketingVersion.BUCKETING_V1, 20, 20, (List)ImmutableList.of()))), (ConnectorTransactionHandle)transaction);
        HivePageSourceProvider provider = new HivePageSourceProvider(InternalTypeManager.TESTING_TYPE_MANAGER, hiveConfig, HiveTestUtils.getDefaultHivePageSourceFactories((TrinoFileSystemFactory)fileSystemFactory, hiveConfig));
        return provider.createPageSource((ConnectorTransactionHandle)transaction, (ConnectorSession)TestNodeLocalDynamicSplitPruning.getSession(hiveConfig), (ConnectorSplit)split, tableHandle.connectorHandle(), (List)ImmutableList.of((Object)BUCKET_HIVE_COLUMN_HANDLE, (Object)PARTITION_HIVE_COLUMN_HANDLE), dynamicFilter);
    }

    private static TupleDomain<ColumnHandle> getTupleDomainForBucketSplitPruning() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)BUCKET_HIVE_COLUMN_HANDLE, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L)));
    }

    private static TupleDomain<ColumnHandle> getNonSelectiveBucketTupleDomain() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)BUCKET_HIVE_COLUMN_HANDLE, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
    }

    private static TupleDomain<ColumnHandle> getTupleDomainForPartitionSplitPruning() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)PARTITION_HIVE_COLUMN_HANDLE, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
    }

    private static TupleDomain<ColumnHandle> getNonSelectivePartitionTupleDomain() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)PARTITION_HIVE_COLUMN_HANDLE, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)42L)));
    }

    private static TestingConnectorSession getSession(HiveConfig config) {
        return TestingConnectorSession.builder().setPropertyMetadata(new HiveSessionProperties(config, new OrcReaderConfig(), new OrcWriterConfig(), new ParquetReaderConfig(), new ParquetWriterConfig()).getSessionProperties()).build();
    }

    private static DynamicFilter getDynamicFilter(final TupleDomain<ColumnHandle> tupleDomain) {
        return new DynamicFilter(){

            public Set<ColumnHandle> getColumnsCovered() {
                return tupleDomain.getDomains().map(Map::keySet).orElseGet(ImmutableSet::of);
            }

            public CompletableFuture<?> isBlocked() {
                return CompletableFuture.completedFuture(null);
            }

            public boolean isComplete() {
                return true;
            }

            public boolean isAwaitable() {
                return false;
            }

            public TupleDomain<ColumnHandle> getCurrentPredicate() {
                return tupleDomain;
            }
        };
    }
}

