/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.io.Resources;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.orc.OrcReaderOptions;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.orc.OriginalFilesUtils;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.testing.TestingConnectorSession;
import java.util.ArrayList;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOriginalFilesUtils {
    private final Location tablePath = Location.of((String)Resources.getResource((String)"dummy_id_data_orc").toString());

    @Test
    public void testGetPrecedingRowCountSingleFile() {
        ArrayList<AcidInfo.OriginalFileInfo> originalFileInfoList = new ArrayList<AcidInfo.OriginalFileInfo>();
        originalFileInfoList.add(new AcidInfo.OriginalFileInfo("000001_0", 730L));
        long rowCountResult = OriginalFilesUtils.getPrecedingRowCount(originalFileInfoList, (Location)this.tablePath.appendPath("000001_0"), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, (ConnectorIdentity)TestingConnectorSession.SESSION.getIdentity(), (OrcReaderOptions)new OrcReaderOptions(), (FileFormatDataSourceStats)new FileFormatDataSourceStats());
        ((AbstractLongAssert)Assertions.assertThat((long)rowCountResult).describedAs("Original file should have 0 as the starting row count", new Object[0])).isEqualTo(0L);
    }

    @Test
    public void testGetPrecedingRowCount() {
        ArrayList<AcidInfo.OriginalFileInfo> originalFileInfos = new ArrayList<AcidInfo.OriginalFileInfo>();
        originalFileInfos.add(new AcidInfo.OriginalFileInfo("000002_0", 741L));
        originalFileInfos.add(new AcidInfo.OriginalFileInfo("000002_0_copy_1", 768L));
        originalFileInfos.add(new AcidInfo.OriginalFileInfo("000002_0_copy_2", 743L));
        long rowCountResult = OriginalFilesUtils.getPrecedingRowCount(originalFileInfos, (Location)this.tablePath.appendPath("000002_0_copy_2"), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, (ConnectorIdentity)TestingConnectorSession.SESSION.getIdentity(), (OrcReaderOptions)new OrcReaderOptions(), (FileFormatDataSourceStats)new FileFormatDataSourceStats());
        ((AbstractLongAssert)Assertions.assertThat((long)rowCountResult).describedAs("Original file 000002_0_copy_2 should have 8 as the starting row count", new Object[0])).isEqualTo(8L);
    }
}

