/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPartitionDrops
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return ((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.max-partition-drops-per-query", (Object)"4")).setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.NATION)))).build();
    }

    @Test
    public void testPartitionDropsLimit() {
        this.assertUpdate("CREATE TABLE test_partitioned_table (a BIGINT, b BIGINT) WITH (partitioned_by = ARRAY['b'])");
        this.assertUpdate("INSERT INTO test_partitioned_table VALUES (1,1), (2,2), (3,3), (4,4), (5,5)", 5L);
        this.assertQueryFails("DELETE FROM test_partitioned_table WHERE b <= 6", "Failed to drop partitions. The number of partitions to be dropped is greater than the maximum allowed partitions \\(4\\).");
        this.assertQuery("SELECT * FROM test_partitioned_table", "VALUES (1,1), (2,2), (3,3), (4,4), (5,5)");
        this.assertUpdate("DELETE FROM test_partitioned_table WHERE b <= 4");
        this.assertQuery("SELECT * FROM test_partitioned_table", "VALUES (5,5)");
        this.assertUpdate("DROP TABLE test_partitioned_table");
    }
}

