/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.TestHiveReaderProjectionsUtil;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReaderColumns {
    private static final List<String> TEST_COLUMN_NAMES = ImmutableList.of((Object)"col_bigint", (Object)"col_struct_of_primitives", (Object)"col_struct_of_non_primitives", (Object)"col_partition_key_1", (Object)"col_partition_key_2");
    private static final Map<String, Type> TEST_COLUMN_TYPES = ImmutableMap.builder().put((Object)"col_bigint", (Object)BigintType.BIGINT).put((Object)"col_struct_of_primitives", (Object)TestHiveReaderProjectionsUtil.ROWTYPE_OF_PRIMITIVES).put((Object)"col_struct_of_non_primitives", (Object)TestHiveReaderProjectionsUtil.ROWTYPE_OF_ROW_AND_PRIMITIVES).put((Object)"col_partition_key_1", (Object)BigintType.BIGINT).put((Object)"col_partition_key_2", (Object)BigintType.BIGINT).buildOrThrow();
    private static final Map<String, HiveColumnHandle> TEST_FULL_COLUMNS = TestHiveReaderProjectionsUtil.createTestFullColumns(TEST_COLUMN_NAMES, TEST_COLUMN_TYPES);

    @Test
    public void testNoProjections() {
        ArrayList<HiveColumnHandle> columns = new ArrayList<HiveColumnHandle>(TEST_FULL_COLUMNS.values());
        Optional mapping = HivePageSourceProvider.projectBaseColumns(columns);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)mapping.isEmpty()).describedAs("Full columns should not require any adaptation", new Object[0])).isTrue();
        mapping = HivePageSourceProvider.projectSufficientColumns(columns);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)mapping.isEmpty()).describedAs("Full columns should not require any adaptation", new Object[0])).isTrue();
    }

    @Test
    public void testBaseColumnsProjection() {
        ImmutableList columns = ImmutableList.of((Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_primitives"), (List<Integer>)ImmutableList.of((Object)0)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_primitives"), (List<Integer>)ImmutableList.of((Object)1)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_bigint"), (List<Integer>)ImmutableList.of()), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_non_primitives"), (List<Integer>)ImmutableList.of((Object)0, (Object)1)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_non_primitives"), (List<Integer>)ImmutableList.of((Object)0)));
        Optional mapping = HivePageSourceProvider.projectBaseColumns((List)columns);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)mapping.isPresent()).describedAs("Full columns should be created for corresponding projected columns", new Object[0])).isTrue();
        List readerColumns = (List)((ReaderColumns)mapping.get()).get().stream().map(HiveColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        for (int i = 0; i < columns.size(); ++i) {
            HiveColumnHandle column = (HiveColumnHandle)columns.get(i);
            int readerIndex = ((ReaderColumns)mapping.get()).getPositionForColumnAt(i);
            HiveColumnHandle readerColumn = (HiveColumnHandle)((ReaderColumns)mapping.get()).getForColumnAt(i);
            Assertions.assertThat((Object)column.getBaseColumn()).isEqualTo((Object)readerColumn);
            Assertions.assertThat((Object)((HiveColumnHandle)readerColumns.get(readerIndex))).isEqualTo((Object)readerColumn);
        }
    }

    @Test
    public void testProjectSufficientColumns() {
        ImmutableList columns = ImmutableList.of((Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_primitives"), (List<Integer>)ImmutableList.of((Object)0)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_primitives"), (List<Integer>)ImmutableList.of((Object)1)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_bigint"), (List<Integer>)ImmutableList.of()), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_non_primitives"), (List<Integer>)ImmutableList.of((Object)0, (Object)1)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_non_primitives"), (List<Integer>)ImmutableList.of((Object)0)));
        Optional readerProjections = HivePageSourceProvider.projectSufficientColumns((List)columns);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)readerProjections.isPresent()).describedAs("expected readerProjections to be present", new Object[0])).isTrue();
        Assertions.assertThat((Object)((ReaderColumns)readerProjections.get()).getForColumnAt(0)).isEqualTo(columns.get(0));
        Assertions.assertThat((Object)((ReaderColumns)readerProjections.get()).getForColumnAt(1)).isEqualTo(columns.get(1));
        Assertions.assertThat((Object)((ReaderColumns)readerProjections.get()).getForColumnAt(2)).isEqualTo(columns.get(2));
        Assertions.assertThat((Object)((ReaderColumns)readerProjections.get()).getForColumnAt(3)).isEqualTo(columns.get(4));
        Assertions.assertThat((Object)((ReaderColumns)readerProjections.get()).getForColumnAt(4)).isEqualTo(columns.get(4));
        Assertions.assertThat((int)((ReaderColumns)readerProjections.get()).getPositionForColumnAt(0)).isEqualTo(0);
        Assertions.assertThat((int)((ReaderColumns)readerProjections.get()).getPositionForColumnAt(1)).isEqualTo(1);
        Assertions.assertThat((int)((ReaderColumns)readerProjections.get()).getPositionForColumnAt(2)).isEqualTo(2);
        Assertions.assertThat((int)((ReaderColumns)readerProjections.get()).getPositionForColumnAt(3)).isEqualTo(3);
        Assertions.assertThat((int)((ReaderColumns)readerProjections.get()).getPositionForColumnAt(4)).isEqualTo(3);
        List readerColumns = (List)((ReaderColumns)readerProjections.get()).get().stream().map(HiveColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((Object)((HiveColumnHandle)readerColumns.get(0))).isEqualTo(columns.get(0));
        Assertions.assertThat((Object)((HiveColumnHandle)readerColumns.get(1))).isEqualTo(columns.get(1));
        Assertions.assertThat((Object)((HiveColumnHandle)readerColumns.get(2))).isEqualTo(columns.get(2));
        Assertions.assertThat((Object)((HiveColumnHandle)readerColumns.get(3))).isEqualTo(columns.get(4));
    }
}

