/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.block.BlockAssertions;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderProjectionsAdapter;
import io.trino.plugin.hive.TestHiveReaderProjectionsUtil;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReaderProjectionsAdapter {
    private static final String TEST_COLUMN_NAME = "col";
    private static final Type TEST_COLUMN_TYPE = TestHiveReaderProjectionsUtil.ROWTYPE_OF_ROW_AND_PRIMITIVES;
    private static final Map<String, HiveColumnHandle> TEST_FULL_COLUMNS = TestHiveReaderProjectionsUtil.createTestFullColumns((List<String>)ImmutableList.of((Object)"col"), (Map<String, Type>)ImmutableMap.of((Object)"col", (Object)TEST_COLUMN_TYPE));

    @Test
    public void testAdaptPage() {
        ImmutableList columns = ImmutableList.of((Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get(TEST_COLUMN_NAME), (List<Integer>)ImmutableList.of((Object)0, (Object)0)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get(TEST_COLUMN_NAME), (List<Integer>)ImmutableList.of((Object)0)));
        Optional readerProjections = HivePageSourceProvider.projectBaseColumns((List)columns);
        ArrayList<RowData> inputBlockData = new ArrayList<RowData>();
        inputBlockData.add(RowData.rowData(RowData.rowData(11L, 12L, 13L), 1L));
        inputBlockData.add(RowData.rowData(null, 2L));
        inputBlockData.add(null);
        inputBlockData.add(RowData.rowData(RowData.rowData(31L, 32L, 33L), 3L));
        ReaderProjectionsAdapter adapter = new ReaderProjectionsAdapter((List)columns.stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), (ReaderColumns)readerProjections.get(), column -> ((HiveColumnHandle)column).getType(), HivePageSourceProvider::getProjection);
        this.verifyPageAdaptation(adapter, (List<List<Object>>)ImmutableList.of(inputBlockData));
    }

    @Test
    public void testLazyDereferenceProjectionLoading() {
        ImmutableList columns = ImmutableList.of((Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get(TEST_COLUMN_NAME), (List<Integer>)ImmutableList.of((Object)0, (Object)0)));
        ArrayList<RowData> inputBlockData = new ArrayList<RowData>();
        inputBlockData.add(RowData.rowData(RowData.rowData(11L, 12L, 13L), 1L));
        inputBlockData.add(RowData.rowData(null, 2L));
        inputBlockData.add(null);
        inputBlockData.add(RowData.rowData(RowData.rowData(31L, 32L, 33L), 3L));
        Optional readerProjections = HivePageSourceProvider.projectBaseColumns((List)columns);
        ReaderProjectionsAdapter adapter = new ReaderProjectionsAdapter((List)columns.stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), (ReaderColumns)readerProjections.get(), column -> ((HiveColumnHandle)column).getType(), HivePageSourceProvider::getProjection);
        Page inputPage = TestReaderProjectionsAdapter.createPage((List<List<Object>>)ImmutableList.of(inputBlockData), adapter.getInputTypes());
        adapter.adaptPage(inputPage).getLoadedPage();
        Block lazyBlockLevel1 = inputPage.getBlock(0);
        Assertions.assertThat((boolean)(lazyBlockLevel1 instanceof LazyBlock)).isTrue();
        Assertions.assertThat((boolean)lazyBlockLevel1.isLoaded()).isFalse();
        RowBlock rowBlockLevel1 = (RowBlock)((LazyBlock)lazyBlockLevel1).getBlock();
        Assertions.assertThat((boolean)rowBlockLevel1.isLoaded()).isFalse();
        Assertions.assertThat((boolean)rowBlockLevel1.getFieldBlock(0).isLoaded()).isFalse();
        Assertions.assertThat((boolean)rowBlockLevel1.getFieldBlock(1).isLoaded()).isFalse();
        Block lazyBlockLevel2 = rowBlockLevel1.getFieldBlock(0);
        Assertions.assertThat((boolean)(lazyBlockLevel2 instanceof LazyBlock)).isTrue();
        RowBlock rowBlockLevel2 = (RowBlock)((LazyBlock)lazyBlockLevel2).getBlock();
        Assertions.assertThat((boolean)rowBlockLevel2.isLoaded()).isFalse();
        Assertions.assertThat((boolean)rowBlockLevel2.getFieldBlock(0).isLoaded()).isTrue();
        Assertions.assertThat((boolean)rowBlockLevel2.getFieldBlock(1).isLoaded()).isFalse();
    }

    private void verifyPageAdaptation(ReaderProjectionsAdapter adapter, List<List<Object>> inputPageData) {
        List columnMapping = adapter.getOutputToInputMapping();
        List outputTypes = adapter.getOutputTypes();
        List inputTypes = adapter.getInputTypes();
        Page inputPage = TestReaderProjectionsAdapter.createPage(inputPageData, inputTypes);
        Page outputPage = adapter.adaptPage(inputPage).getLoadedPage();
        for (int i = 0; i < columnMapping.size(); ++i) {
            ReaderProjectionsAdapter.ChannelMapping mapping = (ReaderProjectionsAdapter.ChannelMapping)columnMapping.get(i);
            int inputBlockIndex = mapping.getInputChannelIndex();
            TestReaderProjectionsAdapter.verifyBlock(outputPage.getBlock(i), (Type)outputTypes.get(i), inputPage.getBlock(inputBlockIndex), (Type)inputTypes.get(inputBlockIndex), mapping.getDereferenceSequence());
        }
    }

    private static Page createPage(List<List<Object>> pageData, List<Type> types) {
        Block[] inputPageBlocks = new Block[pageData.size()];
        for (int i = 0; i < inputPageBlocks.length; ++i) {
            inputPageBlocks[i] = TestReaderProjectionsAdapter.createInputBlock(pageData.get(i), types.get(i));
        }
        return new Page(inputPageBlocks);
    }

    private static Block createInputBlock(List<Object> data, Type type) {
        int positionCount = data.size();
        if (type instanceof RowType) {
            return new LazyBlock(data.size(), () -> TestReaderProjectionsAdapter.createRowBlockWithLazyNestedBlocks(data, (RowType)type));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return new LazyBlock(positionCount, () -> TestReaderProjectionsAdapter.createLongArrayBlock(data));
        }
        throw new UnsupportedOperationException();
    }

    private static Block createRowBlockWithLazyNestedBlocks(List<Object> data, RowType rowType) {
        int positionCount = data.size();
        boolean[] isNull = new boolean[positionCount];
        int fieldCount = rowType.getFields().size();
        ArrayList fieldsData = new ArrayList();
        for (int i = 0; i < fieldCount; ++i) {
            fieldsData.add(new ArrayList());
        }
        for (int position = 0; position < data.size(); ++position) {
            int field;
            RowData row = (RowData)data.get(position);
            if (row == null) {
                isNull[position] = true;
                for (field = 0; field < fieldCount; ++field) {
                    ((List)fieldsData.get(field)).add(null);
                }
                continue;
            }
            for (field = 0; field < fieldCount; ++field) {
                ((List)fieldsData.get(field)).add(row.getField(field));
            }
        }
        Block[] fieldBlocks = new Block[fieldCount];
        for (int field = 0; field < fieldCount; ++field) {
            fieldBlocks[field] = TestReaderProjectionsAdapter.createInputBlock((List)fieldsData.get(field), ((RowType.Field)rowType.getFields().get(field)).getType());
        }
        return RowBlock.fromNotNullSuppressedFieldBlocks((int)positionCount, Optional.of(isNull), (Block[])fieldBlocks);
    }

    private static Block createLongArrayBlock(List<Object> data) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(data.size());
        for (int i = 0; i < data.size(); ++i) {
            Long value = (Long)data.get(i);
            if (value == null) {
                builder.appendNull();
                continue;
            }
            BigintType.BIGINT.writeLong(builder, value.longValue());
        }
        return builder.build();
    }

    private static void verifyBlock(Block actualBlock, Type outputType, Block input, Type inputType, List<Integer> dereferences) {
        Assertions.assertThat((Object)inputType).isInstanceOf(RowType.class);
        Block expectedOutputBlock = TestReaderProjectionsAdapter.createProjectedColumnBlock(input, outputType, (RowType)inputType, dereferences);
        BlockAssertions.assertBlockEquals((Type)outputType, (Block)actualBlock, (Block)expectedOutputBlock);
    }

    private static Block createProjectedColumnBlock(Block data, Type finalType, RowType blockType, List<Integer> dereferences) {
        if (dereferences.isEmpty()) {
            return data;
        }
        BlockBuilder builder = finalType.createBlockBuilder(null, data.getPositionCount());
        for (int i = 0; i < data.getPositionCount(); ++i) {
            RowType sourceType = blockType;
            SqlRow currentData = null;
            boolean isNull = data.isNull(i);
            if (!isNull) {
                currentData = sourceType.getObject(data, i);
            }
            for (int j = 0; j < dereferences.size() - 1 && !isNull; ++j) {
                int fieldIndex = dereferences.get(j);
                Block fieldBlock = currentData.getRawFieldBlock(fieldIndex);
                RowType rowType = sourceType;
                int rawIndex = currentData.getRawIndex();
                if (fieldBlock.isNull(rawIndex)) {
                    currentData = null;
                } else {
                    sourceType = (RowType)((RowType.Field)rowType.getFields().get(fieldIndex)).getType();
                    currentData = sourceType.getObject(fieldBlock, rawIndex);
                }
                isNull = isNull || currentData == null;
            }
            if (isNull) {
                builder.appendNull();
                continue;
            }
            int lastDereference = dereferences.getLast();
            finalType.appendTo(currentData.getRawFieldBlock(lastDereference), currentData.getRawIndex(), builder);
        }
        return builder.build();
    }

    static class RowData {
        private final List<? extends Object> data;

        private RowData(Object ... data) {
            this.data = Arrays.asList(Objects.requireNonNull(data, "data is null"));
        }

        static RowData rowData(Object ... data) {
            return new RowData(data);
        }

        Object getField(int field) {
            Preconditions.checkArgument((field >= 0 && field < this.data.size() ? 1 : 0) != 0);
            return this.data.get(field);
        }
    }
}

