/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.SortingFileWriterConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestSortingFileWriterConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((SortingFileWriterConfig)ConfigAssertions.recordDefaults(SortingFileWriterConfig.class)).setWriterSortBufferSize(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxOpenSortFiles(50));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"writer-sort-buffer-size", (Object)"1GB").put((Object)"max-open-sort-files", (Object)"3").buildOrThrow();
        SortingFileWriterConfig expected = new SortingFileWriterConfig().setWriterSortBufferSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setMaxOpenSortFiles(3);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

