/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.inject.Injector;
import com.google.inject.Key;
import io.trino.plugin.hive.HiveConnector;
import io.trino.testing.PlanTester;
import io.trino.testing.QueryRunner;

public final class TestingHiveUtils {
    private TestingHiveUtils() {
    }

    public static <T> T getConnectorService(PlanTester planTester, Class<T> clazz) {
        return (T)((HiveConnector)planTester.getConnector("hive")).getInjector().getInstance(clazz);
    }

    public static <T> T getConnectorService(QueryRunner queryRunner, Class<T> clazz) {
        return (T)TestingHiveUtils.getConnectorInjector(queryRunner).getInstance(clazz);
    }

    public static <T> T getConnectorService(QueryRunner queryRunner, Key<T> key) {
        return (T)TestingHiveUtils.getConnectorInjector(queryRunner).getInstance(key);
    }

    private static Injector getConnectorInjector(QueryRunner queryRunner) {
        return ((HiveConnector)queryRunner.getCoordinator().getConnector("hive")).getInjector();
    }
}

