/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.plugin.base.security.UserNameProvider;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.IdentityAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.MetastoreClientAdapterProvider;
import io.trino.plugin.hive.metastore.thrift.TestingTokenAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.TokenAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.UgiBasedMetastoreClientFactory;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public final class TestingThriftHiveMetastoreBuilder {
    private TokenAwareMetastoreClientFactory tokenAwareMetastoreClientFactory;
    private ThriftMetastoreConfig thriftMetastoreConfig = new ThriftMetastoreConfig();
    private TrinoFileSystemFactory fileSystemFactory = new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS);

    public static TestingThriftHiveMetastoreBuilder testingThriftHiveMetastoreBuilder() {
        return new TestingThriftHiveMetastoreBuilder();
    }

    private TestingThriftHiveMetastoreBuilder() {
    }

    public TestingThriftHiveMetastoreBuilder metastoreClient(URI metastoreUri) {
        Objects.requireNonNull(metastoreUri, "metastoreUri is null");
        Preconditions.checkState((this.tokenAwareMetastoreClientFactory == null ? 1 : 0) != 0, (Object)"Metastore client already set");
        this.tokenAwareMetastoreClientFactory = new TestingTokenAwareMetastoreClientFactory(HiveTestUtils.SOCKS_PROXY, metastoreUri);
        return this;
    }

    public TestingThriftHiveMetastoreBuilder metastoreClient(URI address, Duration timeout) {
        Objects.requireNonNull(address, "address is null");
        Objects.requireNonNull(timeout, "timeout is null");
        Preconditions.checkState((this.tokenAwareMetastoreClientFactory == null ? 1 : 0) != 0, (Object)"Metastore client already set");
        this.tokenAwareMetastoreClientFactory = new TestingTokenAwareMetastoreClientFactory(HiveTestUtils.SOCKS_PROXY, address, timeout);
        return this;
    }

    public TestingThriftHiveMetastoreBuilder metastoreClient(URI uri, MetastoreClientAdapterProvider metastoreClientAdapterProvider) {
        Objects.requireNonNull(uri, "uri is null");
        Preconditions.checkState((this.tokenAwareMetastoreClientFactory == null ? 1 : 0) != 0, (Object)"Metastore client already set");
        this.tokenAwareMetastoreClientFactory = new TestingTokenAwareMetastoreClientFactory(HiveTestUtils.SOCKS_PROXY, uri, TestingTokenAwareMetastoreClientFactory.TIMEOUT, metastoreClientAdapterProvider);
        return this;
    }

    public TestingThriftHiveMetastoreBuilder metastoreClient(ThriftMetastoreClient client) {
        Objects.requireNonNull(client, "client is null");
        Preconditions.checkState((this.tokenAwareMetastoreClientFactory == null ? 1 : 0) != 0, (Object)"Metastore client already set");
        this.tokenAwareMetastoreClientFactory = token -> client;
        return this;
    }

    public TestingThriftHiveMetastoreBuilder thriftMetastoreConfig(ThriftMetastoreConfig thriftMetastoreConfig) {
        this.thriftMetastoreConfig = Objects.requireNonNull(thriftMetastoreConfig, "thriftMetastoreConfig is null");
        return this;
    }

    public TestingThriftHiveMetastoreBuilder fileSystemFactory(TrinoFileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        return this;
    }

    public ThriftMetastore build(Consumer<AutoCloseable> registerResource) {
        Preconditions.checkState((this.tokenAwareMetastoreClientFactory != null ? 1 : 0) != 0, (Object)"metastore client not set");
        ExecutorService executorService = Executors.newFixedThreadPool(this.thriftMetastoreConfig.getWriteStatisticsThreads());
        registerResource.accept(executorService);
        ThriftHiveMetastoreFactory metastoreFactory = new ThriftHiveMetastoreFactory((IdentityAwareMetastoreClientFactory)new UgiBasedMetastoreClientFactory(this.tokenAwareMetastoreClientFactory, UserNameProvider.SIMPLE_USER_NAME_PROVIDER, this.thriftMetastoreConfig), new HiveMetastoreConfig().isHideDeltaLakeTables(), this.thriftMetastoreConfig, this.fileSystemFactory, executorService);
        return metastoreFactory.createMetastore(Optional.empty());
    }
}

