/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.avro;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.local.LocalFileSystem;
import io.trino.metastore.HiveType;
import io.trino.metastore.type.TypeInfo;
import io.trino.plugin.hive.avro.AvroHiveFileUtils;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAvroSchemaGeneration {
    @Test
    public void testOldVsNewSchemaGeneration() throws Exception {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"name", (Object)"testingTable").put((Object)"columns", (Object)"a,b").put((Object)"columns.types", (Object)Stream.of(HiveType.HIVE_INT, HiveType.HIVE_STRING).map(HiveType::getTypeInfo).map(TypeInfo::toString).collect(Collectors.joining(","))).buildOrThrow();
        Schema actual = AvroHiveFileUtils.determineSchemaOrThrowException((TrinoFileSystem)new LocalFileSystem(Path.of("/", new String[0])), (Map)properties);
        Schema expected = AvroSerdeUtils.determineSchemaOrThrowException((Configuration)new Configuration(false), (Properties)TestAvroSchemaGeneration.toProperties((Map<String, String>)properties));
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testOldVsNewSchemaGenerationWithNested() throws Exception {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"name", (Object)"testingTable").put((Object)"columns", (Object)"a,b").put((Object)"columns.types", (Object)(String.valueOf(HiveTypeTranslator.toHiveType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)VarcharType.VARCHAR)}))) + "," + String.valueOf(HiveType.HIVE_STRING))).buildOrThrow();
        Schema actual = AvroHiveFileUtils.determineSchemaOrThrowException((TrinoFileSystem)new LocalFileSystem(Path.of("/", new String[0])), (Map)properties);
        Schema expected = AvroSerdeUtils.determineSchemaOrThrowException((Configuration)new Configuration(false), (Properties)TestAvroSchemaGeneration.toProperties((Map<String, String>)properties));
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    private static Properties toProperties(Map<String, String> properties) {
        Properties hiveProperties = new Properties();
        hiveProperties.putAll(properties);
        return hiveProperties;
    }
}

