/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBooleanCoercer {
    @Test
    public void testBooleanToVarchar() {
        this.assertBooleanToVarcharCoercion((Type)VarcharType.createUnboundedVarcharType(), true, Slices.utf8Slice((String)"TRUE"));
        this.assertBooleanToVarcharCoercion((Type)VarcharType.createUnboundedVarcharType(), false, Slices.utf8Slice((String)"FALSE"));
    }

    @Test
    public void testBooleanToLowerBoundedVarchar() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertBooleanToVarcharCoercion((Type)VarcharType.createVarcharType((int)1), true, Slices.utf8Slice((String)"T"))).isInstanceOf(TrinoException.class)).hasMessageContaining("Varchar representation of true exceeds varchar(1) bounds");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertBooleanToVarcharCoercion((Type)VarcharType.createVarcharType((int)1), false, Slices.utf8Slice((String)"F"))).isInstanceOf(TrinoException.class)).hasMessageContaining("Varchar representation of false exceeds varchar(1) bounds");
    }

    @Test
    public void testVarcharToBoolean() {
        this.assertVarcharToBooleanCoercion("FALSE", false);
        this.assertVarcharToBooleanCoercion("OFF", false);
        this.assertVarcharToBooleanCoercion("NO", false);
        this.assertVarcharToBooleanCoercion("0", false);
        this.assertVarcharToBooleanCoercion("", false);
        this.assertVarcharToBooleanCoercion("FAlSE", false);
        this.assertVarcharToBooleanCoercion("OfF", false);
        this.assertVarcharToBooleanCoercion("nO", false);
        this.assertVarcharToBooleanCoercion("no", false);
        this.assertVarcharToBooleanCoercion("YES", true);
        this.assertVarcharToBooleanCoercion("TRUE", true);
        this.assertVarcharToBooleanCoercion("TR", true);
        this.assertVarcharToBooleanCoercion("T", true);
        this.assertVarcharToBooleanCoercion("Y", true);
        this.assertVarcharToBooleanCoercion("1", true);
        this.assertVarcharToBooleanCoercion("-1", true);
        this.assertVarcharToBooleanCoercion("-123", true);
        this.assertVarcharToBooleanCoercion("123", true);
        this.assertVarcharToBooleanCoercion("FALSEE", true);
        this.assertVarcharToBooleanCoercion("OFFF", true);
        this.assertVarcharToBooleanCoercion("NO0", true);
        this.assertVarcharToBooleanCoercion("00", true);
    }

    @Test
    public void testVarcharToBooleanForOrc() {
        this.assertVarcharToBooleanCoercion("0", HiveStorageFormat.ORC, false);
        this.assertVarcharToBooleanCoercion("-0", HiveStorageFormat.ORC, false);
        this.assertVarcharToBooleanCoercion("00", HiveStorageFormat.ORC, false);
        this.assertVarcharToBooleanCoercion("1", HiveStorageFormat.ORC, true);
        this.assertVarcharToBooleanCoercion("-1", HiveStorageFormat.ORC, true);
        this.assertVarcharToBooleanCoercion("-123", HiveStorageFormat.ORC, true);
        this.assertVarcharToBooleanCoercion("123", HiveStorageFormat.ORC, true);
        this.assertVarcharToBooleanCoercion("FALSE", HiveStorageFormat.ORC, null);
        this.assertVarcharToBooleanCoercion("OFF", HiveStorageFormat.ORC, null);
        this.assertVarcharToBooleanCoercion("NO", HiveStorageFormat.ORC, null);
        this.assertVarcharToBooleanCoercion("T", HiveStorageFormat.ORC, null);
        this.assertVarcharToBooleanCoercion("Y", HiveStorageFormat.ORC, null);
    }

    private void assertBooleanToVarcharCoercion(Type toType, boolean valueToBeCoerced, Slice expectedValue) {
        Block coercedValue = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)BooleanType.BOOLEAN), (HiveType)HiveTypeTranslator.toHiveType((Type)toType), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, HiveStorageFormat.PARQUET)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)BooleanType.BOOLEAN, (Object)valueToBeCoerced));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)toType, (Block)coercedValue)).isEqualTo((Object)expectedValue);
    }

    private void assertVarcharToBooleanCoercion(String valueToBeCoerced, Boolean expectedValue) {
        this.assertVarcharToBooleanCoercion(valueToBeCoerced, HiveStorageFormat.PARQUET, expectedValue);
    }

    private void assertVarcharToBooleanCoercion(String valueToBeCoerced, HiveStorageFormat storageFormat, Boolean expectedValue) {
        Block coercedValue = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)VarcharType.createUnboundedVarcharType()), (HiveType)HiveTypeTranslator.toHiveType((Type)BooleanType.BOOLEAN), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, storageFormat)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)valueToBeCoerced)));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)BooleanType.BOOLEAN, (Block)coercedValue)).isEqualTo((Object)expectedValue);
    }
}

