/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.TestingSession;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIntegerNumberToVarcharCoercer {
    @Test
    public void testTinyintToVarcharCoercions() {
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercionForNull((Type)TinyintType.TINYINT, (Type)VarcharType.VARCHAR);
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercionForNull((Type)TinyintType.TINYINT, (Type)VarcharType.createVarcharType((int)1));
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)TinyintType.TINYINT, 0L, (Type)VarcharType.VARCHAR, "0");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)TinyintType.TINYINT, 0L, (Type)VarcharType.createVarcharType((int)1), "0");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)TinyintType.TINYINT, -1L, (Type)VarcharType.VARCHAR, "-1");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)TinyintType.TINYINT, -1L, (Type)VarcharType.createVarcharType((int)2), "-1");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)TinyintType.TINYINT, 1L, (Type)VarcharType.VARCHAR, "1");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)TinyintType.TINYINT, 1L, (Type)VarcharType.createVarcharType((int)1), "1");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)TinyintType.TINYINT, 127L, (Type)VarcharType.VARCHAR, "127");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)TinyintType.TINYINT, 127L, (Type)VarcharType.createVarcharType((int)3), "127");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)TinyintType.TINYINT, -128L, (Type)VarcharType.VARCHAR, "-128");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)TinyintType.TINYINT, -128L, (Type)VarcharType.createVarcharType((int)4), "-128");
    }

    @Test
    public void testSmallintToVarcharCoercions() {
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercionForNull((Type)TinyintType.TINYINT, (Type)VarcharType.VARCHAR);
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercionForNull((Type)TinyintType.TINYINT, (Type)VarcharType.createVarcharType((int)1));
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)SmallintType.SMALLINT, 0L, (Type)VarcharType.VARCHAR, "0");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)SmallintType.SMALLINT, 0L, (Type)VarcharType.createVarcharType((int)1), "0");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)SmallintType.SMALLINT, -129L, (Type)VarcharType.VARCHAR, "-129");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)SmallintType.SMALLINT, -129L, (Type)VarcharType.createVarcharType((int)4), "-129");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)SmallintType.SMALLINT, 128L, (Type)VarcharType.VARCHAR, "128");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)SmallintType.SMALLINT, 128L, (Type)VarcharType.createVarcharType((int)3), "128");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)SmallintType.SMALLINT, 32767L, (Type)VarcharType.VARCHAR, "32767");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)SmallintType.SMALLINT, 32767L, (Type)VarcharType.createVarcharType((int)5), "32767");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)SmallintType.SMALLINT, -32768L, (Type)VarcharType.VARCHAR, "-32768");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)SmallintType.SMALLINT, -32768L, (Type)VarcharType.createVarcharType((int)6), "-32768");
    }

    @Test
    public void testIntegerToVarcharCoercions() {
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercionForNull((Type)TinyintType.TINYINT, (Type)VarcharType.VARCHAR);
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercionForNull((Type)TinyintType.TINYINT, (Type)VarcharType.createVarcharType((int)1));
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)IntegerType.INTEGER, 0L, (Type)VarcharType.VARCHAR, "0");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)IntegerType.INTEGER, 0L, (Type)VarcharType.createVarcharType((int)1), "0");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)IntegerType.INTEGER, -32768L, (Type)VarcharType.VARCHAR, "-32768");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)IntegerType.INTEGER, -32769L, (Type)VarcharType.createVarcharType((int)6), "-32769");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)IntegerType.INTEGER, 32768L, (Type)VarcharType.VARCHAR, "32768");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)IntegerType.INTEGER, 32768L, (Type)VarcharType.createVarcharType((int)5), "32768");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)IntegerType.INTEGER, Integer.MAX_VALUE, (Type)VarcharType.VARCHAR, "2147483647");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)IntegerType.INTEGER, Integer.MAX_VALUE, (Type)VarcharType.createVarcharType((int)10), "2147483647");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)IntegerType.INTEGER, Integer.MIN_VALUE, (Type)VarcharType.VARCHAR, "-2147483648");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)IntegerType.INTEGER, Integer.MIN_VALUE, (Type)VarcharType.createVarcharType((int)11), "-2147483648");
    }

    @Test
    public void testBigintToVarcharCoercions() {
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercionForNull((Type)TinyintType.TINYINT, (Type)VarcharType.VARCHAR);
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercionForNull((Type)TinyintType.TINYINT, (Type)VarcharType.createVarcharType((int)1));
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)BigintType.BIGINT, 0L, (Type)VarcharType.VARCHAR, "0");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)BigintType.BIGINT, 0L, (Type)VarcharType.createVarcharType((int)1), "0");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)BigintType.BIGINT, Integer.MIN_VALUE, (Type)VarcharType.VARCHAR, "-2147483648");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)BigintType.BIGINT, -2147483649L, (Type)VarcharType.createVarcharType((int)11), "-2147483649");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)BigintType.BIGINT, Integer.MAX_VALUE, (Type)VarcharType.VARCHAR, "2147483647");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)BigintType.BIGINT, 0x80000000L, (Type)VarcharType.createVarcharType((int)10), "2147483648");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)BigintType.BIGINT, Long.MAX_VALUE, (Type)VarcharType.VARCHAR, "9223372036854775807");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)BigintType.BIGINT, Long.MAX_VALUE, (Type)VarcharType.createVarcharType((int)19), "9223372036854775807");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)BigintType.BIGINT, Long.MIN_VALUE, (Type)VarcharType.VARCHAR, "-9223372036854775808");
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion((Type)BigintType.BIGINT, Long.MIN_VALUE, (Type)VarcharType.createVarcharType((int)20), "-9223372036854775808");
    }

    @Test
    public void testIntegerNumberToLowerBoundVarcharCoercions() {
        TestIntegerNumberToVarcharCoercer.assertCoercionFailureForLowerBoundedVarchar((Type)TinyintType.TINYINT, -1L, (Type)VarcharType.createVarcharType((int)1));
        TestIntegerNumberToVarcharCoercer.assertCoercionFailureForLowerBoundedVarchar((Type)TinyintType.TINYINT, 127L, (Type)VarcharType.createVarcharType((int)2));
        TestIntegerNumberToVarcharCoercer.assertCoercionFailureForLowerBoundedVarchar((Type)TinyintType.TINYINT, -128L, (Type)VarcharType.createVarcharType((int)3));
        TestIntegerNumberToVarcharCoercer.assertCoercionFailureForLowerBoundedVarchar((Type)SmallintType.SMALLINT, -1L, (Type)VarcharType.createVarcharType((int)1));
        TestIntegerNumberToVarcharCoercer.assertCoercionFailureForLowerBoundedVarchar((Type)SmallintType.SMALLINT, 32767L, (Type)VarcharType.createVarcharType((int)4));
        TestIntegerNumberToVarcharCoercer.assertCoercionFailureForLowerBoundedVarchar((Type)SmallintType.SMALLINT, -32768L, (Type)VarcharType.createVarcharType((int)5));
        TestIntegerNumberToVarcharCoercer.assertCoercionFailureForLowerBoundedVarchar((Type)IntegerType.INTEGER, -1L, (Type)VarcharType.createVarcharType((int)1));
        TestIntegerNumberToVarcharCoercer.assertCoercionFailureForLowerBoundedVarchar((Type)IntegerType.INTEGER, Integer.MAX_VALUE, (Type)VarcharType.createVarcharType((int)9));
        TestIntegerNumberToVarcharCoercer.assertCoercionFailureForLowerBoundedVarchar((Type)IntegerType.INTEGER, Integer.MIN_VALUE, (Type)VarcharType.createVarcharType((int)10));
        TestIntegerNumberToVarcharCoercer.assertCoercionFailureForLowerBoundedVarchar((Type)BigintType.BIGINT, -1L, (Type)VarcharType.createVarcharType((int)1));
        TestIntegerNumberToVarcharCoercer.assertCoercionFailureForLowerBoundedVarchar((Type)BigintType.BIGINT, Long.MAX_VALUE, (Type)VarcharType.createVarcharType((int)18));
        TestIntegerNumberToVarcharCoercer.assertCoercionFailureForLowerBoundedVarchar((Type)BigintType.BIGINT, Long.MIN_VALUE, (Type)VarcharType.createVarcharType((int)19));
    }

    private static void assertIntegerNumberToVarcharCoercion(Type actualType, long actualValue, Type expectedType, String expectedValue) {
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion(actualType, actualValue, HiveStorageFormat.ORC, expectedType, expectedValue);
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion(actualType, actualValue, HiveStorageFormat.PARQUET, expectedType, expectedValue);
    }

    private static void assertIntegerNumberToVarcharCoercionForNull(Type actualType, Type expectedType) {
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion(actualType, null, HiveStorageFormat.ORC, expectedType, null);
        TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion(actualType, null, HiveStorageFormat.PARQUET, expectedType, null);
    }

    private static void assertCoercionFailureForLowerBoundedVarchar(Type actualType, long actualValue, Type expectedType) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestIntegerNumberToVarcharCoercer.assertIntegerNumberToVarcharCoercion(actualType, actualValue, HiveStorageFormat.ORC, expectedType, String.valueOf(actualValue))).isInstanceOf(TrinoException.class)).hasMessage("Varchar representation of %s exceeds %s bounds".formatted(actualValue, expectedType));
    }

    private static void assertIntegerNumberToVarcharCoercion(Type actualType, Object actualValue, HiveStorageFormat storageFormat, Type expectedType, String expectedValue) {
        Block coercedBlock = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)actualType), (HiveType)HiveTypeTranslator.toHiveType((Type)expectedType), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, storageFormat)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)actualType, (Object)actualValue));
        Object coercedValue = coercedBlock.isNull(0) ? null : expectedType.getObjectValue(TestingSession.SESSION, coercedBlock, 0);
        Assertions.assertThat(coercedValue).isEqualTo((Object)expectedValue);
    }
}

