/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slices;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.block.Block;
import io.trino.spi.block.TestingSession;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVarcharToIntegralNumericCoercer {
    @Test
    public void testVarcharToTinyintCoercions() {
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("0", (Type)TinyintType.TINYINT, (byte)0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-0", (Type)TinyintType.TINYINT, (byte)0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-1", (Type)TinyintType.TINYINT, (byte)-1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("+1", (Type)TinyintType.TINYINT, (byte)1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("127", (Type)TinyintType.TINYINT, (byte)127);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-128", (Type)TinyintType.TINYINT, (byte)-128);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("128", (Type)TinyintType.TINYINT, (byte)-128);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-129", (Type)TinyintType.TINYINT, (byte)127);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("2147483647", (Type)TinyintType.TINYINT, (byte)-1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("2147483648", (Type)TinyintType.TINYINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-2147483648", (Type)TinyintType.TINYINT, (byte)0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-2147483649", (Type)TinyintType.TINYINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("String", (Type)TinyintType.TINYINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("1s", (Type)TinyintType.TINYINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("1e+0", (Type)TinyintType.TINYINT, null);
    }

    @Test
    public void testVarcharToTinyintCoercionsForOrc() {
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("0", (Type)TinyintType.TINYINT, (byte)0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-0", (Type)TinyintType.TINYINT, (byte)0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-1", (Type)TinyintType.TINYINT, (byte)-1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("+1", (Type)TinyintType.TINYINT, (byte)1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("127", (Type)TinyintType.TINYINT, (byte)127);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-128", (Type)TinyintType.TINYINT, (byte)-128);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("128", (Type)TinyintType.TINYINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-129", (Type)TinyintType.TINYINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("2147483647", (Type)TinyintType.TINYINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("2147483648", (Type)TinyintType.TINYINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-2147483648", (Type)TinyintType.TINYINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-2147483649", (Type)TinyintType.TINYINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("String", (Type)TinyintType.TINYINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("1s", (Type)TinyintType.TINYINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("1e+0", (Type)TinyintType.TINYINT, null);
    }

    @Test
    public void testVarcharToSmallintCoercions() {
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("0", (Type)SmallintType.SMALLINT, (short)0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-0", (Type)SmallintType.SMALLINT, (short)0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-1", (Type)SmallintType.SMALLINT, (short)-1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("+1", (Type)SmallintType.SMALLINT, (short)1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("32767", (Type)SmallintType.SMALLINT, (short)Short.MAX_VALUE);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-32767", (Type)SmallintType.SMALLINT, (short)-32767);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("32768", (Type)SmallintType.SMALLINT, (short)Short.MIN_VALUE);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-32769", (Type)SmallintType.SMALLINT, (short)Short.MAX_VALUE);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("2147483647", (Type)SmallintType.SMALLINT, (short)-1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("2147483648", (Type)SmallintType.SMALLINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-2147483648", (Type)SmallintType.SMALLINT, (short)0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-2147483649", (Type)SmallintType.SMALLINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("String", (Type)SmallintType.SMALLINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("1s", (Type)SmallintType.SMALLINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("1e+0", (Type)SmallintType.SMALLINT, null);
    }

    @Test
    public void testVarcharToSmallintCoercionsForOrc() {
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("0", (Type)SmallintType.SMALLINT, (short)0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-0", (Type)SmallintType.SMALLINT, (short)0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-1", (Type)SmallintType.SMALLINT, (short)-1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("+1", (Type)SmallintType.SMALLINT, (short)1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("32767", (Type)SmallintType.SMALLINT, (short)Short.MAX_VALUE);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-32767", (Type)SmallintType.SMALLINT, (short)-32767);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("32768", (Type)SmallintType.SMALLINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-32769", (Type)SmallintType.SMALLINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("2147483647", (Type)SmallintType.SMALLINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("2147483648", (Type)SmallintType.SMALLINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-2147483648", (Type)SmallintType.SMALLINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-2147483649", (Type)SmallintType.SMALLINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("String", (Type)SmallintType.SMALLINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("1s", (Type)SmallintType.SMALLINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("1e+0", (Type)SmallintType.SMALLINT, null);
    }

    @Test
    public void testVarcharToIntegerCoercions() {
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("0", (Type)IntegerType.INTEGER, 0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-0", (Type)IntegerType.INTEGER, 0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-1", (Type)IntegerType.INTEGER, -1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("+1", (Type)IntegerType.INTEGER, 1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("2147483647", (Type)IntegerType.INTEGER, Integer.MAX_VALUE);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("2147483648", (Type)IntegerType.INTEGER, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-2147483648", (Type)IntegerType.INTEGER, Integer.MIN_VALUE);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-2147483649", (Type)IntegerType.INTEGER, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("String", (Type)IntegerType.INTEGER, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("1s", (Type)IntegerType.INTEGER, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("1e+0", (Type)IntegerType.INTEGER, null);
    }

    @Test
    public void testVarcharToIntegerCoercionsForOrc() {
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("0", (Type)IntegerType.INTEGER, 0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-0", (Type)IntegerType.INTEGER, 0);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-1", (Type)IntegerType.INTEGER, -1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("+1", (Type)IntegerType.INTEGER, 1);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("2147483647", (Type)IntegerType.INTEGER, Integer.MAX_VALUE);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("2147483648", (Type)IntegerType.INTEGER, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-2147483648", (Type)IntegerType.INTEGER, Integer.MIN_VALUE);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-2147483649", (Type)IntegerType.INTEGER, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("String", (Type)IntegerType.INTEGER, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("1s", (Type)IntegerType.INTEGER, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("1e+0", (Type)IntegerType.INTEGER, null);
    }

    @Test
    public void testVarcharToBigintCoercions() {
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("0", (Type)BigintType.BIGINT, 0L);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-0", (Type)BigintType.BIGINT, 0L);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-1", (Type)BigintType.BIGINT, -1L);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("+1", (Type)BigintType.BIGINT, 1L);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("9223372036854775807", (Type)BigintType.BIGINT, Long.MAX_VALUE);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-9223372036854775808", (Type)BigintType.BIGINT, Long.MIN_VALUE);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("9223372036854775808", (Type)BigintType.BIGINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("-9223372036854775809", (Type)BigintType.BIGINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("String", (Type)BigintType.BIGINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("1s", (Type)BigintType.BIGINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion("1e+0", (Type)BigintType.BIGINT, null);
    }

    @Test
    public void testVarcharToBigintCoercionsForOrc() {
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("0", (Type)BigintType.BIGINT, 0L);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-0", (Type)BigintType.BIGINT, 0L);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-1", (Type)BigintType.BIGINT, -1L);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("+1", (Type)BigintType.BIGINT, 1L);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("9223372036854775807", (Type)BigintType.BIGINT, Long.MAX_VALUE);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-9223372036854775808", (Type)BigintType.BIGINT, Long.MIN_VALUE);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("9223372036854775808", (Type)BigintType.BIGINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("-9223372036854775809", (Type)BigintType.BIGINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("String", (Type)BigintType.BIGINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("1s", (Type)BigintType.BIGINT, null);
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercionForOrc("1e+0", (Type)BigintType.BIGINT, null);
    }

    private static void assertVarcharToIntegralCoercion(String actualValue, Type expectedType, Object expectedValue) {
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion(actualValue, HiveStorageFormat.PARQUET, expectedType, expectedValue);
    }

    private static void assertVarcharToIntegralCoercionForOrc(String actualValue, Type expectedType, Object expectedValue) {
        TestVarcharToIntegralNumericCoercer.assertVarcharToIntegralCoercion(actualValue, HiveStorageFormat.ORC, expectedType, expectedValue);
    }

    private static void assertVarcharToIntegralCoercion(String actualValue, HiveStorageFormat storageFormat, Type expectedType, Object expectedValue) {
        Block coercedBlock = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveTypeTranslator.toHiveType((Type)VarcharType.createUnboundedVarcharType()), (HiveType)HiveTypeTranslator.toHiveType((Type)expectedType), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, storageFormat)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)actualValue)));
        Object coercedValue = coercedBlock.isNull(0) ? null : expectedType.getObjectValue(TestingSession.SESSION, coercedBlock, 0);
        Assertions.assertThat(coercedValue).isEqualTo(expectedValue);
    }
}

