/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.Session;
import io.trino.plugin.hive.metastore.MetastoreMethod;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import java.util.List;
import org.intellij.lang.annotations.Language;

public final class MetastoreInvocations {
    private static final String TRACE_PREFIX = "HiveMetastore.";

    private MetastoreInvocations() {
    }

    public static void assertMetastoreInvocationsForQuery(QueryRunner queryRunner, Session session, @Language(value="SQL") String query, Multiset<MetastoreMethod> expectedInvocations) {
        queryRunner.execute(session, query);
        MultisetAssertions.assertMultisetsEqual(MetastoreInvocations.filterInvocations(queryRunner.getSpans()), expectedInvocations);
    }

    public static Multiset<MetastoreMethod> filterInvocations(List<SpanData> spans) {
        return (Multiset)spans.stream().map(SpanData::getName).filter(name -> name.startsWith(TRACE_PREFIX)).map(name -> name.substring(TRACE_PREFIX.length())).filter(name -> !name.equals("listRoleGrants")).filter(name -> !name.equals("listTablePrivileges")).map(MetastoreMethod::fromMethodName).collect(ImmutableMultiset.toImmutableMultiset());
    }
}

