/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSetMultimap;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.MetastoreMethod;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestMetastoreMethod {
    TestMetastoreMethod() {
    }

    @Test
    void testFromMethodName() {
        Assertions.assertThat((Comparable)((Object)MetastoreMethod.fromMethodName("updateTableStatistics"))).isEqualTo((Object)MetastoreMethod.UPDATE_TABLE_STATISTICS);
        Assertions.assertThat((Comparable)((Object)MetastoreMethod.fromMethodName("dropTable"))).isEqualTo((Object)MetastoreMethod.DROP_TABLE);
    }

    @Test
    void testFromMethodNameInvalid() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetastoreMethod.fromMethodName("doesNotExist")).isInstanceOf(IllegalArgumentException.class)).hasMessage("No enum constant io.trino.plugin.hive.metastore.MetastoreMethod.DOES_NOT_EXIST");
    }

    @Test
    void testEnumNamesMapToMethods() {
        Set methodNames = Stream.of(HiveMetastore.class.getMethods()).map(Method::getName).collect(Collectors.toSet());
        for (MetastoreMethod method : MetastoreMethod.values()) {
            Assertions.assertThat(methodNames).contains((Object[])new String[]{CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, method.name())});
        }
    }

    @Test
    void testMethodNamesUnique() {
        ((ImmutableSetMultimap)Stream.of(HiveMetastore.class.getMethods()).collect(ImmutableSetMultimap.toImmutableSetMultimap(Method::getName, Function.identity()))).asMap().values().forEach(methods -> Assertions.assertThat((Collection)methods).hasSize(1));
    }
}

