/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ImmutableSet;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.HivePrivilegeInfo;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.spi.security.PrincipalType;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPrincipalPrivileges {
    @Test
    public void testGetTablePrincipalPrivileges() {
        PrincipalPrivileges principalPrivileges = PrincipalPrivileges.fromHivePrivilegeInfos((Set)ImmutableSet.of((Object)TestPrincipalPrivileges.hivePrivilegeInfo(PrincipalType.USER, "user001"), (Object)TestPrincipalPrivileges.hivePrivilegeInfo(PrincipalType.USER, "user002"), (Object)TestPrincipalPrivileges.hivePrivilegeInfo(PrincipalType.ROLE, "role001")));
        Assertions.assertThat((Object)principalPrivileges).isNotNull();
        Assertions.assertThat((int)principalPrivileges.getUserPrivileges().size()).isEqualTo(2);
        Assertions.assertThat((int)principalPrivileges.getRolePrivileges().size()).isEqualTo(1);
    }

    private static HivePrivilegeInfo hivePrivilegeInfo(PrincipalType type, String key) {
        return new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, false, new HivePrincipal(type, key), new HivePrincipal(type, key));
    }
}

