/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metastore.BooleanStatistics;
import io.trino.metastore.DateStatistics;
import io.trino.metastore.DecimalStatistics;
import io.trino.metastore.DoubleStatistics;
import io.trino.metastore.HiveBasicStatistics;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.IntegerStatistics;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.StatisticsUpdateMode;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.util.Statistics;
import io.trino.spi.block.Block;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatisticType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestStatisticsUpdateMode {
    private static final HiveBasicStatistics ONE_ROW = new HiveBasicStatistics(1L, 1L, 0L, 0L);

    TestStatisticsUpdateMode() {
    }

    @Test
    void testOverwriteAll() {
        PartitionStatistics x = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of());
        PartitionStatistics y = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of());
        Assertions.assertThat((Object)StatisticsUpdateMode.OVERWRITE_ALL.updatePartitionStatistics(x, y)).isSameAs((Object)y);
        Assertions.assertThat((Object)StatisticsUpdateMode.OVERWRITE_ALL.updatePartitionStatistics(y, x)).isSameAs((Object)x);
        x = new PartitionStatistics(ONE_ROW, (Map)ImmutableMap.of());
        y = new PartitionStatistics(ONE_ROW, (Map)ImmutableMap.of());
        Assertions.assertThat((Object)StatisticsUpdateMode.OVERWRITE_ALL.updatePartitionStatistics(x, y)).isSameAs((Object)y);
        Assertions.assertThat((Object)StatisticsUpdateMode.OVERWRITE_ALL.updatePartitionStatistics(y, x)).isSameAs((Object)x);
    }

    @Test
    void testClearAll() {
        PartitionStatistics partitionStatistics = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of());
        Assertions.assertThat((Object)StatisticsUpdateMode.CLEAR_ALL.updatePartitionStatistics(partitionStatistics, partitionStatistics)).isSameAs((Object)PartitionStatistics.empty());
        partitionStatistics = new PartitionStatistics(ONE_ROW, (Map)ImmutableMap.of());
        Assertions.assertThat((Object)StatisticsUpdateMode.CLEAR_ALL.updatePartitionStatistics(partitionStatistics, partitionStatistics)).isSameAs((Object)PartitionStatistics.empty());
    }

    @Test
    void testOverwriteSomeBasicStats() {
        HiveBasicStatistics basicStatistics = new HiveBasicStatistics(1L, 2L, 3L, 4L);
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.OVERWRITE_SOME_COLUMNS, HiveBasicStatistics.createEmptyStatistics(), basicStatistics)).isSameAs((Object)basicStatistics);
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.OVERWRITE_SOME_COLUMNS, ONE_ROW, basicStatistics)).isSameAs((Object)basicStatistics);
    }

    @Test
    void testOverwriteSomeColumnStats() {
        Assertions.assertThat(TestStatisticsUpdateMode.merge(StatisticsUpdateMode.OVERWRITE_SOME_COLUMNS, (Map<String, HiveColumnStatistics>)ImmutableMap.of(), (Map<String, HiveColumnStatistics>)ImmutableMap.of())).isEqualTo((Object)ImmutableMap.of());
        ImmutableMap first = ImmutableMap.builder().put((Object)"a", (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(3L))).put((Object)"shared", (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(100L), (OptionalLong)OptionalLong.of(200L), (OptionalLong)OptionalLong.of(300L))).buildOrThrow();
        Assertions.assertThat(TestStatisticsUpdateMode.merge(StatisticsUpdateMode.OVERWRITE_SOME_COLUMNS, (Map<String, HiveColumnStatistics>)first, (Map<String, HiveColumnStatistics>)ImmutableMap.of())).isEqualTo((Object)first);
        Assertions.assertThat(TestStatisticsUpdateMode.merge(StatisticsUpdateMode.OVERWRITE_SOME_COLUMNS, (Map<String, HiveColumnStatistics>)ImmutableMap.of(), (Map<String, HiveColumnStatistics>)first)).isEqualTo((Object)first);
        ImmutableMap second = ImmutableMap.builder().put((Object)"x", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(3L), (OptionalLong)OptionalLong.of(4L))).put((Object)"shared", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(100L), (OptionalLong)OptionalLong.of(200L), (OptionalLong)OptionalLong.of(300L), (OptionalLong)OptionalLong.of(400L))).buildOrThrow();
        ImmutableMap expected = ImmutableMap.builder().put((Object)"a", (Object)((HiveColumnStatistics)first.get((Object)"a"))).put((Object)"x", (Object)((HiveColumnStatistics)second.get((Object)"x"))).put((Object)"shared", (Object)((HiveColumnStatistics)second.get((Object)"shared"))).buildOrThrow();
        Assertions.assertThat(TestStatisticsUpdateMode.merge(StatisticsUpdateMode.OVERWRITE_SOME_COLUMNS, (Map<String, HiveColumnStatistics>)first, (Map<String, HiveColumnStatistics>)second)).isEqualTo((Object)expected);
    }

    @Test
    void testMergeIncrementalBasicStats() {
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.MERGE_INCREMENTAL, HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics())).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.MERGE_INCREMENTAL, ONE_ROW, HiveBasicStatistics.createEmptyStatistics())).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.MERGE_INCREMENTAL, HiveBasicStatistics.createEmptyStatistics(), ONE_ROW)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.MERGE_INCREMENTAL, HiveBasicStatistics.createZeroStatistics(), ONE_ROW)).isSameAs((Object)ONE_ROW);
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.MERGE_INCREMENTAL, ONE_ROW, HiveBasicStatistics.createZeroStatistics())).isSameAs((Object)ONE_ROW);
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.MERGE_INCREMENTAL, new HiveBasicStatistics(11L, 9L, 7L, 5L), new HiveBasicStatistics(1L, 2L, 3L, 4L))).isEqualTo((Object)new HiveBasicStatistics(12L, 11L, 10L, 9L));
    }

    @Test
    void testUndoMergeIncrementalBasicStats() {
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.UNDO_MERGE_INCREMENTAL, HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics())).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.UNDO_MERGE_INCREMENTAL, ONE_ROW, HiveBasicStatistics.createEmptyStatistics())).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.UNDO_MERGE_INCREMENTAL, HiveBasicStatistics.createEmptyStatistics(), ONE_ROW)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.UNDO_MERGE_INCREMENTAL, new HiveBasicStatistics(11L, 9L, 7L, 5L), new HiveBasicStatistics(1L, 2L, 3L, 4L))).isEqualTo((Object)new HiveBasicStatistics(10L, 7L, 4L, 1L));
    }

    @Test
    void testMergeEmptyColumnStatistics() {
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.empty(), HiveColumnStatistics.empty(), HiveColumnStatistics.empty());
    }

    @Test
    void testMergeIntegerColumnStatistics() {
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())).build(), HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())).build(), HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(1L), OptionalLong.of(2L))).build(), HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())).build(), HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(1L), OptionalLong.of(2L))).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(1L), OptionalLong.of(2L))).build(), HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(0L), OptionalLong.of(3L))).build(), HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(0L), OptionalLong.of(3L))).build());
    }

    @Test
    void testMergeDoubleColumnStatistics() {
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())).build(), HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())).build(), HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(1.0), OptionalDouble.of(2.0))).build(), HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())).build(), HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(1.0), OptionalDouble.of(2.0))).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(1.0), OptionalDouble.of(2.0))).build(), HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(0.0), OptionalDouble.of(3.0))).build(), HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(0.0), OptionalDouble.of(3.0))).build());
    }

    @Test
    void testMergeDecimalColumnStatistics() {
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty())).build(), HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty())).build(), HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty())).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(BigDecimal.valueOf(1L)), Optional.of(BigDecimal.valueOf(2L)))).build(), HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty())).build(), HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(BigDecimal.valueOf(1L)), Optional.of(BigDecimal.valueOf(2L)))).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(BigDecimal.valueOf(1L)), Optional.of(BigDecimal.valueOf(2L)))).build(), HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(BigDecimal.valueOf(0L)), Optional.of(BigDecimal.valueOf(3L)))).build(), HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(BigDecimal.valueOf(0L)), Optional.of(BigDecimal.valueOf(3L)))).build());
    }

    @Test
    void testMergeDateColumnStatistics() {
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty())).build(), HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty())).build(), HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty())).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.ofEpochDay(1L)), Optional.of(LocalDate.ofEpochDay(2L)))).build(), HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty())).build(), HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.ofEpochDay(1L)), Optional.of(LocalDate.ofEpochDay(2L)))).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.ofEpochDay(1L)), Optional.of(LocalDate.ofEpochDay(2L)))).build(), HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.ofEpochDay(0L)), Optional.of(LocalDate.ofEpochDay(3L)))).build(), HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.ofEpochDay(0L)), Optional.of(LocalDate.ofEpochDay(3L)))).build());
    }

    @Test
    void testMergeBooleanColumnStatistics() {
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build(), HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build(), HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.of(1L), OptionalLong.of(2L))).build(), HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build(), HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.of(1L), OptionalLong.of(2L))).build(), HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.of(2L), OptionalLong.of(3L))).build(), HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.of(3L), OptionalLong.of(5L))).build());
    }

    @Test
    void testMergeStringColumnStatistics() {
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.empty()).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.of(1L)).build(), HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.of(1L)).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.of(2L)).build(), HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.of(3L)).build(), HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.of(3L)).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setAverageColumnLength(OptionalDouble.empty()).build(), HiveColumnStatistics.builder().setAverageColumnLength(OptionalDouble.empty()).build(), HiveColumnStatistics.builder().setAverageColumnLength(OptionalDouble.empty()).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setAverageColumnLength(OptionalDouble.of(1.0)).build(), HiveColumnStatistics.builder().setAverageColumnLength(OptionalDouble.empty()).build(), HiveColumnStatistics.builder().setAverageColumnLength(OptionalDouble.empty()).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setAverageColumnLength(OptionalDouble.of(2.0)).build(), HiveColumnStatistics.builder().setAverageColumnLength(OptionalDouble.of(3.0)).build(), HiveColumnStatistics.builder().setAverageColumnLength(OptionalDouble.of(2.5)).build());
        PartitionStatistics firstStats = new PartitionStatistics(new HiveBasicStatistics(1L, 10L, 0L, 0L), Map.of("column_name", HiveColumnStatistics.builder().setAverageColumnLength(OptionalDouble.of(2.0)).build()));
        PartitionStatistics secondStats = new PartitionStatistics(new HiveBasicStatistics(1L, 1L, 0L, 0L), Map.of("column_name", HiveColumnStatistics.builder().setAverageColumnLength(OptionalDouble.of(13.0)).build()));
        Assertions.assertThat((OptionalDouble)((HiveColumnStatistics)StatisticsUpdateMode.MERGE_INCREMENTAL.updatePartitionStatistics(firstStats, secondStats).columnStatistics().get("column_name")).getAverageColumnLength()).hasValue(3.0);
    }

    @Test
    void testMergeGenericColumnStatistics() {
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setDistinctValuesWithNullCount(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setDistinctValuesWithNullCount(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setDistinctValuesWithNullCount(OptionalLong.empty()).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setDistinctValuesWithNullCount(OptionalLong.of(1L)).build(), HiveColumnStatistics.builder().setDistinctValuesWithNullCount(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setDistinctValuesWithNullCount(OptionalLong.empty()).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setDistinctValuesWithNullCount(OptionalLong.of(1L)).build(), HiveColumnStatistics.builder().setDistinctValuesWithNullCount(OptionalLong.of(2L)).build(), HiveColumnStatistics.builder().setDistinctValuesWithNullCount(OptionalLong.of(2L)).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setNullsCount(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setNullsCount(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setNullsCount(OptionalLong.empty()).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setNullsCount(OptionalLong.of(1L)).build(), HiveColumnStatistics.builder().setNullsCount(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setNullsCount(OptionalLong.empty()).build());
        TestStatisticsUpdateMode.assertMergeIncrementalColumnStatistics(HiveColumnStatistics.builder().setNullsCount(OptionalLong.of(1L)).build(), HiveColumnStatistics.builder().setNullsCount(OptionalLong.of(2L)).build(), HiveColumnStatistics.builder().setNullsCount(OptionalLong.of(3L)).build());
    }

    private static void assertMergeIncrementalColumnStatistics(HiveColumnStatistics first, HiveColumnStatistics second, HiveColumnStatistics expected) {
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.MERGE_INCREMENTAL, first, second)).isEqualTo((Object)expected);
        Assertions.assertThat((Object)TestStatisticsUpdateMode.merge(StatisticsUpdateMode.MERGE_INCREMENTAL, second, first)).isEqualTo((Object)expected);
    }

    @Test
    void testMergeHiveColumnStatisticsMap() {
        ImmutableMap first = ImmutableMap.of((Object)"column1", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(3L), (OptionalLong)OptionalLong.of(4L)), (Object)"column2", (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(2.0), (OptionalDouble)OptionalDouble.of(3.0), (OptionalLong)OptionalLong.of(4L), (OptionalLong)OptionalLong.of(5L)), (Object)"column3", (Object)HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)OptionalLong.of(5L), (OptionalDouble)OptionalDouble.of(5.0), (OptionalLong)OptionalLong.of(10L)), (Object)"column4", (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(3L)));
        ImmutableMap second = ImmutableMap.of((Object)"column5", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(3L), (OptionalLong)OptionalLong.of(4L)), (Object)"column2", (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(1.0), (OptionalDouble)OptionalDouble.of(4.0), (OptionalLong)OptionalLong.of(4L), (OptionalLong)OptionalLong.of(6L)), (Object)"column3", (Object)HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)OptionalLong.of(6L), (OptionalDouble)OptionalDouble.of(5.0), (OptionalLong)OptionalLong.of(10L)), (Object)"column6", (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(3L)));
        ImmutableMap expected = ImmutableMap.of((Object)"column2", (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(1.0), (OptionalDouble)OptionalDouble.of(4.0), (OptionalLong)OptionalLong.of(8L), (OptionalLong)OptionalLong.of(6L)), (Object)"column3", (Object)HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)OptionalLong.of(6L), (OptionalDouble)OptionalDouble.of(5.0), (OptionalLong)OptionalLong.of(20L)));
        Assertions.assertThat(TestStatisticsUpdateMode.merge(StatisticsUpdateMode.MERGE_INCREMENTAL, (Map<String, HiveColumnStatistics>)first, (Map<String, HiveColumnStatistics>)second)).isEqualTo((Object)expected);
        Assertions.assertThat(TestStatisticsUpdateMode.merge(StatisticsUpdateMode.MERGE_INCREMENTAL, (Map<String, HiveColumnStatistics>)ImmutableMap.of(), (Map<String, HiveColumnStatistics>)ImmutableMap.of())).isEqualTo((Object)ImmutableMap.of());
    }

    @Test
    void testFromComputedStatistics() {
        ComputedStatistics statistics = ComputedStatistics.builder((List)ImmutableList.of(), (List)ImmutableList.of()).addTableStatistic(TableStatisticType.ROW_COUNT, (Block)TypeUtils.writeNativeValue((Type)BigintType.BIGINT, (Object)5L)).addColumnStatistic(HiveColumnStatisticType.MIN_VALUE.createColumnStatisticMetadata("a_column"), (Block)TypeUtils.writeNativeValue((Type)IntegerType.INTEGER, (Object)1L)).addColumnStatistic(HiveColumnStatisticType.MAX_VALUE.createColumnStatisticMetadata("a_column"), (Block)TypeUtils.writeNativeValue((Type)IntegerType.INTEGER, (Object)5L)).addColumnStatistic(HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES.createColumnStatisticMetadata("a_column"), (Block)TypeUtils.writeNativeValue((Type)BigintType.BIGINT, (Object)5L)).addColumnStatistic(HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES.createColumnStatisticMetadata("a_column"), (Block)TypeUtils.writeNativeValue((Type)BigintType.BIGINT, (Object)5L)).addColumnStatistic(HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES.createColumnStatisticMetadata("b_column"), (Block)TypeUtils.writeNativeValue((Type)BigintType.BIGINT, (Object)4L)).build();
        ImmutableMap columnTypes = ImmutableMap.of((Object)"a_column", (Object)IntegerType.INTEGER, (Object)"b_column", (Object)VarcharType.VARCHAR);
        Map columnStatistics = Statistics.fromComputedStatistics((Map)statistics.getColumnStatistics(), (Map)columnTypes, (long)5L);
        Assertions.assertThat((Map)columnStatistics).hasSize(2);
        Assertions.assertThat(columnStatistics.keySet()).contains((Object[])new String[]{"a_column", "b_column"});
        Assertions.assertThat((Map)columnStatistics).containsEntry((Object)"a_column", (Object)HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(1L), OptionalLong.of(5L))).setNullsCount(0L).setDistinctValuesWithNullCount(5L).build());
        Assertions.assertThat((Map)columnStatistics).containsEntry((Object)"b_column", (Object)HiveColumnStatistics.builder().setNullsCount(1L).build());
    }

    private static HiveBasicStatistics merge(StatisticsUpdateMode mode, HiveBasicStatistics first, HiveBasicStatistics second) {
        return mode.updatePartitionStatistics(new PartitionStatistics(first, (Map)ImmutableMap.of()), new PartitionStatistics(second, (Map)ImmutableMap.of())).basicStatistics();
    }

    private static HiveColumnStatistics merge(StatisticsUpdateMode mode, HiveColumnStatistics first, HiveColumnStatistics second) {
        return TestStatisticsUpdateMode.merge(mode, Map.of("column_name", first), Map.of("column_name", second)).get("column_name");
    }

    private static Map<String, HiveColumnStatistics> merge(StatisticsUpdateMode mode, Map<String, HiveColumnStatistics> first, Map<String, HiveColumnStatistics> second) {
        return mode.updatePartitionStatistics(new PartitionStatistics(ONE_ROW, first), new PartitionStatistics(ONE_ROW, second)).columnStatistics();
    }
}

