/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.cache;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Key;
import io.trino.Session;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.RawHiveMetastoreFactory;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SelectedRole;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestCachingHiveMetastoreWithQueryRunner
extends AbstractTestQueryFramework {
    private static final String CATALOG = "hive";
    private static final String SCHEMA = "test";
    private static final Session ADMIN = TestCachingHiveMetastoreWithQueryRunner.getTestSession(Identity.forUser((String)"admin").withConnectorRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build());
    private static final String ALICE_NAME = "alice";
    private static final Session ALICE = TestCachingHiveMetastoreWithQueryRunner.getTestSession(new Identity.Builder("alice").build());
    private HiveMetastore rawMetastore;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)HiveQueryRunner.builder(ADMIN).setCoordinatorProperties((Map)ImmutableMap.of((Object)"node-scheduler.include-coordinator", (Object)"false"))).setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.security", (Object)"sql-standard", (Object)"hive.metastore-cache-ttl", (Object)"60m", (Object)"hive.metastore-refresh-interval", (Object)"10m")))).build();
        this.rawMetastore = ((HiveMetastoreFactory)TestingHiveUtils.getConnectorService((QueryRunner)queryRunner, Key.get(HiveMetastoreFactory.class, RawHiveMetastoreFactory.class))).createMetastore(Optional.empty());
        queryRunner.execute(ADMIN, "CREATE SCHEMA test");
        queryRunner.execute("CREATE TABLE test (test INT)");
        return queryRunner;
    }

    private static Session getTestSession(Identity identity) {
        return TestingSession.testSessionBuilder().setCatalog(CATALOG).setSchema(SCHEMA).setIdentity(identity).build();
    }

    @Test
    public void testCacheRefreshOnGrantAndRevoke() {
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(ALICE, "SELECT * FROM test")).hasMessageContaining("Access Denied");
        this.getQueryRunner().execute("GRANT SELECT ON test TO alice");
        this.getQueryRunner().execute(ALICE, "SELECT * FROM test");
        this.getQueryRunner().execute("REVOKE SELECT ON test FROM alice");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(ALICE, "SELECT * FROM test")).hasMessageContaining("Access Denied");
    }

    @Test
    public void testCacheRefreshOnRoleGrantAndRevoke() {
        String grantSelectStatement = "GRANT SELECT ON test TO ROLE test_role";
        String grantRoleStatement = "GRANT test_role TO alice IN hive";
        ImmutableList grantRoleStatements = ImmutableList.of((Object)ImmutableList.of((Object)grantSelectStatement, (Object)grantRoleStatement), (Object)ImmutableList.of((Object)grantRoleStatement, (Object)grantSelectStatement));
        ImmutableList revokeRoleStatements = ImmutableList.of((Object)"DROP ROLE test_role IN hive", (Object)"REVOKE SELECT ON test FROM ROLE test_role", (Object)"REVOKE test_role FROM alice IN hive");
        for (String roleRevoke : revokeRoleStatements) {
            for (List roleGrant : grantRoleStatements) {
                this.testCacheRefreshOnRoleGrantAndRevoke(roleGrant, roleRevoke);
            }
        }
    }

    private void testCacheRefreshOnRoleGrantAndRevoke(List<String> grantRoleStatements, String revokeRoleStatement) {
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(ALICE, "SELECT * FROM test")).hasMessageContaining("Access Denied");
        this.getQueryRunner().execute("CREATE ROLE test_role IN hive");
        grantRoleStatements.forEach(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0));
        this.getQueryRunner().execute(ALICE, "SELECT * FROM test");
        this.getQueryRunner().execute(revokeRoleStatement);
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(ALICE, "SELECT * FROM test")).hasMessageContaining("Access Denied");
        String removeByDropStatement = "DROP ROLE test_role IN hive";
        if (!revokeRoleStatement.equals(removeByDropStatement)) {
            this.getQueryRunner().execute(removeByDropStatement);
        }
    }

    @Test
    public void testFlushHiveMetastoreCacheProcedureCallable() {
        this.getQueryRunner().execute("CREATE TABLE cached (initial varchar)");
        this.getQueryRunner().execute("SELECT initial FROM cached");
        this.rawMetastore.renameColumn(SCHEMA, "cached", "initial", "renamed");
        String renamedColumnQuery = "SELECT renamed FROM cached";
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(renamedColumnQuery)).hasMessageMatching(".*Column 'renamed' cannot be resolved");
        this.getQueryRunner().execute("CALL system.flush_metadata_cache()");
        this.getQueryRunner().execute(renamedColumnQuery);
    }

    @Test
    public void testIllegalFlushHiveMetastoreCacheProcedureCalls() {
        String illegalParameterMessage = "Illegal parameter set passed. Valid usages:\n - 'flush_metadata_cache()'\n - flush_metadata_cache(schema_name => ..., table_name => ...) - flush_metadata_cache(schema_name => ..., table_name => ..., partition_columns => ARRAY['...'], partition_values => ARRAY['...'])";
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CALL system.flush_metadata_cache('dummy_schema')")).hasMessageContaining("Only named arguments are allowed for this procedure");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CALL system.flush_metadata_cache(schema_name => 'dummy_schema')")).hasMessage(illegalParameterMessage);
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CALL system.flush_metadata_cache(schema_name => 'dummy_schema', table_name => 'dummy_table', partition_columns => ARRAY['dummy_partition'])")).hasMessage("Parameters partition_column and partition_value should have same length");
    }

    @Test
    public void testPartitionAppend() {
        int nodeCount = this.getQueryRunner().getNodeCount();
        Verify.verify((nodeCount > 1 ? 1 : 0) != 0, (String)"this test requires a multinode query runner", (Object[])new Object[0]);
        this.getQueryRunner().execute("CREATE TABLE test_part_append (name varchar, partkey varchar) WITH (partitioned_by = ARRAY['partkey'])");
        String row = "('some name', 'part1')";
        for (int i = 0; i < nodeCount + 1; ++i) {
            this.getQueryRunner().execute("INSERT INTO test_part_append VALUES " + row);
        }
        String expected = Joiner.on((String)",").join(Collections.nCopies(nodeCount + 1, row));
        this.assertQuery("SELECT * FROM test_part_append", "VALUES " + expected);
    }
}

