/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.file;

import com.google.common.base.Verify;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.local.LocalFileSystemFactory;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import java.io.File;

public final class TestingFileHiveMetastore {
    private TestingFileHiveMetastore() {
    }

    public static FileHiveMetastore createTestingFileHiveMetastore(File catalogDirectory) {
        Verify.verify((boolean)catalogDirectory.mkdirs());
        return TestingFileHiveMetastore.createTestingFileHiveMetastore((TrinoFileSystemFactory)new LocalFileSystemFactory(catalogDirectory.toPath()), Location.of((String)"local:///"));
    }

    public static FileHiveMetastore createTestingFileHiveMetastore(TrinoFileSystemFactory fileSystemFactory, Location catalogDirectory) {
        return new FileHiveMetastore(new NodeVersion("testversion"), fileSystemFactory, new HiveMetastoreConfig().isHideDeltaLakeTables(), new FileHiveMetastoreConfig().setCatalogDirectory(catalogDirectory.toString()).setMetastoreUser("test"));
    }
}

