/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.math.DoubleMath;
import io.trino.plugin.hive.metastore.glue.AwsApiCallStats;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.function.Function;

public enum GlueMetastoreMethod {
    BATCH_CREATE_PARTITION(GlueMetastoreStats::getBatchCreatePartition),
    BATCH_UPDATE_PARTITION(GlueMetastoreStats::getBatchUpdatePartition),
    CREATE_DATABASE(GlueMetastoreStats::getCreateDatabase),
    CREATE_PARTITIONS(GlueMetastoreStats::getCreatePartitions),
    CREATE_TABLE(GlueMetastoreStats::getCreateTable),
    DELETE_COLUMN_STATISTICS_FOR_PARTITION(GlueMetastoreStats::getDeleteColumnStatisticsForPartition),
    DELETE_COLUMN_STATISTICS_FOR_TABLE(GlueMetastoreStats::getDeleteColumnStatisticsForTable),
    DELETE_DATA_BASE(GlueMetastoreStats::getDeleteDatabase),
    DELETE_PARTITION(GlueMetastoreStats::getDeletePartition),
    DELETE_TABLE(GlueMetastoreStats::getDeleteTable),
    GET_COLUMN_STATISTICS_FOR_PARTITION(GlueMetastoreStats::getGetColumnStatisticsForPartition),
    GET_COLUMN_STATISTICS_FOR_TABLE(GlueMetastoreStats::getDeleteColumnStatisticsForTable),
    GET_DATABASE(GlueMetastoreStats::getGetDatabase),
    GET_DATABASES(GlueMetastoreStats::getGetDatabases),
    GET_PARTITION(GlueMetastoreStats::getGetPartition),
    GET_PARTITION_NAMES(GlueMetastoreStats::getGetPartitionNames),
    GET_PARTITIONS(GlueMetastoreStats::getGetPartitions),
    GET_TABLE(GlueMetastoreStats::getGetTable),
    GET_TABLES(GlueMetastoreStats::getGetTables),
    UPDATE_COLUMN_STATISTICS_FOR_PARTITION(GlueMetastoreStats::getUpdateColumnStatisticsForPartition),
    UPDATE_COLUMN_STATISTICS_FOR_TABLE(GlueMetastoreStats::getUpdateColumnStatisticsForTable),
    UPDATE_DATABASE(GlueMetastoreStats::getUpdateDatabase),
    UPDATE_PARTITION(GlueMetastoreStats::getUpdatePartition),
    UPDATE_TABLE(GlueMetastoreStats::getUpdateTable);

    private final Function<GlueMetastoreStats, AwsApiCallStats> extractor;

    private GlueMetastoreMethod(Function<GlueMetastoreStats, AwsApiCallStats> extractor) {
        this.extractor = Objects.requireNonNull(extractor, "extractor is null");
    }

    public AwsApiCallStats getStatFrom(GlueMetastoreStats stats) {
        return this.extractor.apply(stats);
    }

    public int getInvocationCount(GlueMetastoreStats stats) {
        double count = this.getStatFrom(stats).getTime().getAllTime().getCount();
        return DoubleMath.roundToInt((double)count, (RoundingMode)RoundingMode.UNNECESSARY);
    }
}

