/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.trino.Session;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreMethod;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import software.amazon.awssdk.services.glue.GlueClient;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestCachedHiveGlueMetastore
extends AbstractTestQueryFramework {
    private static final int MAX_PREFIXES_COUNT = 5;
    private final String testSchema = "test_schema_" + TestingNames.randomNameSuffix();
    private GlueMetastoreStats glueStats;
    private GlueClient glueClient;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)HiveQueryRunner.builder(TestingSession.testSessionBuilder().setCatalog("hive").setSchema(this.testSchema).build()).addCoordinatorProperty("optimizer.experimental-max-prefetched-information-schema-prefixes", Integer.toString(5))).addHiveProperty("hive.metastore", "glue"))).addHiveProperty("hive.metastore.glue.default-warehouse-dir", "local:///glue"))).addHiveProperty("hive.metastore-cache-ttl", "1d"))).addHiveProperty("hive.metastore-refresh-interval", "1h"))).addHiveProperty("hive.security", "allow-all"))).setCreateTpchSchemas(false))).build();
        queryRunner.execute("CREATE SCHEMA " + this.testSchema);
        this.glueStats = TestingHiveUtils.getConnectorService((QueryRunner)queryRunner, GlueHiveMetastore.class).getStats();
        this.glueClient = (GlueClient)this.closeAfterClass((AutoCloseable)GlueClient.create());
        return queryRunner;
    }

    @AfterAll
    public void cleanUpSchema() {
        this.getQueryRunner().execute("DROP SCHEMA " + this.testSchema + " CASCADE");
    }

    @Test
    public void testSelectUnpartitionedTable() {
        try {
            this.assertUpdate("CREATE TABLE test_select_from (id VARCHAR, age INT)");
            String select = "SELECT * FROM test_select_from";
            this.assertInvocations(select, (Multiset<GlueMetastoreMethod>)ImmutableMultiset.of((Object)((Object)GlueMetastoreMethod.GET_TABLE)));
            this.assertInvocations(select, (Multiset<GlueMetastoreMethod>)ImmutableMultiset.of());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_from");
        }
    }

    @Test
    public void testSelectPartitionedTable() {
        try {
            this.assertUpdate("CREATE TABLE test_select_from_partitioned_where WITH (partitioned_by = ARRAY['regionkey']) AS\nSELECT nationkey, name, regionkey FROM tpch.tiny.nation\n", 25L);
            String select = "SELECT * FROM test_select_from_partitioned_where WHERE regionkey IN (2, 3)";
            this.assertInvocations(select, (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).addCopies((Object)GlueMetastoreMethod.GET_PARTITION_NAMES, 5).build());
            this.assertInvocations(select, (Multiset<GlueMetastoreMethod>)ImmutableMultiset.of());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_from_partitioned_where");
        }
    }

    @Test
    public void testFlushTableCache() throws Exception {
        try {
            this.assertUpdate("CREATE TABLE test_flush_table WITH (partitioned_by = ARRAY['regionkey']) AS\nSELECT nationkey, name, regionkey FROM tpch.tiny.nation\n", 25L);
            String select = "SELECT * FROM test_flush_table WHERE regionkey IN (2, 3)";
            this.assertQuerySucceeds(select);
            this.assertInvocations(select, (Multiset<GlueMetastoreMethod>)ImmutableMultiset.of());
            this.glueClient.deletePartition(request -> request.databaseName(this.testSchema).tableName("test_flush_table").partitionValues(new String[]{"2"}));
            Location partitionLocation = Location.of((String)("local:///glue/" + this.testSchema + "/test_flush_table/regionkey=2"));
            TestingHiveUtils.getConnectorService(this.getQueryRunner(), TrinoFileSystemFactory.class).create(ConnectorIdentity.ofUser((String)"test")).deleteDirectory(partitionLocation);
            this.assertQueryFails(select, "Partition location does not exist: " + String.valueOf(partitionLocation));
            this.assertQueryFails(select, "Partition location does not exist: " + String.valueOf(partitionLocation));
            this.assertQuerySucceeds("CALL system.flush_metadata_cache()");
            this.assertInvocations(select, (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).addCopies((Object)GlueMetastoreMethod.GET_PARTITION_NAMES, 5).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_from_partitioned_where");
        }
    }

    @Test
    public void testFlushPartitionCache() throws Exception {
        try {
            this.assertUpdate("CREATE TABLE test_flush_partition WITH (partitioned_by = ARRAY['regionkey']) AS\nSELECT nationkey, name, regionkey FROM tpch.tiny.nation\n", 25L);
            String select = "SELECT * FROM test_flush_partition WHERE regionkey IN (2, 3)";
            this.assertQuerySucceeds(select);
            this.assertInvocations(select, (Multiset<GlueMetastoreMethod>)ImmutableMultiset.of());
            this.glueClient.deletePartition(request -> request.databaseName(this.testSchema).tableName("test_flush_partition").partitionValues(new String[]{"2"}));
            Location partitionLocation = Location.of((String)("local:///glue/" + this.testSchema + "/test_flush_partition/regionkey=2"));
            TestingHiveUtils.getConnectorService(this.getQueryRunner(), TrinoFileSystemFactory.class).create(ConnectorIdentity.ofUser((String)"test")).deleteDirectory(partitionLocation);
            this.assertQueryFails(select, "Partition location does not exist: " + String.valueOf(partitionLocation));
            this.assertQueryFails(select, "Partition location does not exist: " + String.valueOf(partitionLocation));
            this.assertQuerySucceeds("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_flush_partition', partition_columns => ARRAY['regionkey'], partition_values => ARRAY['2'])");
            this.assertQueryFails(select, "Partition no longer exists: regionkey=2");
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_from_partitioned_where");
        }
    }

    private void assertInvocations(@Language(value="SQL") String query, Multiset<GlueMetastoreMethod> expectedGlueInvocations) {
        this.assertInvocations(this.getSession(), query, expectedGlueInvocations);
    }

    private void assertInvocations(Session session, @Language(value="SQL") String query, Multiset<GlueMetastoreMethod> expectedGlueInvocations) {
        Map countsBefore = (Map)Arrays.stream(GlueMetastoreMethod.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), method -> method.getInvocationCount(this.glueStats)));
        this.getQueryRunner().execute(session, query);
        Map countsAfter = (Map)Arrays.stream(GlueMetastoreMethod.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), method -> method.getInvocationCount(this.glueStats)));
        Multiset actualGlueInvocations = (Multiset)Arrays.stream(GlueMetastoreMethod.values()).collect(ImmutableMultiset.toImmutableMultiset(Function.identity(), method -> Objects.requireNonNull((Integer)countsAfter.get(method)) - Objects.requireNonNull((Integer)countsBefore.get(method))));
        MultisetAssertions.assertMultisetsEqual((Multiset)actualGlueInvocations, expectedGlueInvocations);
    }
}

