/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public class TestGlueHiveMetastoreQueries
extends AbstractTestQueryFramework {
    private final String testSchema = "test_schema_" + TestingNames.randomNameSuffix();

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder(TestingSession.testSessionBuilder().setCatalog("hive").setSchema(this.testSchema).build()).addHiveProperty("hive.metastore", "glue").addHiveProperty("hive.metastore.glue.default-warehouse-dir", "local:///glue"))).addHiveProperty("hive.security", "allow-all"))).setCreateTpchSchemas(false))).build();
        queryRunner.execute("CREATE SCHEMA " + this.testSchema);
        return queryRunner;
    }

    @AfterAll
    public void cleanUpSchema() {
        this.getQueryRunner().execute("DROP SCHEMA " + this.testSchema + " CASCADE");
    }

    @Test
    public void testFlushMetadataDisabled() {
        this.assertQuerySucceeds("CALL system.flush_metadata_cache()");
    }
}

