/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreModule;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.retries.api.RefreshRetryTokenRequest;
import software.amazon.awssdk.retries.api.RefreshRetryTokenResponse;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.retries.api.RetryToken;
import software.amazon.awssdk.retries.internal.DefaultRetryToken;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.ConcurrentModificationException;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestHiveConcurrentModificationGlueMetastore {
    @Test
    public void testGlueClientShouldRetryConcurrentModificationException() {
        try (GlueClient glueClient = GlueMetastoreModule.createGlueClient((GlueHiveMetastoreConfig)new GlueHiveMetastoreConfig(), (OpenTelemetry)OpenTelemetry.noop());){
            ClientOverrideConfiguration clientOverrideConfiguration = glueClient.serviceClientConfiguration().overrideConfiguration();
            RetryStrategy retryStrategy = (RetryStrategy)clientOverrideConfiguration.retryStrategy().orElseThrow();
            Assertions.assertThatThrownBy(() -> retryStrategy.refreshRetryToken(RefreshRetryTokenRequest.builder().token((RetryToken)DefaultRetryToken.builder().scope("test").build()).failure((Throwable)new RuntimeException("This is not retryable exception so it should fail")).build())).hasMessage("Request attempt 1 encountered non-retryable failure");
            RefreshRetryTokenResponse refreshRetryTokenResponse = retryStrategy.refreshRetryToken(RefreshRetryTokenRequest.builder().token((RetryToken)DefaultRetryToken.builder().scope("test").build()).failure((Throwable)ConcurrentModificationException.builder().awsErrorDetails(AwsErrorDetails.builder().errorCode("ConcurrentModificationException").build()).message("Test-simulated metastore concurrent modification exception that should be allowed to retry").build()).build());
            Assertions.assertThat((Object)refreshRetryTokenResponse).isNotNull();
        }
    }
}

