/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreMethod;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestHiveGlueMetastoreAccessOperations
extends AbstractTestQueryFramework {
    private static final Logger log = Logger.get(TestHiveGlueMetastoreAccessOperations.class);
    private static final int MAX_PREFIXES_COUNT = 5;
    private final String testSchema = "test_schema_" + TestingNames.randomNameSuffix();
    private GlueMetastoreStats glueStats;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder(TestingSession.testSessionBuilder().setCatalog("hive").setSchema(this.testSchema).build()).addHiveProperty("hive.metastore", "glue").addHiveProperty("hive.metastore.glue.default-warehouse-dir", "local:///glue"))).addHiveProperty("hive.security", "allow-all"))).setCreateTpchSchemas(false))).build();
        queryRunner.execute("CREATE SCHEMA " + this.testSchema);
        this.glueStats = TestingHiveUtils.getConnectorService((QueryRunner)queryRunner, GlueHiveMetastore.class).getStats();
        return queryRunner;
    }

    @AfterAll
    public void cleanUpSchema() {
        this.getQueryRunner().execute("DROP SCHEMA " + this.testSchema + " CASCADE");
    }

    @Test
    public void testUse() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String schema = (String)this.getSession().getSchema().orElseThrow();
        Session session = Session.builder((Session)this.getSession()).setCatalog(Optional.empty()).setSchema(Optional.empty()).build();
        this.assertInvocations(session, "USE %s.%s".formatted(catalog, schema), (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_DATABASE).build());
    }

    @Test
    public void testCreateTable() {
        try {
            this.assertInvocations("CREATE TABLE test_create (id VARCHAR, age INT)", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_DATABASE).addCopies((Object)GlueMetastoreMethod.GET_TABLE, 2).add((Object)GlueMetastoreMethod.CREATE_TABLE).add((Object)GlueMetastoreMethod.UPDATE_TABLE).addCopies((Object)GlueMetastoreMethod.GET_COLUMN_STATISTICS_FOR_TABLE, 2).addCopies((Object)GlueMetastoreMethod.DELETE_COLUMN_STATISTICS_FOR_TABLE, 2).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_create");
        }
    }

    @Test
    public void testCreateTableAsSelect() {
        try {
            this.assertInvocations("CREATE TABLE test_ctas AS SELECT 1 AS age", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_DATABASE).addCopies((Object)GlueMetastoreMethod.GET_TABLE, 2).add((Object)GlueMetastoreMethod.CREATE_TABLE).add((Object)GlueMetastoreMethod.UPDATE_TABLE).add((Object)GlueMetastoreMethod.UPDATE_COLUMN_STATISTICS_FOR_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_ctas");
        }
    }

    @Test
    public void testSelect() {
        try {
            this.assertUpdate("CREATE TABLE test_select_from (id VARCHAR, age INT)");
            this.assertInvocations("SELECT * FROM test_select_from", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_from");
        }
    }

    @Test
    public void testSelectWithFilter() {
        try {
            this.assertUpdate("CREATE TABLE test_select_from_where AS SELECT 2 as age", 1L);
            this.assertInvocations("SELECT * FROM test_select_from_where WHERE age = 2", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_from_where");
        }
    }

    @Test
    public void testSelectFromPartitionedWithFilter() {
        try {
            this.assertUpdate("CREATE TABLE test_select_from_partitioned_where WITH (partitioned_by = ARRAY['regionkey']) AS\nSELECT nationkey, name, regionkey FROM tpch.tiny.nation\nUNION ALL SELECT nationkey, name, regionkey + 10 AS regionkey FROM tpch.tiny.nation\n", 50L);
            this.assertInvocations("SELECT * FROM test_select_from_partitioned_where WHERE regionkey IN (2, 3)", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).add((Object)GlueMetastoreMethod.GET_PARTITIONS).addCopies((Object)GlueMetastoreMethod.GET_PARTITION_NAMES, 5).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_from_partitioned_where");
        }
    }

    @Test
    public void testSelectFromView() {
        try {
            this.assertUpdate("CREATE TABLE test_select_view_table (id VARCHAR, age INT)");
            this.assertUpdate("CREATE VIEW test_select_view_view AS SELECT id, age FROM test_select_view_table");
            this.assertInvocations("SELECT * FROM test_select_view_view", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)GlueMetastoreMethod.GET_TABLE, 2).build());
        }
        finally {
            this.getQueryRunner().execute("DROP VIEW IF EXISTS test_select_view_view");
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_view_table");
        }
    }

    @Test
    public void testSelectFromViewWithFilter() {
        try {
            this.assertUpdate("CREATE TABLE test_select_view_where_table AS SELECT 2 as age", 1L);
            this.assertUpdate("CREATE VIEW test_select_view_where_view AS SELECT age FROM test_select_view_where_table");
            this.assertInvocations("SELECT * FROM test_select_view_where_view WHERE age = 2", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)GlueMetastoreMethod.GET_TABLE, 2).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_view_where_table");
            this.getQueryRunner().execute("DROP VIEW IF EXISTS test_select_view_where_view");
        }
    }

    @Test
    public void testJoin() {
        try {
            this.assertUpdate("CREATE TABLE test_join_t1 AS SELECT 2 as age, 'id1' AS id", 1L);
            this.assertUpdate("CREATE TABLE test_join_t2 AS SELECT 'name1' as name, 'id1' AS id", 1L);
            this.assertInvocations("SELECT name, age FROM test_join_t1 JOIN test_join_t2 ON test_join_t2.id = test_join_t1.id", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)GlueMetastoreMethod.GET_TABLE, 2).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_join_t1");
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_join_t2");
        }
    }

    @Test
    public void testSelfJoin() {
        try {
            this.assertUpdate("CREATE TABLE test_self_join_table AS SELECT 2 as age, 0 parent, 3 AS id", 1L);
            this.assertInvocations("SELECT child.age, parent.age FROM test_self_join_table child JOIN test_self_join_table parent ON child.parent = parent.id", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_self_join_table");
        }
    }

    @Test
    public void testExplainSelect() {
        try {
            this.assertUpdate("CREATE TABLE test_explain AS SELECT 2 as age", 1L);
            this.assertInvocations("EXPLAIN SELECT * FROM test_explain", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_explain");
        }
    }

    @Test
    public void testShowStatsForTable() {
        try {
            this.assertUpdate("CREATE TABLE test_show_stats AS SELECT 2 as age", 1L);
            this.assertInvocations("SHOW STATS FOR test_show_stats", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_show_stats");
        }
    }

    @Test
    public void testShowStatsForTableWithFilter() {
        try {
            this.assertUpdate("CREATE TABLE test_show_stats_with_filter AS SELECT 2 as age", 1L);
            this.assertInvocations("SHOW STATS FOR (SELECT * FROM test_show_stats_with_filter where age >= 2)", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_show_stats_with_filter");
        }
    }

    @Test
    public void testSelectSystemTable() {
        try {
            this.assertUpdate("CREATE TABLE test_select_system_table WITH (partitioned_by = ARRAY['regionkey']) AS\nSELECT nationkey, name, regionkey FROM tpch.tiny.nation\nUNION ALL SELECT nationkey, name, regionkey + 10 AS regionkey FROM tpch.tiny.nation\n", 50L);
            this.assertInvocations("SELECT * FROM \"test_select_system_table$partitions\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).addCopies((Object)GlueMetastoreMethod.GET_PARTITION_NAMES, 5).build());
            this.assertInvocations("SELECT * FROM \"test_select_system_table$properties\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_system_table");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInformationSchemaTableAndColumns() {
        String schemaName = "test_i_s_columns_schema" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        try {
            Session session = Session.builder((Session)this.getSession()).setSchema(schemaName).build();
            int tablesCreated = 0;
            try {
                for (int tables : List.of(Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(7))) {
                    log.info("testInformationSchemaColumns: Testing with %s tables", new Object[]{tables});
                    Preconditions.checkState((tablesCreated < tables ? 1 : 0) != 0);
                    for (int i = tablesCreated; i < tables; ++i) {
                        ++tablesCreated;
                        this.assertUpdate(session, "CREATE TABLE test_select_i_s_columns" + i + "(id varchar, age integer)");
                        this.assertUpdate(session, "INSERT INTO test_select_i_s_columns" + i + " VALUES ('abc', 11)", 1L);
                        this.assertUpdate(session, "INSERT INTO test_select_i_s_columns" + i + " VALUES ('xyz', 12)", 1L);
                        this.assertUpdate(session, "CREATE TABLE test_other_select_i_s_columns" + i + "(id varchar, age integer)");
                    }
                    this.assertInvocations(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name LIKE 'test_select_i_s_columns%'", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLES).addCopies((Object)GlueMetastoreMethod.GET_TABLE, tables * 2).build());
                }
                this.assertInvocations(session, "SELECT * FROM information_schema.tables WHERE table_schema = CURRENT_SCHEMA", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLES).build());
                this.assertInvocations(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name = 'test_select_i_s_columns0'", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
                this.assertInvocations(session, "DESCRIBE test_select_i_s_columns0", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_DATABASE).add((Object)GlueMetastoreMethod.GET_TABLE).build());
            }
            finally {
                for (int i = 0; i < tablesCreated; ++i) {
                    this.assertUpdate(session, "DROP TABLE IF EXISTS test_select_i_s_columns" + i);
                    this.assertUpdate(session, "DROP TABLE IF EXISTS test_other_select_i_s_columns" + i);
                }
            }
        }
        finally {
            this.assertUpdate("DROP SCHEMA " + schemaName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemMetadataTableComments() {
        String schemaName = "test_s_m_table_comments" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        try {
            Session session = Session.builder((Session)this.getSession()).setSchema(schemaName).build();
            int tablesCreated = 0;
            try {
                for (int tables : List.of(Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(7))) {
                    log.info("testSystemMetadataTableComments: Testing with %s tables", new Object[]{tables});
                    Preconditions.checkState((tablesCreated < tables ? 1 : 0) != 0);
                    for (int i = tablesCreated; i < tables; ++i) {
                        ++tablesCreated;
                        this.assertUpdate(session, "CREATE TABLE test_select_s_m_t_comments" + i + "(id varchar, age integer)");
                        this.assertUpdate(session, "INSERT INTO test_select_s_m_t_comments" + i + " VALUES ('abc', 11)", 1L);
                        this.assertUpdate(session, "INSERT INTO test_select_s_m_t_comments" + i + " VALUES ('xyz', 12)", 1L);
                        this.assertUpdate(session, "CREATE TABLE test_other_select_s_m_t_comments" + i + "(id varchar, age integer)");
                    }
                    this.assertInvocations(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA AND table_name LIKE 'test_select_s_m_t_comments%'", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLES).addCopies((Object)GlueMetastoreMethod.GET_TABLE, tables * 2).build());
                }
                this.assertInvocations(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA AND table_name = 'test_select_s_m_t_comments0'", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            }
            finally {
                for (int i = 0; i < tablesCreated; ++i) {
                    this.assertUpdate(session, "DROP TABLE IF EXISTS test_select_s_m_t_comments" + i);
                    this.assertUpdate(session, "DROP TABLE IF EXISTS test_other_select_s_m_t_comments" + i);
                }
            }
        }
        finally {
            this.assertUpdate("DROP SCHEMA " + schemaName);
        }
    }

    @Test
    public void testShowTables() {
        this.assertInvocations("SHOW TABLES", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_DATABASE).add((Object)GlueMetastoreMethod.GET_TABLES).build());
    }

    private void assertInvocations(@Language(value="SQL") String query, Multiset<GlueMetastoreMethod> expectedGlueInvocations) {
        this.assertInvocations(this.getSession(), query, expectedGlueInvocations);
    }

    private void assertInvocations(Session session, @Language(value="SQL") String query, Multiset<GlueMetastoreMethod> expectedGlueInvocations) {
        Map countsBefore = (Map)Arrays.stream(GlueMetastoreMethod.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), method -> method.getInvocationCount(this.glueStats)));
        this.getQueryRunner().execute(session, query);
        Map countsAfter = (Map)Arrays.stream(GlueMetastoreMethod.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), method -> method.getInvocationCount(this.glueStats)));
        Multiset actualGlueInvocations = (Multiset)Arrays.stream(GlueMetastoreMethod.values()).collect(ImmutableMultiset.toImmutableMultiset(Function.identity(), method -> Objects.requireNonNull((Integer)countsAfter.get(method)) - Objects.requireNonNull((Integer)countsBefore.get(method))));
        MultisetAssertions.assertMultisetsEqual((Multiset)actualGlueInvocations, expectedGlueInvocations);
    }
}

