/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.base.Verify;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.metastore.glue.GlueCache;
import io.trino.plugin.hive.metastore.glue.GlueContext;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreModule;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.function.Consumer;
import software.amazon.awssdk.services.glue.GlueClient;

public final class TestingGlueHiveMetastore {
    private TestingGlueHiveMetastore() {
    }

    public static GlueHiveMetastore createTestingGlueHiveMetastore(Path defaultWarehouseDir, Consumer<AutoCloseable> registerResource) {
        if (!Files.exists(defaultWarehouseDir, new LinkOption[0])) {
            try {
                Files.createDirectories(defaultWarehouseDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create directory: %s".formatted(defaultWarehouseDir), e);
            }
        }
        Verify.verify((boolean)Files.isDirectory(defaultWarehouseDir, new LinkOption[0]), (String)"%s is not a directory", (Object)defaultWarehouseDir);
        return TestingGlueHiveMetastore.createTestingGlueHiveMetastore(defaultWarehouseDir.toUri(), registerResource);
    }

    public static GlueHiveMetastore createTestingGlueHiveMetastore(URI warehouseUri, Consumer<AutoCloseable> registerResource) {
        GlueHiveMetastoreConfig glueConfig = new GlueHiveMetastoreConfig().setDefaultWarehouseDir(warehouseUri.toString());
        GlueClient glueClient = GlueMetastoreModule.createGlueClient((GlueHiveMetastoreConfig)glueConfig, (OpenTelemetry)OpenTelemetry.noop());
        registerResource.accept((AutoCloseable)glueClient);
        return new GlueHiveMetastore(glueClient, new GlueContext(glueConfig), GlueCache.NOOP, (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, glueConfig, EnumSet.allOf(GlueHiveMetastore.TableKind.class));
    }
}

