/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.v1;

import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UserDefinedFunction;
import com.amazonaws.services.glue.model.UserDefinedFunctionInput;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.metastore.Database;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.Partition;
import io.trino.metastore.Storage;
import io.trino.metastore.Table;
import io.trino.plugin.hive.metastore.glue.v1.TestingMetastoreObjects;
import io.trino.plugin.hive.metastore.glue.v1.converter.GlueInputConverter;
import io.trino.plugin.hive.metastore.glue.v1.converter.GlueToTrinoConverter;
import io.trino.spi.function.LanguageFunction;
import java.util.Collection;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGlueInputConverter {
    private final Database testDb = TestingMetastoreObjects.getTrinoTestDatabase();
    private final Table testTbl = TestingMetastoreObjects.getTrinoTestTable(this.testDb.getDatabaseName());
    private final Partition testPartition = TestingMetastoreObjects.getTrinoTestPartition(this.testDb.getDatabaseName(), this.testTbl.getTableName(), (List<String>)ImmutableList.of((Object)"val1"));

    @Test
    public void testConvertDatabase() {
        DatabaseInput dbInput = GlueInputConverter.convertDatabase((Database)this.testDb);
        Assertions.assertThat((String)dbInput.getName()).isEqualTo(this.testDb.getDatabaseName());
        Assertions.assertThat((String)dbInput.getDescription()).isEqualTo((String)this.testDb.getComment().get());
        Assertions.assertThat((String)dbInput.getLocationUri()).isEqualTo((String)this.testDb.getLocation().get());
        Assertions.assertThat((Map)dbInput.getParameters()).isEqualTo((Object)this.testDb.getParameters());
    }

    @Test
    public void testConvertTable() {
        TableInput tblInput = GlueInputConverter.convertTable((Table)this.testTbl);
        Assertions.assertThat((String)tblInput.getName()).isEqualTo(this.testTbl.getTableName());
        Assertions.assertThat((String)tblInput.getOwner()).isEqualTo((String)this.testTbl.getOwner().orElse(null));
        Assertions.assertThat((String)tblInput.getTableType()).isEqualTo(this.testTbl.getTableType());
        Assertions.assertThat((Map)tblInput.getParameters()).isEqualTo((Object)this.testTbl.getParameters());
        TestGlueInputConverter.assertColumnList(tblInput.getStorageDescriptor().getColumns(), this.testTbl.getDataColumns());
        TestGlueInputConverter.assertColumnList(tblInput.getPartitionKeys(), this.testTbl.getPartitionColumns());
        TestGlueInputConverter.assertStorage(tblInput.getStorageDescriptor(), this.testTbl.getStorage());
        Assertions.assertThat((String)tblInput.getViewExpandedText()).isEqualTo((String)this.testTbl.getViewExpandedText().get());
        Assertions.assertThat((String)tblInput.getViewOriginalText()).isEqualTo((String)this.testTbl.getViewOriginalText().get());
    }

    @Test
    public void testConvertPartition() {
        PartitionInput partitionInput = GlueInputConverter.convertPartition((Partition)this.testPartition);
        Assertions.assertThat((Map)partitionInput.getParameters()).isEqualTo((Object)this.testPartition.getParameters());
        TestGlueInputConverter.assertStorage(partitionInput.getStorageDescriptor(), this.testPartition.getStorage());
        Assertions.assertThat((List)partitionInput.getValues()).isEqualTo((Object)this.testPartition.getValues());
    }

    @Test
    public void testConvertFunction() {
        String sql = HexFormat.of().formatHex(Slices.random((int)2000, (Random)new Random(0L)).getBytes());
        LanguageFunction expected = new LanguageFunction("(integer,bigint,varchar)", sql, List.of(), Optional.of("owner"));
        UserDefinedFunctionInput input = GlueInputConverter.convertFunction((String)"test_name", (LanguageFunction)expected);
        Assertions.assertThat((String)input.getOwnerName()).isEqualTo((String)expected.owner().orElseThrow());
        UserDefinedFunction function = new UserDefinedFunction().withOwnerName(input.getOwnerName()).withResourceUris((Collection)input.getResourceUris());
        LanguageFunction actual = GlueToTrinoConverter.convertFunction((UserDefinedFunction)function);
        Assertions.assertThat((List)input.getResourceUris()).hasSize(3);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
        function.setOwnerName("other");
        actual = GlueToTrinoConverter.convertFunction((UserDefinedFunction)function);
        Assertions.assertThat((Optional)actual.owner()).isEqualTo(Optional.of("other"));
    }

    private static void assertColumnList(List<Column> actual, List<io.trino.metastore.Column> expected) {
        if (expected == null) {
            Assertions.assertThat(actual).isNull();
        }
        Assertions.assertThat(actual).hasSize(expected.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestGlueInputConverter.assertColumn(actual.get(i), expected.get(i));
        }
    }

    private static void assertColumn(Column actual, io.trino.metastore.Column expected) {
        Assertions.assertThat((String)actual.getName()).isEqualTo(expected.getName());
        Assertions.assertThat((String)actual.getType()).isEqualTo(expected.getType().getHiveTypeName().toString());
        Assertions.assertThat((String)actual.getComment()).isEqualTo((String)expected.getComment().get());
    }

    private static void assertStorage(StorageDescriptor actual, Storage expected) {
        Assertions.assertThat((String)actual.getLocation()).isEqualTo(expected.getLocation());
        Assertions.assertThat((String)actual.getSerdeInfo().getSerializationLibrary()).isEqualTo(expected.getStorageFormat().getSerde());
        Assertions.assertThat((String)actual.getInputFormat()).isEqualTo(expected.getStorageFormat().getInputFormat());
        Assertions.assertThat((String)actual.getOutputFormat()).isEqualTo(expected.getStorageFormat().getOutputFormat());
        if (expected.getBucketProperty().isPresent()) {
            HiveBucketProperty bucketProperty = (HiveBucketProperty)expected.getBucketProperty().get();
            Assertions.assertThat((List)actual.getBucketColumns()).isEqualTo((Object)bucketProperty.bucketedBy());
            Assertions.assertThat((int)actual.getNumberOfBuckets()).isEqualTo(bucketProperty.bucketCount());
        }
    }
}

