/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.v1;

import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.Table;
import com.amazonaws.util.CollectionUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.HiveType;
import io.trino.metastore.Partition;
import io.trino.metastore.Storage;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.metastore.glue.v1.TestingMetastoreObjects;
import io.trino.plugin.hive.metastore.glue.v1.converter.GlueToTrinoConverter;
import io.trino.spi.security.PrincipalType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestGlueToTrinoConverter {
    private static final String PUBLIC_OWNER = "PUBLIC";
    private Database testDatabase;
    private Table testTable;
    private com.amazonaws.services.glue.model.Partition testPartition;

    @BeforeEach
    public void setup() {
        this.testDatabase = TestingMetastoreObjects.getGlueTestDatabase();
        this.testTable = TestingMetastoreObjects.getGlueTestTable(this.testDatabase.getName());
        this.testPartition = TestingMetastoreObjects.getGlueTestPartition(this.testDatabase.getName(), this.testTable.getName(), (List<String>)ImmutableList.of((Object)"val1"));
    }

    private static GlueToTrinoConverter.GluePartitionConverter createPartitionConverter(Table table) {
        return new GlueToTrinoConverter.GluePartitionConverter(table.getDatabaseName(), table.getName());
    }

    @Test
    public void testConvertDatabase() {
        io.trino.metastore.Database trinoDatabase = GlueToTrinoConverter.convertDatabase((Database)this.testDatabase);
        Assertions.assertThat((String)trinoDatabase.getDatabaseName()).isEqualTo(this.testDatabase.getName());
        Assertions.assertThat((String)((String)trinoDatabase.getLocation().get())).isEqualTo(this.testDatabase.getLocationUri());
        Assertions.assertThat((String)((String)trinoDatabase.getComment().get())).isEqualTo(this.testDatabase.getDescription());
        Assertions.assertThat((Map)trinoDatabase.getParameters()).isEqualTo((Object)this.testDatabase.getParameters());
        Assertions.assertThat((Optional)trinoDatabase.getOwnerName()).isEqualTo(Optional.of(PUBLIC_OWNER));
        Assertions.assertThat((Optional)trinoDatabase.getOwnerType()).isEqualTo(Optional.of(PrincipalType.ROLE));
    }

    @Test
    public void testConvertTable() {
        io.trino.metastore.Table trinoTable = GlueToTrinoConverter.convertTable((Table)this.testTable, (String)this.testDatabase.getName());
        Assertions.assertThat((String)trinoTable.getTableName()).isEqualTo(this.testTable.getName());
        Assertions.assertThat((String)trinoTable.getDatabaseName()).isEqualTo(this.testDatabase.getName());
        Assertions.assertThat((String)trinoTable.getTableType()).isEqualTo(GlueToTrinoConverter.getTableTypeNullable((Table)this.testTable));
        Assertions.assertThat((String)trinoTable.getOwner().orElse(null)).isEqualTo(this.testTable.getOwner());
        Assertions.assertThat((Map)trinoTable.getParameters()).isEqualTo((Object)GlueToTrinoConverter.getTableParameters((Table)this.testTable));
        TestGlueToTrinoConverter.assertColumnList(trinoTable.getDataColumns(), ((StorageDescriptor)GlueToTrinoConverter.getStorageDescriptor((Table)this.testTable).orElseThrow()).getColumns());
        TestGlueToTrinoConverter.assertColumnList(trinoTable.getPartitionColumns(), this.testTable.getPartitionKeys());
        TestGlueToTrinoConverter.assertStorage(trinoTable.getStorage(), (StorageDescriptor)GlueToTrinoConverter.getStorageDescriptor((Table)this.testTable).orElseThrow());
        Assertions.assertThat((String)((String)trinoTable.getViewOriginalText().get())).isEqualTo(this.testTable.getViewOriginalText());
        Assertions.assertThat((String)((String)trinoTable.getViewExpandedText().get())).isEqualTo(this.testTable.getViewExpandedText());
    }

    @Test
    public void testConvertTableWithOpenCSVSerDe() {
        Table glueTable = TestingMetastoreObjects.getGlueTestTable(this.testDatabase.getName());
        glueTable.setStorageDescriptor(TestingMetastoreObjects.getGlueTestStorageDescriptor((List<Column>)ImmutableList.of((Object)TestingMetastoreObjects.getGlueTestColumn("int")), "org.apache.hadoop.hive.serde2.OpenCSVSerde"));
        io.trino.metastore.Table trinoTable = GlueToTrinoConverter.convertTable((Table)glueTable, (String)this.testDatabase.getName());
        Assertions.assertThat((String)trinoTable.getTableName()).isEqualTo(glueTable.getName());
        Assertions.assertThat((String)trinoTable.getDatabaseName()).isEqualTo(this.testDatabase.getName());
        Assertions.assertThat((String)trinoTable.getTableType()).isEqualTo(GlueToTrinoConverter.getTableTypeNullable((Table)glueTable));
        Assertions.assertThat((String)trinoTable.getOwner().orElse(null)).isEqualTo(glueTable.getOwner());
        Assertions.assertThat((Map)trinoTable.getParameters()).isEqualTo((Object)GlueToTrinoConverter.getTableParameters((Table)glueTable));
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
        Assertions.assertThat((Object)((io.trino.metastore.Column)trinoTable.getDataColumns().get(0)).getType()).isEqualTo((Object)HiveType.HIVE_STRING);
        TestGlueToTrinoConverter.assertColumnList(trinoTable.getPartitionColumns(), glueTable.getPartitionKeys());
        TestGlueToTrinoConverter.assertStorage(trinoTable.getStorage(), (StorageDescriptor)GlueToTrinoConverter.getStorageDescriptor((Table)glueTable).orElseThrow());
        Assertions.assertThat((String)((String)trinoTable.getViewOriginalText().get())).isEqualTo(glueTable.getViewOriginalText());
        Assertions.assertThat((String)((String)trinoTable.getViewExpandedText().get())).isEqualTo(glueTable.getViewExpandedText());
    }

    @Test
    public void testConvertTableWithoutTableType() {
        Table table = TestingMetastoreObjects.getGlueTestTable(this.testDatabase.getName());
        table.setTableType(null);
        io.trino.metastore.Table trinoTable = GlueToTrinoConverter.convertTable((Table)table, (String)this.testDatabase.getName());
        Assertions.assertThat((String)trinoTable.getTableType()).isEqualTo(TableType.EXTERNAL_TABLE.name());
    }

    @Test
    public void testConvertTableNullPartitions() {
        this.testTable.setPartitionKeys(null);
        io.trino.metastore.Table trinoTable = GlueToTrinoConverter.convertTable((Table)this.testTable, (String)this.testDatabase.getName());
        Assertions.assertThat((List)trinoTable.getPartitionColumns()).isEmpty();
    }

    @Test
    public void testConvertTableUppercaseColumnType() {
        Column uppercaseColumn = TestingMetastoreObjects.getGlueTestColumn().withType("String");
        ((StorageDescriptor)GlueToTrinoConverter.getStorageDescriptor((Table)this.testTable).orElseThrow()).setColumns((Collection)ImmutableList.of((Object)uppercaseColumn));
        GlueToTrinoConverter.convertTable((Table)this.testTable, (String)this.testDatabase.getName());
    }

    @Test
    public void testConvertPartition() {
        GlueToTrinoConverter.GluePartitionConverter converter = TestGlueToTrinoConverter.createPartitionConverter(this.testTable);
        Partition trinoPartition = converter.apply(this.testPartition);
        Assertions.assertThat((String)trinoPartition.getDatabaseName()).isEqualTo(this.testPartition.getDatabaseName());
        Assertions.assertThat((String)trinoPartition.getTableName()).isEqualTo(this.testPartition.getTableName());
        TestGlueToTrinoConverter.assertColumnList(trinoPartition.getColumns(), this.testPartition.getStorageDescriptor().getColumns());
        Assertions.assertThat((List)trinoPartition.getValues()).isEqualTo((Object)this.testPartition.getValues());
        TestGlueToTrinoConverter.assertStorage(trinoPartition.getStorage(), this.testPartition.getStorageDescriptor());
        Assertions.assertThat((Map)trinoPartition.getParameters()).isEqualTo((Object)GlueToTrinoConverter.getPartitionParameters((com.amazonaws.services.glue.model.Partition)this.testPartition));
    }

    @Test
    public void testPartitionConversionMemoization() {
        String fakeS3Location = "s3://some-fake-location";
        this.testPartition.getStorageDescriptor().setLocation(fakeS3Location);
        com.amazonaws.services.glue.model.Partition partitionTwo = TestingMetastoreObjects.getGlueTestPartition(this.testDatabase.getName(), this.testTable.getName(), new ArrayList<String>(this.testPartition.getValues()));
        partitionTwo.getStorageDescriptor().setColumns(new ArrayList(this.testPartition.getStorageDescriptor().getColumns()));
        partitionTwo.getStorageDescriptor().setBucketColumns(new ArrayList(this.testPartition.getStorageDescriptor().getBucketColumns()));
        partitionTwo.getStorageDescriptor().setLocation(fakeS3Location);
        partitionTwo.getStorageDescriptor().setInputFormat(this.testPartition.getStorageDescriptor().getInputFormat());
        partitionTwo.getStorageDescriptor().setOutputFormat(this.testPartition.getStorageDescriptor().getOutputFormat());
        partitionTwo.getStorageDescriptor().setParameters(new HashMap(this.testPartition.getStorageDescriptor().getParameters()));
        GlueToTrinoConverter.GluePartitionConverter converter = TestGlueToTrinoConverter.createPartitionConverter(this.testTable);
        Partition trinoPartition = converter.apply(this.testPartition);
        Partition trinoPartition2 = converter.apply(partitionTwo);
        Assertions.assertThat((Object)trinoPartition).isNotSameAs((Object)trinoPartition2);
        Assertions.assertThat((String)trinoPartition2.getDatabaseName()).isSameAs((Object)trinoPartition.getDatabaseName());
        Assertions.assertThat((String)trinoPartition2.getTableName()).isSameAs((Object)trinoPartition.getTableName());
        Assertions.assertThat((List)trinoPartition2.getColumns()).isSameAs((Object)trinoPartition.getColumns());
        Assertions.assertThat((Map)trinoPartition2.getParameters()).isSameAs((Object)trinoPartition.getParameters());
        Assertions.assertThat((List)trinoPartition2.getValues()).isNotSameAs((Object)trinoPartition.getValues());
        Storage storage = trinoPartition.getStorage();
        Storage storage2 = trinoPartition2.getStorage();
        Assertions.assertThat((Object)storage2.getStorageFormat()).isSameAs((Object)storage.getStorageFormat());
        Assertions.assertThat((Optional)storage2.getBucketProperty()).isSameAs((Object)storage.getBucketProperty());
        Assertions.assertThat((Map)storage2.getSerdeParameters()).isSameAs((Object)storage.getSerdeParameters());
        Assertions.assertThat((String)storage2.getLocation()).isNotSameAs((Object)storage.getLocation());
    }

    @Test
    public void testDatabaseNullParameters() {
        this.testDatabase.setParameters(null);
        Assertions.assertThat((Map)GlueToTrinoConverter.convertDatabase((Database)this.testDatabase).getParameters()).isNotNull();
    }

    @Test
    public void testTableNullParameters() {
        this.testTable.setParameters(null);
        ((StorageDescriptor)GlueToTrinoConverter.getStorageDescriptor((Table)this.testTable).orElseThrow()).getSerdeInfo().setParameters(null);
        io.trino.metastore.Table trinoTable = GlueToTrinoConverter.convertTable((Table)this.testTable, (String)this.testDatabase.getName());
        Assertions.assertThat((Map)trinoTable.getParameters()).isNotNull();
        Assertions.assertThat((Map)trinoTable.getStorage().getSerdeParameters()).isNotNull();
    }

    @Test
    public void testIcebergTableNullStorageDescriptor() {
        this.testTable.setParameters((Map)ImmutableMap.of((Object)"table_type", (Object)"iceberg"));
        this.testTable.setStorageDescriptor(null);
        io.trino.metastore.Table trinoTable = GlueToTrinoConverter.convertTable((Table)this.testTable, (String)this.testDatabase.getName());
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
    }

    @Test
    public void testIcebergTableNonNullStorageDescriptor() {
        this.testTable.setParameters((Map)ImmutableMap.of((Object)"table_type", (Object)"iceberg"));
        Assertions.assertThat((Optional)GlueToTrinoConverter.getStorageDescriptor((Table)this.testTable)).isPresent();
        io.trino.metastore.Table trinoTable = GlueToTrinoConverter.convertTable((Table)this.testTable, (String)this.testDatabase.getName());
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
    }

    @Test
    public void testDeltaTableNullStorageDescriptor() {
        this.testTable.setParameters((Map)ImmutableMap.of((Object)"spark.sql.sources.provider", (Object)"delta"));
        this.testTable.setStorageDescriptor(null);
        io.trino.metastore.Table trinoTable = GlueToTrinoConverter.convertTable((Table)this.testTable, (String)this.testDatabase.getName());
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
    }

    @Test
    public void testDeltaTableNonNullStorageDescriptor() {
        this.testTable.setParameters((Map)ImmutableMap.of((Object)"spark.sql.sources.provider", (Object)"delta"));
        Assertions.assertThat((Optional)GlueToTrinoConverter.getStorageDescriptor((Table)this.testTable)).isPresent();
        io.trino.metastore.Table trinoTable = GlueToTrinoConverter.convertTable((Table)this.testTable, (String)this.testDatabase.getName());
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
    }

    @Test
    public void testIcebergMaterializedViewNullStorageDescriptor() {
        Table testMaterializedView = TestingMetastoreObjects.getGlueTestTrinoMaterializedView(this.testDatabase.getName());
        Assertions.assertThat((Optional)GlueToTrinoConverter.getStorageDescriptor((Table)testMaterializedView)).isEmpty();
        io.trino.metastore.Table trinoTable = GlueToTrinoConverter.convertTable((Table)testMaterializedView, (String)this.testDatabase.getName());
        Assertions.assertThat((List)trinoTable.getDataColumns()).hasSize(1);
    }

    @Test
    public void testPartitionNullParameters() {
        this.testPartition.setParameters(null);
        Assertions.assertThat((Map)TestGlueToTrinoConverter.createPartitionConverter(this.testTable).apply(this.testPartition).getParameters()).isNotNull();
    }

    private static void assertColumnList(List<io.trino.metastore.Column> actual, List<Column> expected) {
        if (expected == null) {
            Assertions.assertThat(actual).isNull();
        }
        Assertions.assertThat(actual).hasSize(expected.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestGlueToTrinoConverter.assertColumn(actual.get(i), expected.get(i));
        }
    }

    private static void assertColumn(io.trino.metastore.Column actual, Column expected) {
        Assertions.assertThat((String)actual.getName()).isEqualTo(expected.getName());
        Assertions.assertThat((String)actual.getType().getHiveTypeName().toString()).isEqualTo(expected.getType());
        Assertions.assertThat((String)((String)actual.getComment().get())).isEqualTo(expected.getComment());
    }

    private static void assertStorage(Storage actual, StorageDescriptor expected) {
        Assertions.assertThat((String)actual.getLocation()).isEqualTo(expected.getLocation());
        Assertions.assertThat((String)actual.getStorageFormat().getSerde()).isEqualTo(expected.getSerdeInfo().getSerializationLibrary());
        Assertions.assertThat((String)actual.getStorageFormat().getInputFormat()).isEqualTo(expected.getInputFormat());
        Assertions.assertThat((String)actual.getStorageFormat().getOutputFormat()).isEqualTo(expected.getOutputFormat());
        if (!CollectionUtils.isNullOrEmpty((Collection)expected.getBucketColumns())) {
            HiveBucketProperty bucketProperty = (HiveBucketProperty)actual.getBucketProperty().get();
            Assertions.assertThat((List)bucketProperty.bucketedBy()).isEqualTo((Object)expected.getBucketColumns());
            Assertions.assertThat((int)bucketProperty.bucketCount()).isEqualTo(expected.getNumberOfBuckets().intValue());
        }
    }
}

