/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.v1;

import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.Table;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metastore.HiveType;
import io.trino.metastore.Partition;
import io.trino.metastore.Storage;
import io.trino.metastore.StorageFormat;
import io.trino.plugin.hive.TableType;
import io.trino.spi.security.PrincipalType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;

public final class TestingMetastoreObjects {
    private static final Consumer<Storage.Builder> STORAGE_CONSUMER = storage -> storage.setStorageFormat(StorageFormat.create((String)"SerdeLib", (String)"InputFormat", (String)"OutputFormat")).setLocation("/test-tbl").setBucketProperty(Optional.empty()).setSerdeParameters((Map)ImmutableMap.of());

    private TestingMetastoreObjects() {
    }

    public static Database getGlueTestDatabase() {
        return new Database().withName("test-db" + TestingMetastoreObjects.generateRandom()).withDescription("database desc").withLocationUri("/db").withParameters((Map)ImmutableMap.of());
    }

    public static Table getGlueTestTable(String dbName) {
        return new Table().withDatabaseName(dbName).withName("test-tbl" + TestingMetastoreObjects.generateRandom()).withOwner("owner").withParameters((Map)ImmutableMap.of()).withPartitionKeys((Collection)ImmutableList.of((Object)TestingMetastoreObjects.getGlueTestColumn())).withStorageDescriptor(TestingMetastoreObjects.getGlueTestStorageDescriptor()).withTableType(TableType.EXTERNAL_TABLE.name()).withViewOriginalText("originalText").withViewExpandedText("expandedText");
    }

    public static Table getGlueTestTrinoMaterializedView(String dbName) {
        return new Table().withDatabaseName(dbName).withName("test-mv" + TestingMetastoreObjects.generateRandom()).withOwner("owner").withParameters((Map)ImmutableMap.of((Object)"presto_view", (Object)"true", (Object)"comment", (Object)"Presto Materialized View")).withPartitionKeys(new Column[0]).withStorageDescriptor(null).withTableType(TableType.VIRTUAL_VIEW.name()).withViewOriginalText("/* %s: base64encodedquery */".formatted("Presto Materialized View")).withViewExpandedText("Presto Materialized View");
    }

    public static Column getGlueTestColumn() {
        return TestingMetastoreObjects.getGlueTestColumn("string");
    }

    public static Column getGlueTestColumn(String type) {
        return new Column().withName("test-col" + TestingMetastoreObjects.generateRandom()).withType(type).withComment("column comment");
    }

    public static StorageDescriptor getGlueTestStorageDescriptor() {
        return TestingMetastoreObjects.getGlueTestStorageDescriptor((List<Column>)ImmutableList.of((Object)TestingMetastoreObjects.getGlueTestColumn()), "SerdeLib");
    }

    public static StorageDescriptor getGlueTestStorageDescriptor(List<Column> columns, String serde) {
        return new StorageDescriptor().withBucketColumns((Collection)ImmutableList.of((Object)"test-bucket-col")).withColumns(columns).withParameters((Map)ImmutableMap.of()).withSerdeInfo(new SerDeInfo().withSerializationLibrary(serde).withParameters((Map)ImmutableMap.of())).withInputFormat("InputFormat").withOutputFormat("OutputFormat").withLocation("/test-tbl").withNumberOfBuckets(Integer.valueOf(1));
    }

    public static com.amazonaws.services.glue.model.Partition getGlueTestPartition(String dbName, String tblName, List<String> values) {
        return new com.amazonaws.services.glue.model.Partition().withDatabaseName(dbName).withTableName(tblName).withValues(values).withParameters((Map)ImmutableMap.of()).withStorageDescriptor(TestingMetastoreObjects.getGlueTestStorageDescriptor());
    }

    public static io.trino.metastore.Database getTrinoTestDatabase() {
        return io.trino.metastore.Database.builder().setDatabaseName("test-db" + TestingMetastoreObjects.generateRandom()).setComment(Optional.of("database desc")).setLocation(Optional.of("/db")).setParameters((Map)ImmutableMap.of()).setOwnerName(Optional.of("PUBLIC")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
    }

    public static io.trino.metastore.Table getTrinoTestTable(String dbName) {
        return io.trino.metastore.Table.builder().setDatabaseName(dbName).setTableName("test-tbl" + TestingMetastoreObjects.generateRandom()).setOwner(Optional.of("owner")).setParameters((Map)ImmutableMap.of()).setTableType(TableType.EXTERNAL_TABLE.name()).setDataColumns((List)ImmutableList.of((Object)TestingMetastoreObjects.getTrinoTestColumn())).setPartitionColumns((List)ImmutableList.of((Object)TestingMetastoreObjects.getTrinoTestColumn())).setViewOriginalText(Optional.of("originalText")).setViewExpandedText(Optional.of("expandedText")).withStorage(STORAGE_CONSUMER).build();
    }

    public static Partition getTrinoTestPartition(String dbName, String tblName, List<String> values) {
        return Partition.builder().setDatabaseName(dbName).setTableName(tblName).setValues(values).setColumns((List)ImmutableList.of((Object)TestingMetastoreObjects.getTrinoTestColumn())).setParameters((Map)ImmutableMap.of()).withStorage(STORAGE_CONSUMER).build();
    }

    public static io.trino.metastore.Column getTrinoTestColumn() {
        return new io.trino.metastore.Column("test-col" + TestingMetastoreObjects.generateRandom(), HiveType.HIVE_STRING, Optional.of("column comment"), Map.of());
    }

    private static String generateRandom() {
        return String.format("%04x", ThreadLocalRandom.current().nextInt());
    }
}

