/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.reflect.Reflection;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.plugin.base.util.AutoCloseableCloser;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.SchemaAlreadyExistsException;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.hive.metastore.AbstractTestHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.MetastoreClientAdapterProvider;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.testing.TestingNames;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
final class TestBridgingHiveMetastore
extends AbstractTestHiveMetastore {
    private final AutoCloseableCloser closer = AutoCloseableCloser.create();
    private final HiveMetastore metastore;

    TestBridgingHiveMetastore() {
        HiveHadoop hiveHadoop = (HiveHadoop)((Object)this.closer.register((AutoCloseable)((Object)HiveHadoop.builder().build())));
        hiveHadoop.start();
        MetastoreClientAdapterProvider metastoreClientAdapterProvider = delegate -> (ThriftMetastoreClient)Reflection.newProxy(ThriftMetastoreClient.class, (proxy, method, methodArgs) -> {
            Object result;
            try {
                result = method.invoke((Object)delegate, methodArgs);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            if (method.getName().equals("createDatabase") || method.getName().equals("createTable") || method.getName().equals("dropTable")) {
                throw new RuntimeException("Test-simulated Hive Metastore timeout exception");
            }
            return result;
        });
        this.metastore = new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(hiveHadoop.getHiveMetastoreEndpoint(), metastoreClientAdapterProvider).thriftMetastoreConfig(new ThriftMetastoreConfig().setDeleteFilesOnDrop(true)).build(arg_0 -> ((AutoCloseableCloser)this.closer).register(arg_0)));
    }

    @AfterAll
    void afterAll() throws Exception {
        this.closer.close();
    }

    @Override
    protected HiveMetastore getMetastore() {
        return this.metastore;
    }

    @Test
    public void testCreateDatabaseWithRetries() {
        String databaseName = "test_database_" + TestingNames.randomNameSuffix();
        Database.Builder database = Database.builder().setDatabaseName(databaseName).setParameters(Map.of("trino_query_id", "query_id")).setOwnerName(Optional.empty()).setOwnerType(Optional.empty());
        this.getMetastore().createDatabase(database.build());
        database.setParameters(Map.of("trino_query_id", "another_query_id"));
        Assertions.assertThatThrownBy(() -> this.getMetastore().createDatabase(database.build())).isInstanceOf(SchemaAlreadyExistsException.class);
        this.getMetastore().dropDatabase(databaseName, false);
    }

    @Test
    public void testCreateTableWithRetries() {
        String databaseName = "test_database_" + TestingNames.randomNameSuffix();
        Database.Builder database = Database.builder().setDatabaseName(databaseName).setOwnerName(Optional.empty()).setOwnerType(Optional.empty());
        this.getMetastore().createDatabase(database.build());
        String tableName = "test_table" + TestingNames.randomNameSuffix();
        Table.Builder table = Table.builder().setDatabaseName(databaseName).setTableName(tableName).setParameters(Map.of("trino_query_id", "query_id")).setTableType(TableType.EXTERNAL_TABLE.name()).setOwner(Optional.empty());
        table.getStorageBuilder().setStorageFormat(HiveStorageFormat.PARQUET.toStorageFormat());
        this.getMetastore().createTable(table.build(), PrincipalPrivileges.NO_PRIVILEGES);
        table.setParameters(Map.of("trino_query_id", "another_query_id"));
        Assertions.assertThatThrownBy(() -> this.getMetastore().createTable(table.build(), PrincipalPrivileges.NO_PRIVILEGES)).isInstanceOf(TableAlreadyExistsException.class);
        this.getMetastore().dropTable(databaseName, tableName, false);
        this.getMetastore().dropDatabase(databaseName, false);
    }

    @Test
    public void testDropTableWithRetries() {
        String databaseName = "test_database_" + TestingNames.randomNameSuffix();
        Database.Builder database = Database.builder().setDatabaseName(databaseName).setOwnerName(Optional.empty()).setOwnerType(Optional.empty());
        this.getMetastore().createDatabase(database.build());
        String tableName = "test_table" + TestingNames.randomNameSuffix();
        Table.Builder table = Table.builder().setDatabaseName(databaseName).setTableName(tableName).setTableType(TableType.EXTERNAL_TABLE.name()).setOwner(Optional.empty());
        table.getStorageBuilder().setStorageFormat(HiveStorageFormat.PARQUET.toStorageFormat());
        this.getMetastore().createTable(table.build(), PrincipalPrivileges.NO_PRIVILEGES);
        Assertions.assertThat((Optional)this.getMetastore().getTable(databaseName, tableName)).isPresent();
        this.getMetastore().dropTable(databaseName, tableName, false);
        Assertions.assertThat((Optional)this.getMetastore().getTable(databaseName, tableName)).isEmpty();
        this.getMetastore().dropDatabase(databaseName, false);
    }
}

