/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.spi.security.PrincipalType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveMetastoreCatalogs
extends AbstractTestQueryFramework {
    private static final String TRINO_HIVE_CATALOG = "hive_catalog";
    private static final String TRINO_HIVE_CUSTOM_CATALOG = "hive_custom_catalog";
    private static final String HIVE_CUSTOM_CATALOG = "custom";
    private String bucketName;

    protected QueryRunner createQueryRunner() throws Exception {
        this.bucketName = "test-hive-metastore-catalogs-" + TestingNames.randomNameSuffix();
        HiveMinioDataLake hiveMinioDataLake = (HiveMinioDataLake)this.closeAfterClass(new HiveMinioDataLake(this.bucketName, HiveHadoop.HIVE3_IMAGE));
        hiveMinioDataLake.start();
        DistributedQueryRunner queryRunner = ((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().setHiveProperties(TestHiveMetastoreCatalogs.buildHiveProperties(hiveMinioDataLake)).setCreateTpchSchemas(false))).build();
        hiveMinioDataLake.getHiveHadoop().runOnMetastore("INSERT INTO CTLGS VALUES (2, '%s', 'Custom catalog', 's3://%s/custom')".formatted(HIVE_CUSTOM_CATALOG, this.bucketName));
        queryRunner.createCatalog(TRINO_HIVE_CUSTOM_CATALOG, "hive", (Map)ImmutableMap.builder().put((Object)"hive.metastore.thrift.catalog-name", (Object)HIVE_CUSTOM_CATALOG).putAll(TestHiveMetastoreCatalogs.buildHiveProperties(hiveMinioDataLake)).buildOrThrow());
        queryRunner.createCatalog(TRINO_HIVE_CATALOG, "hive", (Map)ImmutableMap.builder().put((Object)"hive.metastore.thrift.catalog-name", (Object)"hive").putAll(TestHiveMetastoreCatalogs.buildHiveProperties(hiveMinioDataLake)).buildOrThrow());
        return queryRunner;
    }

    private static Map<String, String> buildHiveProperties(HiveMinioDataLake hiveMinioDataLake) {
        return ImmutableMap.builder().put((Object)"hive.metastore", (Object)"thrift").put((Object)"hive.metastore.uri", (Object)hiveMinioDataLake.getHiveHadoop().getHiveMetastoreEndpoint().toString()).put((Object)"fs.hadoop.enabled", (Object)"false").put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)hiveMinioDataLake.getMinio().getMinioAddress()).put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").buildOrThrow();
    }

    @Test
    public void testShowTables() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW SCHEMAS"))).matches("VALUES VARCHAR 'default', VARCHAR 'information_schema'");
        HiveMetastore metastore = TestingHiveUtils.getConnectorService(this.getQueryRunner(), HiveMetastoreFactory.class).createMetastore(Optional.empty());
        String defaultCatalogSchema = "default_catalog_schema";
        metastore.createDatabase(TestHiveMetastoreCatalogs.createDatabaseMetastoreObject(defaultCatalogSchema, Optional.of("s3://%s/%s".formatted(this.bucketName, defaultCatalogSchema))));
        Session defaultCatalogSession = TestingSession.testSessionBuilder().setCatalog("hive").setSchema(defaultCatalogSchema).build();
        Session hiveCatalogSession = TestingSession.testSessionBuilder().setCatalog(TRINO_HIVE_CATALOG).setSchema(defaultCatalogSchema).build();
        this.assertUpdate(defaultCatalogSession, "CREATE TABLE tabledefault (data integer)");
        this.assertUpdate(defaultCatalogSession, "INSERT INTO tabledefault VALUES (1),(2),(3),(4)", 4L);
        String customCatalogSchema = "custom_catalog_schema";
        this.assertUpdate(TestingSession.testSessionBuilder().setCatalog(TRINO_HIVE_CUSTOM_CATALOG).build(), "CREATE SCHEMA " + customCatalogSchema);
        Session customCatalogSession = TestingSession.testSessionBuilder().setCatalog(TRINO_HIVE_CUSTOM_CATALOG).setSchema(customCatalogSchema).build();
        this.assertUpdate(customCatalogSession, "CREATE TABLE tablecustom (data integer)");
        this.assertUpdate(customCatalogSession, "INSERT INTO tablecustom VALUES (4),(5),(6),(7)", 4L);
        Assertions.assertThat((Stream)this.computeActual(defaultCatalogSession, "SHOW SCHEMAS").getOnlyColumn()).containsOnly(new Object[]{"default", "default_catalog_schema", "information_schema"});
        Assertions.assertThat((Stream)this.computeActual(hiveCatalogSession, "SHOW SCHEMAS").getOnlyColumn()).containsOnly(new Object[]{"default", "default_catalog_schema", "information_schema"});
        Assertions.assertThat((Stream)this.computeActual(customCatalogSession, "SHOW SCHEMAS").getOnlyColumn()).containsOnly(new Object[]{customCatalogSchema, "information_schema"});
        Assertions.assertThat((Stream)this.computeActual(defaultCatalogSession, "SHOW TABLES IN " + defaultCatalogSchema).getOnlyColumn()).containsOnly(new Object[]{"tabledefault"});
        Assertions.assertThat((Stream)this.computeActual(hiveCatalogSession, "SHOW TABLES IN " + defaultCatalogSchema).getOnlyColumn()).containsOnly(new Object[]{"tabledefault"});
        Assertions.assertThat((Stream)this.computeActual(customCatalogSession, "SHOW TABLES IN " + customCatalogSchema).getOnlyColumn()).containsOnly(new Object[]{"tablecustom"});
        Assertions.assertThat((String)((String)this.computeScalar(customCatalogSession, String.format("SHOW CREATE TABLE %s.tablecustom", customCatalogSchema)))).isEqualTo("CREATE TABLE hive_custom_catalog.custom_catalog_schema.tablecustom (\n   data integer\n)\nWITH (\n   format = 'ORC'\n)");
        this.assertQuery("SELECT a.data from hive.default_catalog_schema.tabledefault a, hive_custom_catalog.custom_catalog_schema.tablecustom b WHERE a.data = b.data", "SELECT 4");
        this.assertUpdate(defaultCatalogSession, "DROP SCHEMA " + defaultCatalogSchema + " CASCADE");
        this.assertUpdate(customCatalogSession, "DROP SCHEMA " + customCatalogSchema + " CASCADE");
    }

    private static Database createDatabaseMetastoreObject(String name, Optional<String> locationBase) {
        return Database.builder().setLocation(locationBase.map(base -> base + "/" + name)).setDatabaseName(name).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
    }
}

