/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.testing.ValidationAssertions;
import io.trino.plugin.hive.metastore.thrift.MetastoreKerberosConfig;
import jakarta.validation.constraints.AssertTrue;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMetastoreKerberosConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((MetastoreKerberosConfig)ConfigAssertions.recordDefaults(MetastoreKerberosConfig.class)).setHiveMetastoreServicePrincipal(null).setHiveMetastoreClientPrincipal(null).setHiveMetastoreClientKeytab(null).setHiveMetastoreClientCredentialCacheLocation(null));
    }

    @Test
    public void testExplicitPropertyMappingsForKeytab() throws Exception {
        Path clientKeytabFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.metastore.service.principal", (Object)"hive/_HOST@EXAMPLE.COM").put((Object)"hive.metastore.client.principal", (Object)"metastore@EXAMPLE.COM").put((Object)"hive.metastore.client.keytab", (Object)clientKeytabFile.toString()).buildOrThrow();
        ConfigurationFactory configurationFactory = new ConfigurationFactory((Map)properties);
        MetastoreKerberosConfig config = (MetastoreKerberosConfig)configurationFactory.build(MetastoreKerberosConfig.class);
        MetastoreKerberosConfig expected = new MetastoreKerberosConfig().setHiveMetastoreServicePrincipal("hive/_HOST@EXAMPLE.COM").setHiveMetastoreClientPrincipal("metastore@EXAMPLE.COM").setHiveMetastoreClientKeytab(clientKeytabFile.toString());
        Assertions.assertThat((String)config.getHiveMetastoreServicePrincipal()).isEqualTo(expected.getHiveMetastoreServicePrincipal());
        Assertions.assertThat((String)config.getHiveMetastoreClientPrincipal()).isEqualTo(expected.getHiveMetastoreClientPrincipal());
        Assertions.assertThat((Optional)config.getHiveMetastoreClientKeytab()).isEqualTo((Object)expected.getHiveMetastoreClientKeytab());
    }

    @Test
    public void testExplicitPropertyMappingsForCredentialCache() throws Exception {
        Path credentialCacheLocation = Files.createTempFile("credentialCache", null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.metastore.service.principal", (Object)"hive/_HOST@EXAMPLE.COM").put((Object)"hive.metastore.client.principal", (Object)"metastore@EXAMPLE.COM").put((Object)"hive.metastore.client.credential-cache.location", (Object)credentialCacheLocation.toString()).buildOrThrow();
        ConfigurationFactory configurationFactory = new ConfigurationFactory((Map)properties);
        MetastoreKerberosConfig config = (MetastoreKerberosConfig)configurationFactory.build(MetastoreKerberosConfig.class);
        MetastoreKerberosConfig expected = new MetastoreKerberosConfig().setHiveMetastoreServicePrincipal("hive/_HOST@EXAMPLE.COM").setHiveMetastoreClientPrincipal("metastore@EXAMPLE.COM").setHiveMetastoreClientCredentialCacheLocation(credentialCacheLocation.toString());
        Assertions.assertThat((String)config.getHiveMetastoreServicePrincipal()).isEqualTo(expected.getHiveMetastoreServicePrincipal());
        Assertions.assertThat((String)config.getHiveMetastoreClientPrincipal()).isEqualTo(expected.getHiveMetastoreClientPrincipal());
        Assertions.assertThat((Optional)config.getHiveMetastoreClientCredentialCacheLocation()).isEqualTo((Object)expected.getHiveMetastoreClientCredentialCacheLocation());
    }

    @Test
    public void testValidation() throws Exception {
        ValidationAssertions.assertFailsValidation((Object)new MetastoreKerberosConfig().setHiveMetastoreServicePrincipal("hive/_HOST@EXAMPLE.COM").setHiveMetastoreClientPrincipal("metastore@EXAMPLE.COM"), (String)"configValid", (String)"Exactly one of `hive.metastore.client.keytab` or `hive.metastore.client.credential-cache.location` must be specified", AssertTrue.class);
        Path clientKeytabFile = Files.createTempFile(null, null, new FileAttribute[0]);
        Path credentialCacheLocation = Files.createTempFile("credentialCache", null, new FileAttribute[0]);
        ValidationAssertions.assertFailsValidation((Object)new MetastoreKerberosConfig().setHiveMetastoreServicePrincipal("hive/_HOST@EXAMPLE.COM").setHiveMetastoreClientPrincipal("metastore@EXAMPLE.COM").setHiveMetastoreClientKeytab(clientKeytabFile.toString()).setHiveMetastoreClientCredentialCacheLocation(credentialCacheLocation.toString()), (String)"configValid", (String)"Exactly one of `hive.metastore.client.keytab` or `hive.metastore.client.credential-cache.location` must be specified", AssertTrue.class);
    }
}

