/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableList;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.hive.thrift.metastore.Database;
import io.trino.hive.thrift.metastore.NoSuchObjectException;
import io.trino.plugin.base.util.AutoCloseableCloser;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.metastore.thrift.HttpThriftMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.MockThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.TestingThriftHttpMetastoreServer;
import io.trino.plugin.hive.metastore.thrift.ThriftHttpMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.spi.NodeManager;
import io.trino.testing.TestingNodeManager;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestThriftHttpMetastoreClient {
    private static final AutoCloseableCloser closer = AutoCloseableCloser.create();
    private static ThriftMetastore delegate;

    @BeforeAll
    public static void setup() throws Exception {
        File tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        tempDir.deleteOnExit();
        delegate = TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(TestThriftHttpMetastoreClient.createFakeMetastoreClient()).build(arg_0 -> ((AutoCloseableCloser)closer).register(arg_0));
    }

    @AfterAll
    public static void tearDown() throws Exception {
        closer.close();
    }

    private static ThriftMetastoreClient createFakeMetastoreClient() {
        return new MockThriftMetastoreClient(){

            @Override
            public Database getDatabase(String databaseName) throws NoSuchObjectException {
                if (databaseName.equals("testDbName")) {
                    return new Database(databaseName, "testOwner", "testLocation", Map.of("key", "value"));
                }
                throw new NoSuchObjectException("Database does not exist");
            }

            @Override
            public List<String> getAllDatabases() {
                return ImmutableList.of((Object)"testDbName");
            }
        };
    }

    @Test
    public void testHttpThriftConnection() throws Exception {
        ThriftHttpMetastoreConfig config = new ThriftHttpMetastoreConfig();
        config.setAuthenticationMode(ThriftHttpMetastoreConfig.AuthenticationMode.BEARER);
        config.setAdditionalHeaders("key1:value1, key2:value2");
        try (TestingThriftHttpMetastoreServer metastoreServer = new TestingThriftHttpMetastoreServer(delegate, new TestRequestHeaderInterceptor());){
            HttpThriftMetastoreClientFactory factory = new HttpThriftMetastoreClientFactory(config, (NodeManager)new TestingNodeManager(), OpenTelemetry.noop());
            URI metastoreUri = URI.create("http://localhost:" + metastoreServer.getPort());
            ThriftMetastoreClient client = factory.create(metastoreUri, Optional.empty());
            Assertions.assertThat((List)client.getAllDatabases()).containsExactly((Object[])new String[]{"testDbName"});
            Assertions.assertThat((Comparable)client.getDatabase("testDbName")).isEqualTo((Object)new Database("testDbName", "testOwner", "testLocation", Map.of("key", "value")));
            Assertions.assertThatThrownBy(() -> client.getDatabase("does-not-exist")).isInstanceOf(NoSuchObjectException.class);
        }
    }

    private static class TestRequestHeaderInterceptor
    implements Consumer<HttpServletRequest> {
        private TestRequestHeaderInterceptor() {
        }

        @Override
        public void accept(HttpServletRequest httpServletRequest) {
            Assertions.assertThat(Collections.list(httpServletRequest.getHeaderNames())).contains((Object[])new String[]{"key1", "key2"});
            Assertions.assertThat((String)httpServletRequest.getHeader("key1")).isEqualTo("value1");
            Assertions.assertThat((String)httpServletRequest.getHeader("key2")).isEqualTo("value2");
            Assertions.assertThat((String)httpServletRequest.getHeader("Authorization")).isNull();
        }
    }
}

