/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.hive.metastore.thrift.ThriftHttpMetastoreConfig;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestThriftHttpMetastoreConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ThriftHttpMetastoreConfig)ConfigAssertions.recordDefaults(ThriftHttpMetastoreConfig.class)).setReadTimeout(new Duration(60.0, TimeUnit.SECONDS)).setHttpBearerToken(null).setAdditionalHeaders(null).setAuthenticationMode(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.metastore.http.client.bearer-token", (Object)"test-token").put((Object)"hive.metastore.http.client.additional-headers", (Object)"key\\:1:value\\,1, key\\,2:value\\:2").put((Object)"hive.metastore.http.client.authentication.type", (Object)"BEARER").put((Object)"hive.metastore.http.client.read-timeout", (Object)"1s").buildOrThrow();
        ThriftHttpMetastoreConfig expected = new ThriftHttpMetastoreConfig().setHttpBearerToken("test-token").setAdditionalHeaders("key\\:1:value\\,1, key\\,2:value\\:2").setReadTimeout(new Duration(1.0, TimeUnit.SECONDS)).setAuthenticationMode(ThriftHttpMetastoreConfig.AuthenticationMode.BEARER);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

