/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.trino.hive.thrift.metastore.BinaryColumnStatsData;
import io.trino.hive.thrift.metastore.BooleanColumnStatsData;
import io.trino.hive.thrift.metastore.ColumnStatisticsData;
import io.trino.hive.thrift.metastore.ColumnStatisticsObj;
import io.trino.hive.thrift.metastore.Date;
import io.trino.hive.thrift.metastore.DateColumnStatsData;
import io.trino.hive.thrift.metastore.DecimalColumnStatsData;
import io.trino.hive.thrift.metastore.DoubleColumnStatsData;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.LongColumnStatsData;
import io.trino.hive.thrift.metastore.Order;
import io.trino.hive.thrift.metastore.Partition;
import io.trino.hive.thrift.metastore.PrincipalPrivilegeSet;
import io.trino.hive.thrift.metastore.SerDeInfo;
import io.trino.hive.thrift.metastore.SkewedInfo;
import io.trino.hive.thrift.metastore.StorageDescriptor;
import io.trino.hive.thrift.metastore.StringColumnStatsData;
import io.trino.hive.thrift.metastore.Table;
import io.trino.metastore.BooleanStatistics;
import io.trino.metastore.DateStatistics;
import io.trino.metastore.DecimalStatistics;
import io.trino.metastore.DoubleStatistics;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.IntegerStatistics;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestThriftMetastoreUtil {
    private static final List<FieldSchema> TEST_SCHEMA = ImmutableList.of((Object)new FieldSchema("col1", "bigint", "comment1"), (Object)new FieldSchema("col2", "binary", null), (Object)new FieldSchema("col3", "string", null));
    private static final StorageDescriptor TEST_STORAGE_DESCRIPTOR = new StorageDescriptor(TEST_SCHEMA, "hdfs://VOL1:9000/db_name/table_name", "com.facebook.hive.orc.OrcInputFormat", "com.facebook.hive.orc.OrcOutputFormat", false, 100, new SerDeInfo("table_name", "com.facebook.hive.orc.OrcSerde", (Map)ImmutableMap.of((Object)"sdk1", (Object)"sdv1", (Object)"sdk2", (Object)"sdv2")), (List)ImmutableList.of((Object)"col2", (Object)"col3"), (List)ImmutableList.of((Object)new Order("col2", 1)), (Map)ImmutableMap.of());
    private static final Table TEST_TABLE = new Table("table_name", "db_name", "owner_name", 0, 0, 0, TEST_STORAGE_DESCRIPTOR, (List)ImmutableList.of((Object)new FieldSchema("pk1", "string", "comment pk1"), (Object)new FieldSchema("pk2", "string", null)), (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"), "view original text", "view extended text", "MANAGED_TABLE");
    private static final Partition TEST_PARTITION;
    private static final StorageDescriptor TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS;
    private static final Table TEST_TABLE_WITH_UNSUPPORTED_FIELDS;
    private static final Partition TEST_PARTITION_WITH_UNSUPPORTED_FIELDS;
    private static final StorageDescriptor TEST_STORAGE_DESCRIPTOR_WITH_MISSING_COLUMNS;
    private static final Partition TEST_PARTITION_WITH_MISSING_COLUMNS;
    private static final Map<String, String> TEST_TABLE_METADATA;

    @Test
    public void testTableRoundTrip() {
        io.trino.metastore.Table table = ThriftMetastoreUtil.fromMetastoreApiTable((Table)TEST_TABLE, TEST_SCHEMA);
        Table metastoreApiTable = ThriftMetastoreUtil.toMetastoreApiTable((io.trino.metastore.Table)table, (PrincipalPrivileges)PrincipalPrivileges.NO_PRIVILEGES);
        Assertions.assertThat((Comparable)metastoreApiTable).isEqualTo((Object)TEST_TABLE);
    }

    @Test
    public void testPartitionRoundTrip() {
        io.trino.metastore.Partition partition = ThriftMetastoreUtil.fromMetastoreApiPartition((Partition)TEST_PARTITION);
        Partition metastoreApiPartition = ThriftMetastoreUtil.toMetastoreApiPartition((io.trino.metastore.Partition)partition);
        Assertions.assertThat((Comparable)metastoreApiPartition).isEqualTo((Object)TEST_PARTITION);
    }

    @Test
    public void testHiveSchemaTable() {
        Map actual = MetastoreUtil.getHiveSchema((io.trino.metastore.Table)ThriftMetastoreUtil.fromMetastoreApiTable((Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS, TEST_SCHEMA));
        Assertions.assertThat((Map)actual).isEqualTo(TEST_TABLE_METADATA);
    }

    @Test
    public void testHiveSchemaPartition() {
        Map actual = MetastoreUtil.getHiveSchema((io.trino.metastore.Partition)ThriftMetastoreUtil.fromMetastoreApiPartition((Partition)TEST_PARTITION_WITH_UNSUPPORTED_FIELDS), (io.trino.metastore.Table)ThriftMetastoreUtil.fromMetastoreApiTable((Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS, TEST_SCHEMA));
        Assertions.assertThat((Map)actual).isEqualTo(TEST_TABLE_METADATA);
    }

    @Test
    public void testHiveSchemaCaseInsensitive() {
        List<FieldSchema> testSchema = TEST_SCHEMA.stream().map(fieldSchema -> new FieldSchema(fieldSchema.getName(), fieldSchema.getType().toUpperCase(Locale.ENGLISH), fieldSchema.getComment())).toList();
        Map actualTable = MetastoreUtil.getHiveSchema((io.trino.metastore.Table)ThriftMetastoreUtil.fromMetastoreApiTable((Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS, testSchema));
        Assertions.assertThat((Map)actualTable).isEqualTo(TEST_TABLE_METADATA);
        Map actualPartition = MetastoreUtil.getHiveSchema((io.trino.metastore.Partition)ThriftMetastoreUtil.fromMetastoreApiPartition((Partition)TEST_PARTITION_WITH_UNSUPPORTED_FIELDS), (io.trino.metastore.Table)ThriftMetastoreUtil.fromMetastoreApiTable((Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS, testSchema));
        Assertions.assertThat((Map)actualPartition).isEqualTo(TEST_TABLE_METADATA);
    }

    @Test
    public void testHiveSchemaPartitionWithMissingColumns() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> ThriftMetastoreUtil.fromMetastoreApiPartition((Partition)TEST_PARTITION_WITH_MISSING_COLUMNS)).hasErrorCode(new ErrorCodeSupplier[]{HiveErrorCode.HIVE_INVALID_METADATA}).hasMessageContaining("Partition storage descriptor does not contain columns to derive a schema");
    }

    @Test
    public void testLongStatsToColumnStatistics() {
        LongColumnStatsData longColumnStatsData = new LongColumnStatsData();
        longColumnStatsData.setLowValue(0L);
        longColumnStatsData.setHighValue(100L);
        longColumnStatsData.setNumNulls(1L);
        longColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "bigint", ColumnStatisticsData.longStats((LongColumnStatsData)longColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(0L), OptionalLong.of(100L))).setNullsCount(1L).setDistinctValuesWithNullCount(20L).build());
    }

    @Test
    public void testEmptyLongStatsToColumnStatistics() {
        LongColumnStatsData emptyLongColumnStatsData = new LongColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "bigint", ColumnStatisticsData.longStats((LongColumnStatsData)emptyLongColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
    }

    @Test
    public void testDoubleStatsToColumnStatistics() {
        DoubleColumnStatsData doubleColumnStatsData = new DoubleColumnStatsData();
        doubleColumnStatsData.setLowValue(0.0);
        doubleColumnStatsData.setHighValue(100.0);
        doubleColumnStatsData.setNumNulls(1L);
        doubleColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)doubleColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(0.0), OptionalDouble.of(100.0))).setNullsCount(1L).setDistinctValuesWithNullCount(20L).build());
    }

    @Test
    public void testEmptyDoubleStatsToColumnStatistics() {
        DoubleColumnStatsData emptyDoubleColumnStatsData = new DoubleColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)emptyDoubleColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())).build());
    }

    @Test
    public void testDecimalStatsToColumnStatistics() {
        DecimalColumnStatsData decimalColumnStatsData = new DecimalColumnStatsData();
        BigDecimal low = new BigDecimal("0");
        decimalColumnStatsData.setLowValue(ThriftMetastoreUtil.toMetastoreDecimal((BigDecimal)low));
        BigDecimal high = new BigDecimal("100");
        decimalColumnStatsData.setHighValue(ThriftMetastoreUtil.toMetastoreDecimal((BigDecimal)high));
        decimalColumnStatsData.setNumNulls(1L);
        decimalColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "decimal", ColumnStatisticsData.decimalStats((DecimalColumnStatsData)decimalColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(low), Optional.of(high))).setNullsCount(1L).setDistinctValuesWithNullCount(20L).build());
    }

    @Test
    public void testEmptyDecimalStatsToColumnStatistics() {
        DecimalColumnStatsData emptyDecimalColumnStatsData = new DecimalColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "decimal", ColumnStatisticsData.decimalStats((DecimalColumnStatsData)emptyDecimalColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty())).build());
    }

    @Test
    public void testBooleanStatsToColumnStatistics() {
        BooleanColumnStatsData booleanColumnStatsData = new BooleanColumnStatsData();
        booleanColumnStatsData.setNumTrues(100L);
        booleanColumnStatsData.setNumFalses(10L);
        booleanColumnStatsData.setNumNulls(0L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "boolean", ColumnStatisticsData.booleanStats((BooleanColumnStatsData)booleanColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.of(100L), OptionalLong.of(10L))).setNullsCount(0L).build());
    }

    @Test
    public void testImpalaGeneratedBooleanStatistics() {
        BooleanColumnStatsData statsData = new BooleanColumnStatsData(1L, -1L, 2L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "boolean", ColumnStatisticsData.booleanStats((BooleanColumnStatsData)statsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).setNullsCount(2L).build());
    }

    @Test
    public void testEmptyBooleanStatsToColumnStatistics() {
        BooleanColumnStatsData emptyBooleanColumnStatsData = new BooleanColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "boolean", ColumnStatisticsData.booleanStats((BooleanColumnStatsData)emptyBooleanColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
    }

    @Test
    public void testDateStatsToColumnStatistics() {
        DateColumnStatsData dateColumnStatsData = new DateColumnStatsData();
        dateColumnStatsData.setLowValue(new Date(1000L));
        dateColumnStatsData.setHighValue(new Date(2000L));
        dateColumnStatsData.setNumNulls(1L);
        dateColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "date", ColumnStatisticsData.dateStats((DateColumnStatsData)dateColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.ofEpochDay(1000L)), Optional.of(LocalDate.ofEpochDay(2000L)))).setNullsCount(1L).setDistinctValuesWithNullCount(20L).build());
    }

    @Test
    public void testEmptyDateStatsToColumnStatistics() {
        DateColumnStatsData emptyDateColumnStatsData = new DateColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "date", ColumnStatisticsData.dateStats((DateColumnStatsData)emptyDateColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty())).build());
    }

    @Test
    public void testStringStatsToColumnStatistics() {
        StringColumnStatsData stringColumnStatsData = new StringColumnStatsData();
        stringColumnStatsData.setMaxColLen(100L);
        stringColumnStatsData.setAvgColLen(23.333);
        stringColumnStatsData.setNumNulls(1L);
        stringColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "string", ColumnStatisticsData.stringStats((StringColumnStatsData)stringColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setMaxValueSizeInBytes(100L).setAverageColumnLength(23.333).setNullsCount(1L).setDistinctValuesWithNullCount(20L).build());
    }

    @Test
    public void testEmptyStringColumnStatsData() {
        StringColumnStatsData emptyStringColumnStatsData = new StringColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "string", ColumnStatisticsData.stringStats((StringColumnStatsData)emptyStringColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().build());
    }

    @Test
    public void testBinaryStatsToColumnStatistics() {
        BinaryColumnStatsData binaryColumnStatsData = new BinaryColumnStatsData();
        binaryColumnStatsData.setMaxColLen(100L);
        binaryColumnStatsData.setAvgColLen(22.2);
        binaryColumnStatsData.setNumNulls(2L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "binary", ColumnStatisticsData.binaryStats((BinaryColumnStatsData)binaryColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().setMaxValueSizeInBytes(100L).setAverageColumnLength(22.2).setNullsCount(2L).build());
    }

    @Test
    public void testEmptyBinaryStatsToColumnStatistics() {
        BinaryColumnStatsData emptyBinaryColumnStatsData = new BinaryColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "binary", ColumnStatisticsData.binaryStats((BinaryColumnStatsData)emptyBinaryColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((Object)actual).isEqualTo((Object)HiveColumnStatistics.builder().build());
    }

    @Test
    public void testSingleDistinctValue() {
        DoubleColumnStatsData doubleColumnStatsData = new DoubleColumnStatsData();
        doubleColumnStatsData.setNumNulls(10L);
        doubleColumnStatsData.setNumDVs(1L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)doubleColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((OptionalLong)actual.getNullsCount()).isEqualTo((Object)OptionalLong.of(10L));
        Assertions.assertThat((OptionalLong)actual.getDistinctValuesWithNullCount()).isEqualTo((Object)OptionalLong.of(1L));
        doubleColumnStatsData = new DoubleColumnStatsData();
        doubleColumnStatsData.setNumNulls(10L);
        doubleColumnStatsData.setNumDVs(1L);
        columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)doubleColumnStatsData));
        actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assertions.assertThat((OptionalLong)actual.getNullsCount()).isEqualTo((Object)OptionalLong.of(10L));
        Assertions.assertThat((OptionalLong)actual.getDistinctValuesWithNullCount()).isEqualTo((Object)OptionalLong.of(1L));
    }

    @Test
    public void testListApplicableRoles() {
        TrinoPrincipal admin = new TrinoPrincipal(PrincipalType.USER, "admin");
        ImmutableMultimap inheritance = ImmutableMultimap.builder().put((Object)"a", (Object)"b1").put((Object)"a", (Object)"b2").put((Object)"b1", (Object)"d").put((Object)"b1", (Object)"e").put((Object)"b2", (Object)"d").put((Object)"b2", (Object)"e").put((Object)"d", (Object)"u").put((Object)"e", (Object)"w").build();
        Assertions.assertThat((Stream)ThriftMetastoreUtil.listApplicableRoles((HivePrincipal)new HivePrincipal(PrincipalType.ROLE, "a"), arg_0 -> TestThriftMetastoreUtil.lambda$testListApplicableRoles$3((Multimap)inheritance, admin, arg_0))).containsOnly((Object[])new RoleGrant[]{new RoleGrant(admin, "b1", false), new RoleGrant(admin, "b2", false), new RoleGrant(admin, "d", false), new RoleGrant(admin, "e", false), new RoleGrant(admin, "u", false), new RoleGrant(admin, "w", false)});
    }

    private static /* synthetic */ Set lambda$testListApplicableRoles$3(Multimap inheritance, TrinoPrincipal admin, HivePrincipal principal) {
        return (Set)inheritance.get((Object)principal.getName()).stream().map(name -> new RoleGrant(admin, name, false)).collect(ImmutableSet.toImmutableSet());
    }

    static {
        TEST_TABLE.setPrivileges(new PrincipalPrivilegeSet((Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
        TEST_PARTITION = new Partition((List)ImmutableList.of((Object)"pk1v", (Object)"pk2v"), "db_name", "table_name", 0, 0, TEST_STORAGE_DESCRIPTOR, (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"));
        TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS = new StorageDescriptor(TEST_SCHEMA, "hdfs://VOL1:9000/db_name/table_name", "com.facebook.hive.orc.OrcInputFormat", "com.facebook.hive.orc.OrcOutputFormat", false, 100, new SerDeInfo("table_name", "com.facebook.hive.orc.OrcSerde", (Map)ImmutableMap.of((Object)"sdk1", (Object)"sdv1", (Object)"sdk2", (Object)"sdv2")), (List)ImmutableList.of((Object)"col2", (Object)"col3"), (List)ImmutableList.of((Object)new Order("col2", 0), (Object)new Order("col3", 1)), (Map)ImmutableMap.of((Object)"sk1", (Object)"sv1"));
        TEST_TABLE_WITH_UNSUPPORTED_FIELDS = new Table("table_name", "db_name", "owner_name", 1234567890, 1234567891, 34, TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS, (List)ImmutableList.of((Object)new FieldSchema("pk1", "string", "comment pk1"), (Object)new FieldSchema("pk2", "string", null)), (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"), "view original text", "view extended text", "MANAGED_TABLE");
        TEST_PARTITION_WITH_UNSUPPORTED_FIELDS = new Partition((List)ImmutableList.of((Object)"pk1v", (Object)"pk2v"), "db_name", "table_name", 1234567892, 1234567893, TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS, (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"));
        TEST_STORAGE_DESCRIPTOR_WITH_MISSING_COLUMNS = new StorageDescriptor(null, "hdfs://VOL1:9000/db_name/table_name", "com.facebook.hive.orc.OrcInputFormat", "com.facebook.hive.orc.OrcOutputFormat", false, 100, new SerDeInfo("table_name", "com.facebook.hive.orc.OrcSerde", (Map)ImmutableMap.of((Object)"sdk1", (Object)"sdv1", (Object)"sdk2", (Object)"sdv2")), null, null, (Map)ImmutableMap.of());
        TEST_PARTITION_WITH_MISSING_COLUMNS = new Partition((List)ImmutableList.of((Object)"pk1v", (Object)"pk2v"), "db_name", "table_name", 1234567892, 1234567893, TEST_STORAGE_DESCRIPTOR_WITH_MISSING_COLUMNS, (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"));
        TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS.setSkewedInfo(new SkewedInfo((List)ImmutableList.of((Object)"col1"), (List)ImmutableList.of((Object)ImmutableList.of((Object)"val1")), (Map)ImmutableMap.of((Object)ImmutableList.of((Object)"val1"), (Object)"loc1")));
        TEST_TABLE_METADATA = ImmutableMap.builder().put((Object)"bucket_count", (Object)"100").put((Object)"bucket_field_name", (Object)"col2,col3").put((Object)"columns", (Object)"col1,col2,col3").put((Object)"columns.comments", (Object)"comment1\u0000\u0000").put((Object)"columns.types", (Object)"bigint:binary:string").put((Object)"file.inputformat", (Object)"com.facebook.hive.orc.OrcInputFormat").put((Object)"file.outputformat", (Object)"com.facebook.hive.orc.OrcOutputFormat").put((Object)"k1", (Object)"v1").put((Object)"k2", (Object)"v2").put((Object)"k3", (Object)"v3").put((Object)"location", (Object)"hdfs://VOL1:9000/db_name/table_name").put((Object)"name", (Object)"db_name.table_name").put((Object)"partition_columns", (Object)"pk1/pk2").put((Object)"partition_columns.types", (Object)"string:string").put((Object)"sdk1", (Object)"sdv1").put((Object)"sdk2", (Object)"sdv2").put((Object)"serialization.lib", (Object)"com.facebook.hive.orc.OrcSerde").buildOrThrow();
    }
}

