/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.opentelemetry.api.OpenTelemetry;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.TableInfo;
import io.trino.plugin.base.util.AutoCloseableCloser;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.HttpThriftMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftHttpMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.SchemaTableName;
import io.trino.testing.TestingNodeManager;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class TestUnityMetastore {
    TestUnityMetastore() {
    }

    @Test
    void test() throws Exception {
        String databricksHost = Objects.requireNonNull(System.getenv("DATABRICKS_HOST"), "Environment variable not set: DATABRICKS_HOST");
        String databricksToken = Objects.requireNonNull(System.getenv("DATABRICKS_TOKEN"), "Environment variable not set: DATABRICKS_TOKEN");
        String databricksCatalogName = Objects.requireNonNull(System.getenv("DATABRICKS_UNITY_CATALOG_NAME"), "Environment variable not set: DATABRICKS_UNITY_CATALOG_NAME");
        URI metastoreUri = URI.create("https://%s:443/api/2.0/unity-hms-proxy/metadata".formatted(databricksHost));
        ThriftHttpMetastoreConfig config = new ThriftHttpMetastoreConfig().setAuthenticationMode(ThriftHttpMetastoreConfig.AuthenticationMode.BEARER).setHttpBearerToken(databricksToken).setAdditionalHeaders("X-Databricks-Catalog-Name:" + databricksCatalogName);
        ThriftMetastoreClient client = new HttpThriftMetastoreClientFactory(config, (NodeManager)new TestingNodeManager(), OpenTelemetry.noop()).create(metastoreUri, Optional.empty());
        try (AutoCloseableCloser closer = AutoCloseableCloser.create();){
            BridgingHiveMetastore metastore = new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(client).thriftMetastoreConfig(new ThriftMetastoreConfig().setDeleteFilesOnDrop(true)).build(arg_0 -> ((AutoCloseableCloser)closer).register(arg_0)));
            List tables = metastore.getAllDatabases().stream().map(arg_0 -> ((HiveMetastore)metastore).getTables(arg_0)).flatMap(Collection::stream).toList();
            Assertions.assertThat(tables).isNotEmpty();
            SchemaTableName schemaTableName = ((TableInfo)tables.getFirst()).tableName();
            Assertions.assertThat((Optional)metastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName())).isPresent();
        }
    }
}

