/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.reflect.Reflection;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.node.testing.TestingNodeModule;
import io.trino.hive.thrift.metastore.Database;
import io.trino.hive.thrift.metastore.NoSuchObjectException;
import io.trino.hive.thrift.metastore.ThriftHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServlet;

public class TestingThriftHttpMetastoreServer
implements Closeable {
    private final TestingThriftHttpServlet thriftHttpServlet;
    private final LifeCycleManager lifeCycleManager;
    private final URI baseUri;

    public TestingThriftHttpMetastoreServer(ThriftMetastore delegate, Consumer<HttpServletRequest> requestInterceptor) {
        ThriftHiveMetastore.Iface mockThriftHandler = TestingThriftHttpMetastoreServer.proxyHandler(delegate, ThriftHiveMetastore.Iface.class);
        ThriftHiveMetastore.Processor processor = new ThriftHiveMetastore.Processor(mockThriftHandler);
        this.thriftHttpServlet = new TestingThriftHttpServlet((TProcessor)processor, (TProtocolFactory)new TBinaryProtocol.Factory(), requestInterceptor);
        Bootstrap app = new Bootstrap(new Module[]{new TestingNodeModule(), new TestingHttpServerModule(), binder -> binder.bind(Servlet.class).toInstance((Object)this.thriftHttpServlet)});
        Injector injector = app.doNotInitializeLogging().initialize();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        HttpServerInfo httpServerInfo = (HttpServerInfo)injector.getInstance(HttpServerInfo.class);
        this.baseUri = httpServerInfo.getHttpUri();
    }

    private static <T> T proxyHandler(ThriftMetastore delegate, Class<T> iface) {
        return (T)Reflection.newProxy(iface, (proxy, method, args) -> switch (method.getName()) {
            case "getAllDatabases" -> delegate.getAllDatabases();
            case "getDatabase" -> {
                Optional optionalDatabase = delegate.getDatabase(args[0].toString());
                yield (Database)optionalDatabase.orElseThrow(() -> new NoSuchObjectException(""));
            }
            default -> throw new UnsupportedOperationException();
        });
    }

    public int getPort() {
        return this.baseUri.getPort();
    }

    @Override
    public void close() throws IOException {
        this.lifeCycleManager.stop();
    }

    private static class TestingThriftHttpServlet
    extends TServlet {
        private final Consumer<HttpServletRequest> requestInterceptor;

        public TestingThriftHttpServlet(TProcessor processor, TProtocolFactory protocolFactory, Consumer<HttpServletRequest> requestInterceptor) {
            super(processor, protocolFactory);
            this.requestInterceptor = requestInterceptor;
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.requestInterceptor.accept(request);
            super.doPost(request, response);
        }
    }
}

