/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.TestTable;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Test;

public class TestHiveOrcWithShortZoneId
extends AbstractTestQueryFramework {
    private Location dataFile;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = HiveQueryRunner.builder().addHiveProperty("hive.orc.read-legacy-short-zone-id", "true").build();
        URL resourceLocation = Resources.getResource((String)"with_short_zone_id/data/data.orc");
        TrinoFileSystem fileSystem = TestingHiveUtils.getConnectorService((QueryRunner)queryRunner, TrinoFileSystemFactory.class).create(ConnectorIdentity.ofUser((String)"test"));
        Location tempDir = Location.of((String)("local:///temp_" + String.valueOf(UUID.randomUUID())));
        fileSystem.createDirectory(tempDir);
        this.dataFile = tempDir.appendPath("data.orc");
        try (OutputStream out = fileSystem.newOutputFile(this.dataFile).create();){
            Resources.copy((URL)resourceLocation, (OutputStream)out);
        }
        return queryRunner;
    }

    @Test
    public void testSelectWithShortZoneId() {
        try (TestTable testTable = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_select_with_short_zone_id_", "(id INT, firstName VARCHAR, lastName VARCHAR) WITH (external_location = '%s')".formatted(this.dataFile.parentDirectory()));){
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES (1, 'John', 'Doe')");
        }
    }

    @Test
    public void testSelectWithoutShortZoneId() {
        try (TestTable testTable = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_select_without_short_zone_id_", "(id INT, firstName VARCHAR, lastName VARCHAR)", (List)ImmutableList.of((Object)"2, 'Alice', 'Doe'"));){
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES (2, 'Alice', 'Doe')");
        }
    }
}

