/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.memory.MemoryFileSystemFactory;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.Schema;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.tpch.Nation;
import io.trino.tpch.NationColumn;
import io.trino.tpch.NationGenerator;
import io.trino.tpch.TpchColumnType;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.LongPredicate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOrcPageSourceFactory {
    private static final Map<NationColumn, Integer> ALL_COLUMNS = ImmutableMap.of((Object)NationColumn.NATION_KEY, (Object)0, (Object)NationColumn.NAME, (Object)1, (Object)NationColumn.REGION_KEY, (Object)2, (Object)NationColumn.COMMENT, (Object)3);

    @Test
    public void testFullFileRead() throws IOException {
        TestOrcPageSourceFactory.assertRead((Map<NationColumn, Integer>)ImmutableMap.of((Object)NationColumn.NATION_KEY, (Object)0, (Object)NationColumn.NAME, (Object)1, (Object)NationColumn.REGION_KEY, (Object)2, (Object)NationColumn.COMMENT, (Object)3), OptionalLong.empty(), Optional.empty(), nationKey -> false);
    }

    @Test
    public void testSingleColumnRead() throws IOException {
        TestOrcPageSourceFactory.assertRead((Map<NationColumn, Integer>)ImmutableMap.of((Object)NationColumn.REGION_KEY, (Object)ALL_COLUMNS.get(NationColumn.REGION_KEY)), OptionalLong.empty(), Optional.empty(), nationKey -> false);
    }

    @Test
    public void testFullFileSkipped() throws IOException {
        TestOrcPageSourceFactory.assertRead(ALL_COLUMNS, OptionalLong.of(100L), Optional.empty(), nationKey -> false);
    }

    @Test
    public void testSomeStripesAndRowGroupRead() throws IOException {
        TestOrcPageSourceFactory.assertRead(ALL_COLUMNS, OptionalLong.of(5L), Optional.empty(), nationKey -> false);
    }

    @Test
    public void testDeletedRows() throws IOException {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        Location fileLocation = TestOrcPageSourceFactory.copyResource((TrinoFileSystemFactory)fileSystemFactory, "nationFile25kRowsSortedOnNationKey/bucket_00000");
        long fileLength = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test")).newInputFile(fileLocation).length();
        Location deleteFile3 = TestOrcPageSourceFactory.copyResource((TrinoFileSystemFactory)fileSystemFactory, "nation_delete_deltas/delete_delta_0000003_0000003_0000/bucket_00000");
        Location deleteFile4 = TestOrcPageSourceFactory.copyResource((TrinoFileSystemFactory)fileSystemFactory, "nation_delete_deltas/delete_delta_0000004_0000004_0000/bucket_00000");
        Optional acidInfo = AcidInfo.builder((Location)deleteFile3.parentDirectory().parentDirectory()).addDeleteDelta(deleteFile3.parentDirectory()).addDeleteDelta(deleteFile4.parentDirectory()).build();
        List<Nation> actual = TestOrcPageSourceFactory.readFile((TrinoFileSystemFactory)fileSystemFactory, ALL_COLUMNS, OptionalLong.empty(), acidInfo, fileLocation, fileLength);
        List<Nation> expected = TestOrcPageSourceFactory.expectedResult(OptionalLong.empty(), nationKey -> nationKey == 5L || nationKey == 19L, 1000);
        TestOrcPageSourceFactory.assertEqualsByColumns(ALL_COLUMNS.keySet(), actual, expected);
    }

    @Test
    public void testReadWithAcidVersionValidationHive3() throws Exception {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        Location fileLocation = TestOrcPageSourceFactory.copyResource((TrinoFileSystemFactory)fileSystemFactory, "acid_version_validation/acid_version_hive_3/00000_0");
        Optional acidInfo = AcidInfo.builder((Location)fileLocation.parentDirectory()).setOrcAcidVersionValidated(false).build();
        List<Nation> result = TestOrcPageSourceFactory.readFile((TrinoFileSystemFactory)fileSystemFactory, Map.of(), OptionalLong.empty(), acidInfo, fileLocation, 625L);
        Assertions.assertThat(result).hasSize(1);
    }

    @Test
    public void testReadWithAcidVersionValidationNoVersionInMetadata() throws Exception {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        Location fileLocation = TestOrcPageSourceFactory.copyResource((TrinoFileSystemFactory)fileSystemFactory, "acid_version_validation/no_orc_acid_version_in_metadata/00000_0");
        Optional acidInfo = AcidInfo.builder((Location)fileLocation.parentDirectory()).setOrcAcidVersionValidated(false).build();
        Assertions.assertThatThrownBy(() -> TestOrcPageSourceFactory.lambda$testReadWithAcidVersionValidationNoVersionInMetadata$5((TrinoFileSystemFactory)fileSystemFactory, acidInfo, fileLocation)).hasMessageMatching("Hive transactional tables are supported since Hive 3.0. Expected `hive.acid.version` in ORC metadata in .*/acid_version_validation/no_orc_acid_version_in_metadata/00000_0 to be >=2 but was <empty>. If you have upgraded from an older version of Hive, make sure a major compaction has been run at least once after the upgrade.");
    }

    @Test
    public void testFullFileReadOriginalFilesTable() throws Exception {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        Location fileLocation = TestOrcPageSourceFactory.copyResource((TrinoFileSystemFactory)fileSystemFactory, "fullacidNationTableWithOriginalFiles/000000_0");
        Location deleteDeltaLocation = TestOrcPageSourceFactory.copyResource((TrinoFileSystemFactory)fileSystemFactory, "fullacidNationTableWithOriginalFiles/delete_delta_10000001_10000001_0000/bucket_00000");
        Location tablePath = fileLocation.parentDirectory();
        AcidInfo acidInfo = AcidInfo.builder((Location)tablePath).addDeleteDelta(deleteDeltaLocation.parentDirectory()).addOriginalFile(fileLocation, 1780L, 0).setOrcAcidVersionValidated(true).buildWithRequiredOriginalFiles(0);
        List<Nation> expected = TestOrcPageSourceFactory.expectedResult(OptionalLong.empty(), nationKey -> nationKey == 24L, 1);
        List<Nation> result = TestOrcPageSourceFactory.readFile((TrinoFileSystemFactory)fileSystemFactory, ALL_COLUMNS, OptionalLong.empty(), Optional.of(acidInfo), fileLocation, 1780L);
        Assertions.assertThat(result).hasSize(expected.size());
        int deletedRowKey = 24;
        String deletedRowNameColumn = "UNITED STATES";
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.stream().anyMatch(acidNationRow -> acidNationRow.name().equals(deletedRowNameColumn) && acidNationRow.nationKey() == (long)deletedRowKey)).describedAs("Deleted row shouldn't be present in the result", new Object[0])).isFalse();
    }

    private static void assertRead(Map<NationColumn, Integer> columns, OptionalLong nationKeyPredicate, Optional<AcidInfo> acidInfo, LongPredicate deletedRows) throws IOException {
        List<Nation> actual = TestOrcPageSourceFactory.readFile(columns, nationKeyPredicate, acidInfo);
        List<Nation> expected = TestOrcPageSourceFactory.expectedResult(nationKeyPredicate, deletedRows, 1000);
        TestOrcPageSourceFactory.assertEqualsByColumns(columns.keySet(), actual, expected);
    }

    private static List<Nation> expectedResult(OptionalLong nationKeyPredicate, LongPredicate deletedRows, int replicationFactor) {
        ArrayList<Nation> expected = new ArrayList<Nation>();
        for (Nation nation : ImmutableList.copyOf((Iterator)new NationGenerator().iterator())) {
            if (nationKeyPredicate.isPresent() && nationKeyPredicate.getAsLong() != nation.nationKey() || deletedRows.test(nation.nationKey())) continue;
            expected.addAll(Collections.nCopies(replicationFactor, nation));
        }
        return expected;
    }

    private static List<Nation> readFile(Map<NationColumn, Integer> columns, OptionalLong nationKeyPredicate, Optional<AcidInfo> acidInfo) throws IOException {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        Location fileLocation = TestOrcPageSourceFactory.copyResource((TrinoFileSystemFactory)fileSystemFactory, "nationFile25kRowsSortedOnNationKey/bucket_00000");
        long fileLength = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test")).newInputFile(fileLocation).length();
        return TestOrcPageSourceFactory.readFile((TrinoFileSystemFactory)fileSystemFactory, columns, nationKeyPredicate, acidInfo, fileLocation, fileLength);
    }

    private static List<Nation> readFile(TrinoFileSystemFactory fileSystemFactory, Map<NationColumn, Integer> columns, OptionalLong nationKeyPredicate, Optional<AcidInfo> acidInfo, Location location, long fileSize) {
        TupleDomain tupleDomain = TupleDomain.all();
        if (nationKeyPredicate.isPresent()) {
            tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)TestOrcPageSourceFactory.toHiveColumnHandle(NationColumn.NATION_KEY, 0), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)nationKeyPredicate.getAsLong())));
        }
        List columnHandles = (List)columns.entrySet().stream().map(entry -> TestOrcPageSourceFactory.toHiveColumnHandle((NationColumn)entry.getKey(), (Integer)entry.getValue())).collect(ImmutableList.toImmutableList());
        List columnNames = (List)columnHandles.stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
        OrcPageSourceFactory pageSourceFactory = new OrcPageSourceFactory(new OrcReaderConfig(), fileSystemFactory, new FileFormatDataSourceStats(), new HiveConfig());
        Optional pageSourceWithProjections = pageSourceFactory.createPageSource(HiveTestUtils.SESSION, location, 0L, fileSize, fileSize, 12345L, TestOrcPageSourceFactory.createSchema(), columnHandles, tupleDomain, acidInfo, OptionalInt.empty(), false, AcidTransaction.NO_ACID_TRANSACTION);
        Preconditions.checkArgument((boolean)pageSourceWithProjections.isPresent());
        Preconditions.checkArgument((boolean)((ReaderPageSource)pageSourceWithProjections.get()).getReaderColumns().isEmpty(), (Object)"projected columns not expected here");
        ConnectorPageSource pageSource = ((ReaderPageSource)pageSourceWithProjections.get()).get();
        int nationKeyColumn = columnNames.indexOf("n_nationkey");
        int nameColumn = columnNames.indexOf("n_name");
        int regionKeyColumn = columnNames.indexOf("n_regionkey");
        int commentColumn = columnNames.indexOf("n_comment");
        ImmutableList.Builder rows = ImmutableList.builder();
        while (!pageSource.isFinished()) {
            Page page = pageSource.getNextPage();
            if (page == null) continue;
            page = page.getLoadedPage();
            for (int position = 0; position < page.getPositionCount(); ++position) {
                long nationKey = -42L;
                if (nationKeyColumn >= 0) {
                    nationKey = BigintType.BIGINT.getLong(page.getBlock(nationKeyColumn), position);
                }
                String name = "<not read>";
                if (nameColumn >= 0) {
                    name = VarcharType.VARCHAR.getSlice(page.getBlock(nameColumn), position).toStringUtf8();
                }
                long regionKey = -42L;
                if (regionKeyColumn >= 0) {
                    regionKey = BigintType.BIGINT.getLong(page.getBlock(regionKeyColumn), position);
                }
                String comment = "<not read>";
                if (commentColumn >= 0) {
                    comment = VarcharType.VARCHAR.getSlice(page.getBlock(commentColumn), position).toStringUtf8();
                }
                rows.add((Object)new Nation((long)position, nationKey, name, regionKey, comment));
            }
        }
        return rows.build();
    }

    private static HiveColumnHandle toHiveColumnHandle(NationColumn nationColumn, int hiveColumnIndex) {
        BigintType trinoType = switch (nationColumn.getType().getBase()) {
            case TpchColumnType.Base.IDENTIFIER -> BigintType.BIGINT;
            case TpchColumnType.Base.VARCHAR -> VarcharType.VARCHAR;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(nationColumn.getType().getBase()));
        };
        return HiveColumnHandle.createBaseColumn((String)nationColumn.getColumnName(), (int)hiveColumnIndex, (HiveType)HiveTypeTranslator.toHiveType((Type)trinoType), (Type)trinoType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
    }

    private static Schema createSchema() {
        return new Schema(HiveStorageFormat.ORC.getSerde(), true, (Map)ImmutableMap.of());
    }

    private static void assertEqualsByColumns(Set<NationColumn> columns, List<Nation> actualRows, List<Nation> expectedRows) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualRows.size()).describedAs("row count", new Object[0])).isEqualTo(expectedRows.size());
        for (int i = 0; i < actualRows.size(); ++i) {
            Nation actual = actualRows.get(i);
            Nation expected = expectedRows.get(i);
            Assertions.assertThat((long)actual.nationKey()).isEqualTo(columns.contains(NationColumn.NATION_KEY) ? expected.nationKey() : -42L);
            Assertions.assertThat((String)actual.name()).isEqualTo(columns.contains(NationColumn.NAME) ? expected.name() : "<not read>");
            Assertions.assertThat((long)actual.regionKey()).isEqualTo(columns.contains(NationColumn.REGION_KEY) ? expected.regionKey() : -42L);
            Assertions.assertThat((String)actual.comment()).isEqualTo(columns.contains(NationColumn.COMMENT) ? expected.comment() : "<not read>");
        }
    }

    private static Location copyResource(TrinoFileSystemFactory fileSystemFactory, String resourceName) throws IOException {
        Location location = Location.of((String)("memory:///" + resourceName));
        TrinoFileSystem fileSystem = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test"));
        try (OutputStream outputStream = fileSystem.newOutputFile(location).create();){
            Resources.copy((URL)Resources.getResource((String)resourceName), (OutputStream)outputStream);
        }
        return location;
    }

    private static /* synthetic */ void lambda$testReadWithAcidVersionValidationNoVersionInMetadata$5(TrinoFileSystemFactory fileSystemFactory, Optional acidInfo, Location fileLocation) throws Throwable {
        TestOrcPageSourceFactory.readFile(fileSystemFactory, Map.of(), OptionalLong.empty(), acidInfo, fileLocation, 730L);
    }
}

