/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.memory.MemoryFileSystemFactory;
import io.trino.metastore.HiveType;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcWriterOptions;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.Schema;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.type.InternalTypeManager;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.Test;

class TestOrcPredicates {
    private static final int NUM_ROWS = 50000;
    private static final FileFormatDataSourceStats STATS = new FileFormatDataSourceStats();
    private static final HiveColumnHandle INTEGER_COLUMN = HiveColumnHandle.createBaseColumn((String)"column_primitive_integer", (int)0, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
    private static final HiveColumnHandle STRUCT_COLUMN = HiveColumnHandle.createBaseColumn((String)"column1_struct", (int)1, (HiveType)HiveTypeTranslator.toHiveType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"field0", (Type)BigintType.BIGINT), RowType.field((String)"field1", (Type)BigintType.BIGINT)})), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"field0", (Type)BigintType.BIGINT), RowType.field((String)"field1", (Type)BigintType.BIGINT)}), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
    private static final HiveColumnHandle BIGINT_COLUMN = HiveColumnHandle.createBaseColumn((String)"column_primitive_bigint", (int)2, (HiveType)HiveType.HIVE_LONG, (Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
    private static final List<HiveColumnHandle> COLUMNS = ImmutableList.of((Object)INTEGER_COLUMN, (Object)STRUCT_COLUMN, (Object)BIGINT_COLUMN);
    private static final HiveColumnHandle STRUCT_FIELD1_COLUMN = new HiveColumnHandle(STRUCT_COLUMN.getBaseColumnName(), STRUCT_COLUMN.getBaseHiveColumnIndex(), STRUCT_COLUMN.getBaseHiveType(), STRUCT_COLUMN.getBaseType(), Optional.of(new HiveColumnProjectionInfo((List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)"field1"), HiveType.HIVE_LONG, (Type)BigintType.BIGINT)), STRUCT_COLUMN.getColumnType(), STRUCT_COLUMN.getComment());
    private static final List<HiveColumnHandle> PROJECTED_COLUMNS = ImmutableList.of((Object)BIGINT_COLUMN, (Object)STRUCT_FIELD1_COLUMN);

    TestOrcPredicates() {
    }

    @Test
    void testOrcPredicates() throws Exception {
        TestOrcPredicates.testOrcPredicates((ConnectorSession)HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setUseColumnNames(true)));
        TestOrcPredicates.testOrcPredicates((ConnectorSession)HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig()));
    }

    private static void testOrcPredicates(ConnectorSession session) throws Exception {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        Location location = Location.of((String)"memory:///test");
        TestOrcPredicates.writeTestFile(session, (TrinoFileSystemFactory)fileSystemFactory, location);
        TestOrcPredicates.assertFilteredRows((TrinoFileSystemFactory)fileSystemFactory, location, (TupleDomain<HiveColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)BIGINT_COLUMN, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)6L))), COLUMNS, session, 50000);
        TestOrcPredicates.assertFilteredRows((TrinoFileSystemFactory)fileSystemFactory, location, (TupleDomain<HiveColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)BIGINT_COLUMN, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), COLUMNS, session, 0);
        TestOrcPredicates.assertFilteredRows((TrinoFileSystemFactory)fileSystemFactory, location, (TupleDomain<HiveColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)STRUCT_FIELD1_COLUMN, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L))), PROJECTED_COLUMNS, session, 50000);
        TestOrcPredicates.assertFilteredRows((TrinoFileSystemFactory)fileSystemFactory, location, (TupleDomain<HiveColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)STRUCT_FIELD1_COLUMN, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)6L))), PROJECTED_COLUMNS, session, 0);
    }

    private static void assertFilteredRows(TrinoFileSystemFactory fileSystemFactory, Location location, TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> columnsToRead, ConnectorSession session, int expectedRows) throws IOException {
        try (ConnectorPageSource pageSource = TestOrcPredicates.createPageSource(fileSystemFactory, location, effectivePredicate, columnsToRead, session);){
            int filteredRows = 0;
            while (!pageSource.isFinished()) {
                Page page = pageSource.getNextPage();
                if (page == null) continue;
                filteredRows += page.getPositionCount();
            }
            Assertions.assertThat((int)filteredRows).isEqualTo(expectedRows);
        }
    }

    private static ConnectorPageSource createPageSource(TrinoFileSystemFactory fileSystemFactory, Location location, TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> columns, ConnectorSession session) throws IOException {
        OrcPageSourceFactory readerFactory = new OrcPageSourceFactory(new OrcReaderOptions(), fileSystemFactory, STATS, DateTimeZone.UTC);
        TrinoInputFile inputFile = fileSystemFactory.create(session).newInputFile(location);
        long length = inputFile.length();
        List columnMappings = HivePageSourceProvider.ColumnMapping.buildColumnMappings((String)"", (List)ImmutableList.of(), columns, (List)ImmutableList.of(), (Map)ImmutableMap.of(), (String)location.toString(), (OptionalInt)OptionalInt.empty(), (long)length, (long)Instant.now().toEpochMilli());
        return (ConnectorPageSource)HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of((Object)readerFactory), (ConnectorSession)session, (Location)location, (OptionalInt)OptionalInt.empty(), (long)0L, (long)length, (long)length, (long)inputFile.lastModified().toEpochMilli(), (Schema)new Schema(HiveStorageFormat.ORC.getSerde(), false, (Map)ImmutableMap.builder().put((Object)"columns", (Object)COLUMNS.stream().map(HiveColumnHandle::getName).collect(Collectors.joining(","))).put((Object)"columns.types", (Object)COLUMNS.stream().map(HiveColumnHandle::getHiveType).map(HiveType::toString).collect(Collectors.joining(","))).buildOrThrow()), effectivePredicate, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, Optional.empty(), Optional.empty(), Optional.empty(), (boolean)false, (AcidTransaction)AcidTransaction.NO_ACID_TRANSACTION, (List)columnMappings).orElseThrow();
    }

    private static void writeTestFile(ConnectorSession session, TrinoFileSystemFactory fileSystemFactory, Location location) {
        FileWriter fileWriter = (FileWriter)new OrcFileWriterFactory(InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"), STATS, new OrcWriterOptions(), fileSystemFactory).createFileWriter(location, COLUMNS.stream().map(HiveColumnHandle::getName).collect(Collectors.toList()), HiveStorageFormat.ORC.toStorageFormat(), HiveCompressionCodec.NONE, TestOrcPredicates.getTableProperties(), session, OptionalInt.empty(), AcidTransaction.NO_ACID_TRANSACTION, false, WriterKind.INSERT).orElseThrow();
        fileWriter.appendRows(new Page(new Block[]{RunLengthEncodedBlock.create((Block)new IntArrayBlock(1, Optional.empty(), new int[]{3}), (int)50000), RunLengthEncodedBlock.create((Block)RowBlock.fromFieldBlocks((int)1, (Block[])new Block[]{new LongArrayBlock(1, Optional.empty(), new long[]{4L}), new LongArrayBlock(1, Optional.empty(), new long[]{5L})}), (int)50000), RunLengthEncodedBlock.create((Block)new LongArrayBlock(1, Optional.empty(), new long[]{6L}), (int)50000)}));
        fileWriter.commit();
    }

    private static Map<String, String> getTableProperties() {
        return ImmutableMap.builder().put((Object)"file.inputformat", (Object)HiveStorageFormat.ORC.getInputFormat()).put((Object)"serialization.lib", (Object)HiveStorageFormat.ORC.getSerde()).put((Object)"columns", (Object)COLUMNS.stream().map(HiveColumnHandle::getName).collect(Collectors.joining(","))).put((Object)"columns.types", (Object)COLUMNS.stream().map(HiveColumnHandle::getHiveType).map(HiveType::toString).collect(Collectors.joining(","))).buildOrThrow();
    }
}

