/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.orc.OrcWriterOptions;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.util.HiveUtil;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOrcWriterOptions {
    @Test
    public void testDefaultOrcWriterOptions() {
        OrcWriterOptions orcWriterOptions = new OrcWriterOptions();
        Assertions.assertThat((Comparable)orcWriterOptions.getWriterIdentification()).isEqualTo((Object)OrcWriterOptions.WriterIdentification.TRINO);
        Assertions.assertThat((Comparable)orcWriterOptions.getStripeMinSize()).isEqualTo((Object)DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assertions.assertThat((Comparable)orcWriterOptions.getStripeMaxSize()).isEqualTo((Object)DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assertions.assertThat((int)orcWriterOptions.getStripeMaxRowCount()).isEqualTo(10000000);
        Assertions.assertThat((int)orcWriterOptions.getRowGroupMaxRowCount()).isEqualTo(10000);
        Assertions.assertThat((Comparable)orcWriterOptions.getDictionaryMaxMemory()).isEqualTo((Object)DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assertions.assertThat((Comparable)orcWriterOptions.getMaxStringStatisticsLimit()).isEqualTo((Object)DataSize.ofBytes((long)64L));
        Assertions.assertThat((Comparable)orcWriterOptions.getMaxCompressionBufferSize()).isEqualTo((Object)DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        Assertions.assertThat((double)orcWriterOptions.getBloomFilterFpp()).isEqualTo(0.05);
        Assertions.assertThat((boolean)orcWriterOptions.isBloomFilterColumn("unknown_column")).isFalse();
    }

    @Test
    public void testOrcWriterOptionsFromOrcWriterConfig() {
        OrcWriterConfig orcWriterConfig = new OrcWriterConfig().setWriterIdentification(OrcWriterOptions.WriterIdentification.LEGACY_HIVE_COMPATIBLE).setStripeMinSize(DataSize.ofBytes((long)32L)).setStripeMaxSize(DataSize.ofBytes((long)64L)).setStripeMaxRowCount(100).setRowGroupMaxRowCount(10).setDictionaryMaxMemory(DataSize.ofBytes((long)16L)).setStringStatisticsLimit(DataSize.ofBytes((long)16L)).setMaxCompressionBufferSize(DataSize.ofBytes((long)256L)).setDefaultBloomFilterFpp(0.5);
        OrcWriterOptions orcWriterOptions = orcWriterConfig.toOrcWriterOptions();
        Assertions.assertThat((Comparable)orcWriterOptions.getWriterIdentification()).isEqualTo((Object)OrcWriterOptions.WriterIdentification.LEGACY_HIVE_COMPATIBLE);
        Assertions.assertThat((Comparable)orcWriterOptions.getStripeMinSize()).isEqualTo((Object)DataSize.ofBytes((long)32L));
        Assertions.assertThat((Comparable)orcWriterOptions.getStripeMaxSize()).isEqualTo((Object)DataSize.ofBytes((long)64L));
        Assertions.assertThat((int)orcWriterOptions.getStripeMaxRowCount()).isEqualTo(100);
        Assertions.assertThat((int)orcWriterOptions.getRowGroupMaxRowCount()).isEqualTo(10);
        Assertions.assertThat((Comparable)orcWriterOptions.getDictionaryMaxMemory()).isEqualTo((Object)DataSize.ofBytes((long)16L));
        Assertions.assertThat((Comparable)orcWriterOptions.getMaxStringStatisticsLimit()).isEqualTo((Object)DataSize.ofBytes((long)16L));
        Assertions.assertThat((Comparable)orcWriterOptions.getMaxCompressionBufferSize()).isEqualTo((Object)DataSize.ofBytes((long)256L));
        Assertions.assertThat((double)orcWriterOptions.getBloomFilterFpp()).isEqualTo(0.5);
        Assertions.assertThat((boolean)orcWriterOptions.isBloomFilterColumn("unknown_column")).isFalse();
    }

    @Test
    public void testOrcWriterOptionsFromTableProperties() {
        ImmutableMap tableProperties = ImmutableMap.builder().put((Object)"orc.bloom.filter.columns", (Object)"column_a, column_b").put((Object)"orc.bloom.filter.fpp", (Object)"0.5").buildOrThrow();
        OrcWriterOptions orcWriterOptions = HiveUtil.getOrcWriterOptions((Map)tableProperties, (OrcWriterOptions)new OrcWriterOptions());
        Assertions.assertThat((double)orcWriterOptions.getBloomFilterFpp()).isEqualTo(0.5);
        Assertions.assertThat((boolean)orcWriterOptions.isBloomFilterColumn("column_a")).isTrue();
        Assertions.assertThat((boolean)orcWriterOptions.isBloomFilterColumn("column_b")).isTrue();
        Assertions.assertThat((boolean)orcWriterOptions.isBloomFilterColumn("unknown_column")).isFalse();
    }

    @Test
    public void testOrcWriterOptionsWithInvalidFPPValue() {
        Map<String, String> tableProperties = TestOrcWriterOptions.createTablePropertiesWithFpp("abc");
        Assertions.assertThatThrownBy(() -> HiveUtil.getOrcWriterOptions((Map)tableProperties, (OrcWriterOptions)new OrcWriterOptions())).hasMessage("Invalid value for orc_bloom_filter_fpp property: abc");
    }

    @Test
    public void testOrcBloomFilterWithInvalidRange() {
        Assertions.assertThatThrownBy(() -> HiveUtil.getOrcWriterOptions(TestOrcWriterOptions.createTablePropertiesWithFpp("100"), (OrcWriterOptions)new OrcWriterOptions())).hasMessage("bloomFilterFpp should be > 0.0 & < 1.0");
        Assertions.assertThatThrownBy(() -> HiveUtil.getOrcWriterOptions(TestOrcWriterOptions.createTablePropertiesWithFpp("-100"), (OrcWriterOptions)new OrcWriterOptions())).hasMessage("bloomFilterFpp should be > 0.0 & < 1.0");
        Assertions.assertThatThrownBy(() -> HiveUtil.getOrcWriterOptions(TestOrcWriterOptions.createTablePropertiesWithFpp("0"), (OrcWriterOptions)new OrcWriterOptions())).hasMessage("bloomFilterFpp should be > 0.0 & < 1.0");
        Assertions.assertThatThrownBy(() -> HiveUtil.getOrcWriterOptions(TestOrcWriterOptions.createTablePropertiesWithFpp("1"), (OrcWriterOptions)new OrcWriterOptions())).hasMessage("bloomFilterFpp should be > 0.0 & < 1.0");
    }

    private static Map<String, String> createTablePropertiesWithFpp(String fpp) {
        return ImmutableMap.builder().put((Object)"orc.bloom.filter.columns", (Object)"column_with_bloom_filter").put((Object)"orc.bloom.filter.fpp", (Object)fpp).buildOrThrow();
    }

    @Test
    public void testOrcWriterOptionsWithMissingFPPValue() {
        ImmutableMap tableProperties = ImmutableMap.builder().put((Object)"orc.bloom.filter.columns", (Object)"column_with_bloom_filter").buildOrThrow();
        OrcWriterOptions orcWriterOptions = HiveUtil.getOrcWriterOptions((Map)tableProperties, (OrcWriterOptions)new OrcWriterOptions());
        Assertions.assertThat((double)orcWriterOptions.getBloomFilterFpp()).isEqualTo(0.05);
    }
}

