/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.local.LocalInputFile;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.ParquetWriteValidation;
import io.trino.parquet.writer.ParquetSchemaConverter;
import io.trino.parquet.writer.ParquetWriter;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetUtil;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.hive.parquet.TrinoParquetDataSource;
import io.trino.plugin.hive.parquet.write.MapKeyValuesSchemaConverter;
import io.trino.plugin.hive.parquet.write.SingleLevelArrayMapKeyValuesSchemaConverter;
import io.trino.plugin.hive.parquet.write.SingleLevelArraySchemaConverter;
import io.trino.plugin.hive.parquet.write.TestingMapredParquetOutputFormat;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import io.trino.testing.TestingConnectorSession;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTimeZone;

class ParquetTester {
    private static final int MAX_PRECISION_INT64 = Math.toIntExact(ParquetTester.maxPrecision(8));
    private static final ConnectorSession SESSION = HiveTestUtils.getHiveSession(ParquetTester.createHiveConfig(false));
    private static final ConnectorSession SESSION_USE_NAME = HiveTestUtils.getHiveSession(ParquetTester.createHiveConfig(true));
    public static final List<String> TEST_COLUMN = Collections.singletonList("test");
    private final Set<CompressionCodec> compressions;
    private final Set<CompressionCodec> writerCompressions;
    private final Set<ParquetProperties.WriterVersion> versions;
    private final Set<ConnectorSession> sessions;

    public static ParquetTester quickParquetTester() {
        return new ParquetTester((Set<CompressionCodec>)ImmutableSet.of((Object)CompressionCodec.GZIP), (Set<CompressionCodec>)ImmutableSet.of((Object)CompressionCodec.GZIP), (Set<ParquetProperties.WriterVersion>)ImmutableSet.of((Object)ParquetProperties.WriterVersion.PARQUET_1_0), (Set<ConnectorSession>)ImmutableSet.of((Object)SESSION));
    }

    public static ParquetTester fullParquetTester() {
        return new ParquetTester((Set<CompressionCodec>)ImmutableSet.of((Object)CompressionCodec.GZIP, (Object)CompressionCodec.UNCOMPRESSED, (Object)CompressionCodec.SNAPPY, (Object)CompressionCodec.LZ4, (Object)CompressionCodec.ZSTD), (Set<CompressionCodec>)ImmutableSet.of((Object)CompressionCodec.GZIP, (Object)CompressionCodec.UNCOMPRESSED, (Object)CompressionCodec.SNAPPY, (Object)CompressionCodec.ZSTD), (Set<ParquetProperties.WriterVersion>)ImmutableSet.copyOf((Object[])ParquetProperties.WriterVersion.values()), (Set<ConnectorSession>)ImmutableSet.of((Object)SESSION, (Object)SESSION_USE_NAME));
    }

    public ParquetTester(Set<CompressionCodec> compressions, Set<CompressionCodec> writerCompressions, Set<ParquetProperties.WriterVersion> versions, Set<ConnectorSession> sessions) {
        this.compressions = Objects.requireNonNull(compressions, "compressions is null");
        this.writerCompressions = Objects.requireNonNull(writerCompressions, "writerCompressions is null");
        this.versions = Objects.requireNonNull(versions, "writerCompressions is null");
        this.sessions = Objects.requireNonNull(sessions, "sessions is null");
    }

    public void testRoundTrip(PrimitiveObjectInspector columnObjectInspector, Iterable<?> writeValues, Type parameterType) throws Exception {
        this.testRoundTrip((ObjectInspector)columnObjectInspector, writeValues, writeValues, parameterType);
    }

    public <W, R> void testRoundTrip(PrimitiveObjectInspector columnObjectInspector, Iterable<W> writeValues, java.util.function.Function<W, R> readTransform, Type parameterType) throws Exception {
        this.testRoundTrip((ObjectInspector)columnObjectInspector, writeValues, Iterables.transform(writeValues, readTransform::apply), parameterType);
    }

    public void testSingleLevelArraySchemaRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type) throws Exception {
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)objectInspector.getTypeName());
        MessageType schema = SingleLevelArraySchemaConverter.convert(TEST_COLUMN, typeInfos);
        this.testRoundTrip(objectInspector, writeValues, readValues, (String)Iterables.getOnlyElement(TEST_COLUMN), type, Optional.of(schema), ParquetSchemaOptions.withSingleLevelArray());
        if (objectInspector.getTypeName().contains("map<")) {
            schema = SingleLevelArrayMapKeyValuesSchemaConverter.convert(TEST_COLUMN, typeInfos);
            this.testRoundTrip(objectInspector, writeValues, readValues, (String)Iterables.getOnlyElement(TEST_COLUMN), type, Optional.of(schema), ParquetSchemaOptions.withSingleLevelArray());
        }
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type) throws Exception {
        this.testRoundTrip(objectInspector, writeValues, readValues, type, Optional.empty());
        if (objectInspector.getTypeName().contains("map<")) {
            ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)objectInspector.getTypeName());
            MessageType schema = MapKeyValuesSchemaConverter.convert(TEST_COLUMN, typeInfos);
            this.testRoundTrip(objectInspector, writeValues, readValues, type, Optional.of(schema));
        }
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type, Optional<MessageType> parquetSchema) throws Exception {
        this.testRoundTrip(objectInspector, writeValues, readValues, (String)Iterables.getOnlyElement(TEST_COLUMN), type, parquetSchema, ParquetSchemaOptions.defaultOptions());
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, String columnName, Type type, Optional<MessageType> parquetSchema) throws Exception {
        this.testRoundTrip(objectInspector, writeValues, readValues, columnName, type, parquetSchema, ParquetSchemaOptions.defaultOptions());
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, String columnName, Type type, Optional<MessageType> parquetSchema, ParquetSchemaOptions schemaOptions) throws Exception {
        this.testRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, Collections.singletonList(columnName), Collections.singletonList(type), parquetSchema, schemaOptions);
    }

    public void testRoundTrip(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, ParquetSchemaOptions schemaOptions) throws Exception {
        this.testRoundTripType(objectInspectors, writeValues, readValues, columnNames, columnTypes, parquetSchema, schemaOptions);
        this.assertRoundTrip(objectInspectors, this.transformToNulls(writeValues), this.transformToNulls(readValues), columnNames, columnTypes, parquetSchema, schemaOptions);
    }

    private void testRoundTripType(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, ParquetSchemaOptions schemaOptions) throws Exception {
        this.assertRoundTrip(objectInspectors, writeValues, readValues, columnNames, columnTypes, parquetSchema, schemaOptions);
        this.assertRoundTrip(objectInspectors, ParquetTester.reverse(writeValues), ParquetTester.reverse(readValues), columnNames, columnTypes, parquetSchema, schemaOptions);
        this.assertRoundTrip(objectInspectors, ParquetTester.insertNullEvery(5, writeValues), ParquetTester.insertNullEvery(5, readValues), columnNames, columnTypes, parquetSchema, schemaOptions);
        this.assertRoundTrip(objectInspectors, ParquetTester.insertNullEvery(5, ParquetTester.reverse(writeValues)), ParquetTester.insertNullEvery(5, ParquetTester.reverse(readValues)), columnNames, columnTypes, parquetSchema, schemaOptions);
    }

    void assertRoundTrip(ObjectInspector objectInspectors, Iterable<?> writeValues, Iterable<?> readValues, String columnName, Type columnType, Optional<MessageType> parquetSchema) throws Exception {
        this.assertRoundTrip(Collections.singletonList(objectInspectors), new Iterable[]{writeValues}, new Iterable[]{readValues}, Collections.singletonList(columnName), Collections.singletonList(columnType), parquetSchema, ParquetSchemaOptions.defaultOptions());
    }

    void assertRoundTrip(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, ParquetSchemaOptions schemaOptions) throws Exception {
        this.assertRoundTripWithHiveWriter(objectInspectors, writeValues, readValues, columnNames, columnTypes, parquetSchema, schemaOptions);
        for (CompressionCodec compressionCodec : this.writerCompressions) {
            for (ConnectorSession session : this.sessions) {
                try (TempFile tempFile = new TempFile("test", "parquet");){
                    OptionalInt min = Arrays.stream(writeValues).mapToInt(Iterables::size).min();
                    Preconditions.checkState((boolean)min.isPresent());
                    ParquetTester.writeParquetColumnTrino(tempFile.getFile(), columnTypes, columnNames, ParquetTester.getIterators(readValues), min.getAsInt(), compressionCodec, schemaOptions);
                    this.assertFileContents(session, tempFile.getFile(), ParquetTester.getIterators(readValues), columnNames, columnTypes);
                }
            }
        }
    }

    void assertRoundTripWithHiveWriter(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, ParquetSchemaOptions schemaOptions) throws Exception {
        for (ParquetProperties.WriterVersion version : this.versions) {
            for (CompressionCodec compressionCodec : this.compressions) {
                for (ConnectorSession session : this.sessions) {
                    try (TempFile tempFile = new TempFile("test", "parquet");){
                        JobConf jobConf = new JobConf(false);
                        jobConf.setEnum("parquet.compression", (Enum)compressionCodec);
                        jobConf.setBoolean("parquet.enable.dictionary", true);
                        jobConf.setEnum("parquet.writer.version", (Enum)version);
                        ParquetTester.writeParquetColumn(jobConf, tempFile.getFile(), compressionCodec, ParquetTester.createTableProperties(columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, objectInspectors), ParquetTester.getIterators(writeValues), parquetSchema, schemaOptions.isSingleLevelArray(), DateTimeZone.getDefault());
                        this.assertFileContents(session, tempFile.getFile(), ParquetTester.getIterators(readValues), columnNames, columnTypes);
                    }
                }
            }
        }
    }

    void testMaxReadBytes(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type, DataSize maxReadBlockSize) throws Exception {
        this.assertMaxReadBytes(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), Optional.empty(), maxReadBlockSize);
    }

    void assertMaxReadBytes(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, DataSize maxReadBlockSize) throws Exception {
        CompressionCodec compressionCodec = CompressionCodec.UNCOMPRESSED;
        HiveSessionProperties hiveSessionProperties = new HiveSessionProperties(new HiveConfig().setHiveStorageFormat(HiveStorageFormat.PARQUET).setUseParquetColumnNames(false), new OrcReaderConfig(), new OrcWriterConfig(), new ParquetReaderConfig().setMaxReadBlockSize(maxReadBlockSize), new ParquetWriterConfig());
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(hiveSessionProperties.getSessionProperties()).build();
        try (TempFile tempFile = new TempFile("test", "parquet");){
            JobConf jobConf = new JobConf(false);
            jobConf.setEnum("parquet.compression", (Enum)compressionCodec);
            jobConf.setBoolean("parquet.enable.dictionary", true);
            jobConf.setEnum("parquet.writer.version", (Enum)ParquetProperties.WriterVersion.PARQUET_1_0);
            ParquetTester.writeParquetColumn(jobConf, tempFile.getFile(), compressionCodec, ParquetTester.createTableProperties(columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, objectInspectors), ParquetTester.getIterators(writeValues), parquetSchema, false, DateTimeZone.getDefault());
            Iterator<?>[] expectedValues = ParquetTester.getIterators(readValues);
            try (ConnectorPageSource pageSource = ParquetUtil.createPageSource((ConnectorSession)session, tempFile.getFile(), columnNames, columnTypes);){
                ParquetTester.assertPageSource(columnTypes, expectedValues, pageSource, Optional.of(HiveSessionProperties.getParquetMaxReadBlockSize((ConnectorSession)session).toBytes()));
                Assertions.assertThat((boolean)Arrays.stream(expectedValues).allMatch(Iterator::hasNext)).isFalse();
            }
        }
    }

    private void assertFileContents(ConnectorSession session, File dataFile, Iterator<?>[] expectedValues, List<String> columnNames, List<Type> columnTypes) throws IOException {
        try (ConnectorPageSource pageSource = ParquetUtil.createPageSource(session, dataFile, columnNames, columnTypes);){
            if (pageSource instanceof RecordPageSource) {
                ParquetTester.assertRecordCursor(columnTypes, expectedValues, ((RecordPageSource)pageSource).getCursor());
            } else {
                ParquetTester.assertPageSource(columnTypes, expectedValues, pageSource);
            }
            Assertions.assertThat((boolean)Arrays.stream(expectedValues).allMatch(Iterator::hasNext)).isFalse();
        }
    }

    private static void assertPageSource(List<Type> types, Iterator<?>[] valuesByField, ConnectorPageSource pageSource) {
        ParquetTester.assertPageSource(types, valuesByField, pageSource, Optional.empty());
    }

    private static void assertPageSource(List<Type> types, Iterator<?>[] valuesByField, ConnectorPageSource pageSource, Optional<Long> maxReadBlockSize) {
        while (!pageSource.isFinished()) {
            Page page = pageSource.getNextPage();
            if (page == null) continue;
            maxReadBlockSize.ifPresent(max -> Assertions.assertThat((page.getPositionCount() == 1 || page.getSizeInBytes() <= max ? 1 : 0) != 0).isTrue());
            for (int field = 0; field < page.getChannelCount(); ++field) {
                Block block = page.getBlock(field);
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    Assertions.assertThat((boolean)valuesByField[field].hasNext()).isTrue();
                    Object expected = valuesByField[field].next();
                    Object actual = ParquetTester.decodeObject(types.get(field), block, i);
                    Assertions.assertThat((Object)actual).isEqualTo(expected);
                }
            }
        }
    }

    private static void assertRecordCursor(List<Type> types, Iterator<?>[] valuesByField, RecordCursor cursor) {
        while (cursor.advanceNextPosition()) {
            for (int field = 0; field < types.size(); ++field) {
                Assertions.assertThat((boolean)valuesByField[field].hasNext()).isTrue();
                Object expected = valuesByField[field].next();
                Object actual = ParquetTester.getActualCursorValue(cursor, types.get(field), field);
                Assertions.assertThat((Object)actual).isEqualTo(expected);
            }
        }
    }

    private static Object getActualCursorValue(RecordCursor cursor, Type type, int field) {
        Object fieldFromCursor = ParquetTester.getFieldFromCursor(cursor, type, field);
        if (fieldFromCursor == null) {
            return null;
        }
        if (HiveUtil.isStructuralType((Type)type)) {
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                return ParquetTester.toArrayValue((Block)fieldFromCursor, arrayType.getElementType());
            }
            if (type instanceof MapType) {
                MapType mapType = (MapType)type;
                return ParquetTester.toMapValue((SqlMap)fieldFromCursor, mapType.getKeyType(), mapType.getValueType());
            }
            if (type instanceof RowType) {
                return ParquetTester.toRowValue((Block)fieldFromCursor, type.getTypeParameters());
            }
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new SqlDecimal((BigInteger)fieldFromCursor, decimalType.getPrecision(), decimalType.getScale());
        }
        if (type instanceof VarcharType) {
            return new String(((Slice)fieldFromCursor).getBytes(), StandardCharsets.UTF_8);
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return new SqlVarbinary(((Slice)fieldFromCursor).getBytes());
        }
        if (DateType.DATE.equals((Object)type)) {
            return new SqlDate(((Long)fieldFromCursor).intValue());
        }
        if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
            return SqlTimestamp.fromMillis((int)3, (long)((Long)fieldFromCursor));
        }
        return fieldFromCursor;
    }

    private static Object getFieldFromCursor(RecordCursor cursor, Type type, int field) {
        if (cursor.isNull(field)) {
            return null;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return cursor.getBoolean(field);
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return cursor.getLong(field);
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return cursor.getLong(field);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return (int)cursor.getLong(field);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return cursor.getLong(field);
        }
        if (RealType.REAL.equals((Object)type)) {
            return Float.valueOf(Float.intBitsToFloat((int)cursor.getLong(field)));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return cursor.getDouble(field);
        }
        if (type instanceof VarcharType || type instanceof CharType || VarbinaryType.VARBINARY.equals((Object)type)) {
            return cursor.getSlice(field);
        }
        if (DateType.DATE.equals((Object)type)) {
            return cursor.getLong(field);
        }
        if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
            return cursor.getLong(field);
        }
        if (HiveUtil.isStructuralType((Type)type)) {
            return cursor.getObject(field);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                return BigInteger.valueOf(cursor.getLong(field));
            }
            return ((Int128)cursor.getObject(field)).toBigInteger();
        }
        throw new RuntimeException("unknown type");
    }

    private static Map<?, ?> toMapValue(SqlMap sqlMap, Type keyType, Type valueType) {
        int rawOffset = sqlMap.getRawOffset();
        Block rawKeyBlock = sqlMap.getRawKeyBlock();
        Block rawValueBlock = sqlMap.getRawValueBlock();
        HashMap<Object, Object> map = new HashMap<Object, Object>(sqlMap.getSize());
        for (int i = 0; i < sqlMap.getSize(); ++i) {
            map.put(keyType.getObjectValue(SESSION, rawKeyBlock, rawOffset + i), valueType.getObjectValue(SESSION, rawValueBlock, rawOffset + i));
        }
        return Collections.unmodifiableMap(map);
    }

    private static List<?> toArrayValue(Block arrayBlock, Type elementType) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int position = 0; position < arrayBlock.getPositionCount(); ++position) {
            values.add(elementType.getObjectValue(SESSION, arrayBlock, position));
        }
        return Collections.unmodifiableList(values);
    }

    private static List<?> toRowValue(Block rowBlock, List<Type> fieldTypes) {
        ArrayList<Object> values = new ArrayList<Object>(rowBlock.getPositionCount());
        for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
            values.add(fieldTypes.get(i).getObjectValue(SESSION, rowBlock, i));
        }
        return Collections.unmodifiableList(values);
    }

    private static HiveConfig createHiveConfig(boolean useParquetColumnNames) {
        return new HiveConfig().setHiveStorageFormat(HiveStorageFormat.PARQUET).setUseParquetColumnNames(useParquetColumnNames);
    }

    public static void writeParquetColumn(JobConf jobConf, File outputFile, CompressionCodec compressionCodec, Properties tableProperties, SettableStructObjectInspector objectInspector, Iterator<?>[] valuesByField, Optional<MessageType> parquetSchema, boolean singleLevelArray, DateTimeZone dateTimeZone) throws Exception {
        FileSinkOperator.RecordWriter recordWriter = new TestingMapredParquetOutputFormat(parquetSchema, singleLevelArray, dateTimeZone).getHiveRecordWriter(jobConf, new Path(outputFile.toURI()), Text.class, compressionCodec != CompressionCodec.UNCOMPRESSED, tableProperties, () -> {});
        Object row = objectInspector.create();
        ImmutableList fields = ImmutableList.copyOf((Collection)objectInspector.getAllStructFieldRefs());
        while (Arrays.stream(valuesByField).allMatch(Iterator::hasNext)) {
            for (int field = 0; field < fields.size(); ++field) {
                Object value = valuesByField[field].next();
                objectInspector.setStructFieldData(row, (StructField)fields.get(field), value);
            }
            ParquetHiveSerDe serde = new ParquetHiveSerDe();
            serde.initialize((Configuration)jobConf, tableProperties, null);
            Writable record = serde.serialize(row, (ObjectInspector)objectInspector);
            recordWriter.write(record);
        }
        recordWriter.close(false);
    }

    public static Properties createTableProperties(List<String> columnNames, List<ObjectInspector> objectInspectors) {
        Properties orderTableProperties = new Properties();
        orderTableProperties.setProperty("columns", Joiner.on((char)',').join(columnNames));
        orderTableProperties.setProperty("columns.types", Joiner.on((char)',').join(Iterables.transform(objectInspectors, ObjectInspector::getTypeName)));
        return orderTableProperties;
    }

    private static Iterator<?>[] getIterators(Iterable<?>[] values) {
        return (Iterator[])Arrays.stream(values).map(Iterable::iterator).toArray(Iterator[]::new);
    }

    private Iterable<?>[] transformToNulls(Iterable<?>[] values) {
        return (Iterable[])Arrays.stream(values).map(v -> Iterables.transform((Iterable)v, (Function)Functions.constant(null))).toArray(Iterable[]::new);
    }

    private static Iterable<?>[] reverse(Iterable<?>[] iterables) {
        return (Iterable[])Arrays.stream(iterables).map(ImmutableList::copyOf).map(List::reversed).toArray(Iterable[]::new);
    }

    private static Iterable<?>[] insertNullEvery(int n, Iterable<?>[] iterables) {
        return (Iterable[])Arrays.stream(iterables).map(itr -> ParquetTester.insertNullEvery(n, itr)).toArray(Iterable[]::new);
    }

    static <T> Iterable<T> insertNullEvery(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private final Iterator<T> delegate;
            private int position;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                ++this.position;
                if (this.position > n) {
                    this.position = 0;
                    return null;
                }
                if (!this.delegate.hasNext()) {
                    return this.endOfData();
                }
                return this.delegate.next();
            }
        };
    }

    private static Object decodeObject(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return type.getObjectValue(SESSION, block, position);
    }

    private static void writeParquetColumnTrino(File outputFile, List<Type> types, List<String> columnNames, Iterator<?>[] values, int size, CompressionCodec compressionCodec, ParquetSchemaOptions schemaOptions) throws Exception {
        Preconditions.checkArgument((types.size() == columnNames.size() && types.size() == values.length ? 1 : 0) != 0);
        ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter(types, columnNames, schemaOptions.useLegacyDecimalEncoding(), schemaOptions.useInt96TimestampEncoding());
        ParquetWriter writer = new ParquetWriter((OutputStream)new FileOutputStream(outputFile), schemaConverter.getMessageType(), schemaConverter.getPrimitiveTypes(), ParquetWriterOptions.builder().setMaxPageSize(DataSize.ofBytes((long)2000L)).setMaxPageValueCount(200).setMaxBlockSize(DataSize.ofBytes((long)100000L)).build(), compressionCodec, "test-version", Optional.of(DateTimeZone.getDefault()), Optional.of(new ParquetWriteValidation.ParquetWriteValidationBuilder(types, columnNames)));
        PageBuilder pageBuilder = new PageBuilder(types);
        for (int i = 0; i < types.size(); ++i) {
            Type type = types.get(i);
            Iterator<?> iterator = values[i];
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
            for (int j = 0; j < size; ++j) {
                Preconditions.checkState((boolean)iterator.hasNext());
                Object value = iterator.next();
                ParquetTester.writeValue(type, blockBuilder, value);
            }
        }
        pageBuilder.declarePositions(size);
        writer.write(pageBuilder.build());
        writer.close();
        try {
            writer.validate((ParquetDataSource)new TrinoParquetDataSource((TrinoInputFile)new LocalInputFile(outputFile), new ParquetReaderOptions(), new FileFormatDataSourceStats()));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
        }
    }

    private static void writeValue(Type type, BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (BooleanType.BOOLEAN.equals((Object)type)) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (TinyintType.TINYINT.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || BigintType.BIGINT.equals((Object)type)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                type.writeLong(blockBuilder, ((SqlDecimal)value).getUnscaledValue().longValue());
            } else if (Decimals.overflows((BigInteger)((SqlDecimal)value).getUnscaledValue(), (int)MAX_PRECISION_INT64)) {
                type.writeObject(blockBuilder, (Object)Int128.valueOf((BigInteger)((SqlDecimal)value).toBigDecimal().unscaledValue()));
            } else {
                type.writeObject(blockBuilder, (Object)Int128.valueOf((long)((SqlDecimal)value).getUnscaledValue().longValue()));
            }
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            type.writeDouble(blockBuilder, ((Number)value).doubleValue());
        } else if (RealType.REAL.equals((Object)type)) {
            float floatValue = ((Number)value).floatValue();
            type.writeLong(blockBuilder, (long)Float.floatToIntBits(floatValue));
        } else if (type instanceof VarcharType) {
            Slice slice = Varchars.truncateToLength((Slice)Slices.utf8Slice((String)((String)value)), (Type)type);
            type.writeSlice(blockBuilder, slice);
        } else if (type instanceof CharType) {
            Slice slice = Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)((String)value)), (Type)type);
            type.writeSlice(blockBuilder, slice);
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            type.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])((SqlVarbinary)value).getBytes()));
        } else if (DateType.DATE.equals((Object)type)) {
            long days = ((SqlDate)value).getDays();
            type.writeLong(blockBuilder, days);
        } else if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type) || TimestampType.TIMESTAMP_MICROS.equals((Object)type)) {
            type.writeLong(blockBuilder, ((SqlTimestamp)value).getEpochMicros());
        } else if (TimestampType.TIMESTAMP_NANOS.equals((Object)type)) {
            type.writeObject(blockBuilder, (Object)new LongTimestamp(((SqlTimestamp)value).getEpochMicros(), ((SqlTimestamp)value).getPicosOfMicros()));
        } else if (type instanceof ArrayType) {
            List array = (List)value;
            Type elementType = (Type)type.getTypeParameters().get(0);
            ((ArrayBlockBuilder)blockBuilder).buildEntry(elementBuilder -> {
                for (Object elementValue : array) {
                    ParquetTester.writeValue(elementType, elementBuilder, elementValue);
                }
            });
        } else if (type instanceof MapType) {
            Map map = (Map)value;
            Type keyType = (Type)type.getTypeParameters().get(0);
            Type valueType = (Type)type.getTypeParameters().get(1);
            ((MapBlockBuilder)blockBuilder).buildEntry((keyBuilder, valueBuilder) -> {
                for (Map.Entry entry : map.entrySet()) {
                    ParquetTester.writeValue(keyType, keyBuilder, entry.getKey());
                    ParquetTester.writeValue(valueType, valueBuilder, entry.getValue());
                }
            });
        } else if (type instanceof RowType) {
            List array = (List)value;
            List fieldTypes = type.getTypeParameters();
            ((RowBlockBuilder)blockBuilder).buildEntry(fieldBuilders -> {
                for (int fieldId = 0; fieldId < fieldTypes.size(); ++fieldId) {
                    Type fieldType = (Type)fieldTypes.get(fieldId);
                    ParquetTester.writeValue(fieldType, (BlockBuilder)fieldBuilders.get(fieldId), array.get(fieldId));
                }
            });
        } else {
            throw new IllegalArgumentException("Unsupported type " + String.valueOf(type));
        }
    }

    private static long maxPrecision(int numBytes) {
        return Math.round(Math.floor(Math.log10(Math.pow(2.0, 8 * numBytes - 1) - 1.0)));
    }

    public static class ParquetSchemaOptions {
        private final boolean singleLevelArray;
        private final boolean useLegacyDecimalEncoding;
        private final boolean useInt96TimestampEncoding;

        private ParquetSchemaOptions(boolean singleLevelArray, boolean useLegacyDecimalEncoding, boolean useInt96TimestampEncoding) {
            this.singleLevelArray = singleLevelArray;
            this.useLegacyDecimalEncoding = useLegacyDecimalEncoding;
            this.useInt96TimestampEncoding = useInt96TimestampEncoding;
        }

        public static ParquetSchemaOptions defaultOptions() {
            return new ParquetSchemaOptions(false, true, true);
        }

        public static ParquetSchemaOptions withSingleLevelArray() {
            return new ParquetSchemaOptions(true, true, true);
        }

        public static ParquetSchemaOptions withInt64BackedTimestamps() {
            return new ParquetSchemaOptions(false, false, false);
        }

        public boolean isSingleLevelArray() {
            return this.singleLevelArray;
        }

        public boolean useLegacyDecimalEncoding() {
            return this.useLegacyDecimalEncoding;
        }

        public boolean useInt96TimestampEncoding() {
            return this.useInt96TimestampEncoding;
        }
    }

    public static class TempFile
    implements Closeable {
        private final File file;

        public TempFile(String prefix, String suffix) {
            try {
                this.file = File.createTempFile(prefix, suffix);
                Verify.verify((boolean)this.file.delete());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public void close() {
            if (!this.file.delete()) {
                Verify.verify((!this.file.exists() ? 1 : 0) != 0);
            }
        }
    }
}

