/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.memory.MemoryFileSystemFactory;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.Schema;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.Type;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.joda.time.DateTimeZone;

final class ParquetUtil {
    private ParquetUtil() {
    }

    public static ConnectorPageSource createPageSource(ConnectorSession session, File parquetFile, List<String> columnNames, List<Type> columnTypes) throws IOException {
        return ParquetUtil.createPageSource(session, parquetFile, ParquetUtil.getBaseColumns(columnNames, columnTypes), (TupleDomain<HiveColumnHandle>)TupleDomain.all());
    }

    public static ConnectorPageSource createPageSource(ConnectorSession session, File parquetFile, List<String> columnNames, List<Type> columnTypes, DateTimeZone timeZone) throws IOException {
        return ParquetUtil.createPageSource(session, parquetFile, ParquetUtil.getBaseColumns(columnNames, columnTypes), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), new HiveConfig().setParquetTimeZone(timeZone.toString()));
    }

    public static ConnectorPageSource createPageSource(ConnectorSession session, File parquetFile, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> domain, DateTimeZone timeZone) throws IOException {
        return ParquetUtil.createPageSource(session, parquetFile, columns, domain, new HiveConfig().setParquetTimeZone(timeZone.toString()));
    }

    public static ConnectorPageSource createPageSource(ConnectorSession session, File parquetFile, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> domain) throws IOException {
        return ParquetUtil.createPageSource(session, parquetFile, columns, domain, new HiveConfig());
    }

    private static ConnectorPageSource createPageSource(ConnectorSession session, File parquetFile, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> domain, HiveConfig hiveConfig) throws IOException {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        Location location = Location.of((String)"memory:///test.file");
        try (OutputStream out = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test")).newOutputFile(location).create();){
            out.write(Files.readAllBytes(parquetFile.toPath()));
        }
        ParquetPageSourceFactory hivePageSourceFactory = new ParquetPageSourceFactory((TrinoFileSystemFactory)fileSystemFactory, new FileFormatDataSourceStats(), new ParquetReaderConfig(), hiveConfig);
        return ((ReaderPageSource)hivePageSourceFactory.createPageSource(session, location, 0L, parquetFile.length(), parquetFile.length(), parquetFile.lastModified(), new Schema(HiveStorageFormat.PARQUET.getSerde(), false, (Map)ImmutableMap.of()), columns, domain, Optional.empty(), OptionalInt.empty(), false, AcidTransaction.NO_ACID_TRANSACTION).orElseThrow()).get();
    }

    private static List<HiveColumnHandle> getBaseColumns(List<String> columnNames, List<Type> columnTypes) {
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes should have the same size");
        return (List)IntStream.range(0, columnNames.size()).mapToObj(index -> HiveColumnHandle.createBaseColumn((String)((String)columnNames.get(index)), (int)index, (HiveType)HiveTypeTranslator.toHiveType((Type)((Type)columnTypes.get(index))), (Type)((Type)columnTypes.get(index)), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty())).collect(ImmutableList.toImmutableList());
    }
}

