/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.parquet.write.TestingMapredParquetOutputFormat;
import io.trino.spi.type.Decimals;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.Test;

public class TestParquetDecimalScaling
extends AbstractTestQueryFramework {
    private java.nio.file.Path basePath;

    protected QueryRunner createQueryRunner() throws Exception {
        this.basePath = TestParquetDecimalScaling.getBasePath();
        return ((HiveQueryRunner.Builder)HiveQueryRunner.builder().setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.NATION)).setBaseDataDir(Optional.of(this.basePath))).build();
    }

    @Test
    public void testReadingMatchingPrecision() {
        for (ParquetProperties.WriterVersion writerVersion : ParquetProperties.WriterVersion.values()) {
            this.testReadingMatchingPrecision(10, 2, false, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), (List<String>)ImmutableList.of((Object)"10.01", (Object)"10.00", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), writerVersion);
            this.testReadingMatchingPrecision(10, 2, true, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), (List<String>)ImmutableList.of((Object)"10.01", (Object)"10.00", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), writerVersion);
            this.testReadingMatchingPrecision(4, 2, false, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), (List<String>)ImmutableList.of((Object)"10.01", (Object)"10.00", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), writerVersion);
            this.testReadingMatchingPrecision(4, 2, true, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), (List<String>)ImmutableList.of((Object)"10.01", (Object)"10.00", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), writerVersion);
            this.testReadingMatchingPrecision(14, 2, false, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(14, 2), (Object)ParquetDecimalInsert.minimumValue(14, 2)), (List<String>)ImmutableList.of((Object)"10.01", (Object)"10.00", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(14, 2), (Object)ParquetDecimalInsert.minimumValue(14, 2)), writerVersion);
            this.testReadingMatchingPrecision(6, 3, false, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(6, 3), (Object)ParquetDecimalInsert.minimumValue(6, 3)), (List<String>)ImmutableList.of((Object)"10.010", (Object)"10.000", (Object)"1.230", (Object)ParquetDecimalInsert.maximumValue(6, 3), (Object)ParquetDecimalInsert.minimumValue(6, 3)), writerVersion);
            this.testReadingMatchingPrecision(6, 3, true, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(6, 3), (Object)ParquetDecimalInsert.minimumValue(6, 3)), (List<String>)ImmutableList.of((Object)"10.010", (Object)"10.000", (Object)"1.230", (Object)ParquetDecimalInsert.maximumValue(6, 3), (Object)ParquetDecimalInsert.minimumValue(6, 3)), writerVersion);
            this.testReadingMatchingPrecision(38, 4, false, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(38, 4), (Object)ParquetDecimalInsert.minimumValue(38, 4)), (List<String>)ImmutableList.of((Object)"10.0100", (Object)"10.0000", (Object)"1.2300", (Object)ParquetDecimalInsert.maximumValue(38, 4), (Object)ParquetDecimalInsert.minimumValue(38, 4)), writerVersion);
        }
    }

    private void testReadingMatchingPrecision(int precision, int scale, boolean forceFixedLengthArray, List<String> values, List<String> expected, ParquetProperties.WriterVersion writerVersion) {
        String tableName = TestParquetDecimalScaling.generateTableName("matching_precision", precision, scale);
        this.createTable(tableName, precision, scale);
        TestParquetDecimalScaling.writeParquetDecimalsRecord(this.getParquetWritePath(tableName), (List<ParquetDecimalInsert>)ImmutableList.of((Object)new ParquetDecimalInsert("value", forceFixedLengthArray, precision, scale, values)), writerVersion);
        this.assertValues(tableName, scale, expected);
        this.dropTable(tableName);
    }

    @Test
    public void testReadingRescaledDecimals() {
        for (ParquetProperties.WriterVersion writerVersion : ParquetProperties.WriterVersion.values()) {
            this.testReadingRescaledDecimals(10, 2, false, 12, 4, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), (List<String>)ImmutableList.of((Object)"10.0100", (Object)"10.0000", (Object)"1.2300", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), writerVersion);
            this.testReadingRescaledDecimals(10, 2, true, 13, 5, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), (List<String>)ImmutableList.of((Object)"10.01000", (Object)"10.0000", (Object)"1.23000", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), writerVersion);
            this.testReadingRescaledDecimals(4, 2, false, 6, 4, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), (List<String>)ImmutableList.of((Object)"10.0100", (Object)"10.0000", (Object)"1.2300", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), writerVersion);
            this.testReadingRescaledDecimals(4, 2, false, 6, 2, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), (List<String>)ImmutableList.of((Object)"10.01", (Object)"10.00", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), writerVersion);
            this.testReadingRescaledDecimals(10, 2, false, 11, 3, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), (List<String>)ImmutableList.of((Object)"10.010", (Object)"10.000", (Object)"1.230", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), writerVersion);
            this.testReadingRescaledDecimals(10, 2, true, 12, 4, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), (List<String>)ImmutableList.of((Object)"10.0100", (Object)"10.0000", (Object)"1.2300", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), writerVersion);
            this.testReadingRescaledDecimals(4, 2, false, 10, 5, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), (List<String>)ImmutableList.of((Object)"10.01000", (Object)"10.00000", (Object)"1.23000", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), writerVersion);
            this.testReadingRescaledDecimals(4, 2, true, 10, 5, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), (List<String>)ImmutableList.of((Object)"10.01000", (Object)"10.00000", (Object)"1.23000", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), writerVersion);
            this.testReadingRescaledDecimals(14, 2, false, 20, 3, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(14, 2), (Object)ParquetDecimalInsert.minimumValue(14, 2)), (List<String>)ImmutableList.of((Object)"10.010", (Object)"10.000", (Object)"1.230", (Object)ParquetDecimalInsert.maximumValue(14, 2), (Object)ParquetDecimalInsert.minimumValue(14, 2)), writerVersion);
            this.testReadingRescaledDecimals(6, 3, false, 9, 6, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(6, 3), (Object)ParquetDecimalInsert.minimumValue(6, 3)), (List<String>)ImmutableList.of((Object)"10.010000", (Object)"10.000000", (Object)"1.230000", (Object)ParquetDecimalInsert.maximumValue(6, 3), (Object)ParquetDecimalInsert.minimumValue(6, 3)), writerVersion);
            this.testReadingRescaledDecimals(6, 3, true, 9, 6, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(6, 3), (Object)ParquetDecimalInsert.minimumValue(6, 3)), (List<String>)ImmutableList.of((Object)"10.010000", (Object)"10.000000", (Object)"1.230000", (Object)ParquetDecimalInsert.maximumValue(6, 3), (Object)ParquetDecimalInsert.minimumValue(6, 3)), writerVersion);
            this.testReadingRescaledDecimals(10, 2, false, 38, 4, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), (List<String>)ImmutableList.of((Object)"10.0100", (Object)"10.0000", (Object)"1.2300", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), writerVersion);
            this.testReadingRescaledDecimals(18, 4, false, 38, 14, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(18, 4), (Object)ParquetDecimalInsert.minimumValue(18, 4)), (List<String>)ImmutableList.of((Object)"10.0100", (Object)"10.0000", (Object)"1.2300", (Object)ParquetDecimalInsert.maximumValue(18, 4), (Object)ParquetDecimalInsert.minimumValue(18, 4)), writerVersion);
        }
    }

    public void testReadingRescaledDecimals(int precision, int scale, boolean forceFixedLengthArray, int schemaPrecision, int schemaScale, List<String> values, List<String> expected, ParquetProperties.WriterVersion writerVersion) {
        String tableName = TestParquetDecimalScaling.generateTableName("rescaled_decimals", precision, scale);
        this.createTable(tableName, schemaPrecision, schemaScale);
        TestParquetDecimalScaling.writeParquetDecimalsRecord(this.getParquetWritePath(tableName), (List<ParquetDecimalInsert>)ImmutableList.of((Object)new ParquetDecimalInsert("value", forceFixedLengthArray, precision, scale, values)), writerVersion);
        this.assertValues(tableName, schemaScale, expected);
        this.dropTable(tableName);
    }

    @Test
    public void testReadingRoundedDecimals() {
        for (ParquetProperties.WriterVersion writerVersion : ParquetProperties.WriterVersion.values()) {
            this.testReadingRoundedDecimals(10, 2, false, 12, 1, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), writerVersion);
            this.testReadingRoundedDecimals(9, 2, true, 12, 1, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(9, 2), (Object)ParquetDecimalInsert.minimumValue(9, 2)), (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(9, 2), (Object)ParquetDecimalInsert.minimumValue(9, 2)), writerVersion);
            this.testReadingRoundedDecimals(4, 2, false, 7, 1, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(4, 2), (Object)ParquetDecimalInsert.minimumValue(4, 2)), writerVersion);
            this.testReadingRoundedDecimals(10, 2, false, 12, 1, (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), (List<String>)ImmutableList.of((Object)"10.01", (Object)"10", (Object)"1.23", (Object)ParquetDecimalInsert.maximumValue(10, 2), (Object)ParquetDecimalInsert.minimumValue(10, 2)), writerVersion);
        }
    }

    public void testReadingRoundedDecimals(int precision, int scale, boolean forceFixedLengthArray, int schemaPrecision, int schemaScale, List<String> values, List<String> expected, ParquetProperties.WriterVersion writerVersion) {
        String tableName = TestParquetDecimalScaling.generateTableName("rounded_decimals", precision, scale);
        this.createTable(tableName, schemaPrecision, schemaScale);
        TestParquetDecimalScaling.writeParquetDecimalsRecord(this.getParquetWritePath(tableName), (List<ParquetDecimalInsert>)ImmutableList.of((Object)new ParquetDecimalInsert("value", forceFixedLengthArray, precision, scale, values)), writerVersion);
        this.assertRoundedValues(tableName, schemaScale, expected);
        this.dropTable(tableName);
    }

    @Test
    public void testReadingNonRescalableDecimals() {
        for (ParquetProperties.WriterVersion writerVersion : ParquetProperties.WriterVersion.values()) {
            this.testReadingNonRescalableDecimals(4, 2, false, 4, 3, (List<String>)ImmutableList.of((Object)"10.01"), writerVersion);
            this.testReadingNonRescalableDecimals(10, 2, false, 10, 3, (List<String>)ImmutableList.of((Object)"12345678.91"), writerVersion);
            this.testReadingNonRescalableDecimals(10, 2, false, 3, 2, (List<String>)ImmutableList.of((Object)"10.01"), writerVersion);
            this.testReadingNonRescalableDecimals(10, 2, true, 14, 7, (List<String>)ImmutableList.of((Object)"99999999.99"), writerVersion);
            this.testReadingNonRescalableDecimals(10, 2, false, 10, 4, (List<String>)ImmutableList.of((Object)"99999999.99"), writerVersion);
            this.testReadingNonRescalableDecimals(18, 8, false, 32, 23, (List<String>)ImmutableList.of((Object)"1234567890.12345678"), writerVersion);
            this.testReadingNonRescalableDecimals(20, 8, false, 32, 21, (List<String>)ImmutableList.of((Object)"123456789012.12345678"), writerVersion);
        }
    }

    private void testReadingNonRescalableDecimals(int precision, int scale, boolean forceFixedLengthArray, int schemaPrecision, int schemaScale, List<String> values, ParquetProperties.WriterVersion writerVersion) {
        String tableName = TestParquetDecimalScaling.generateTableName("non_rescalable", precision, scale);
        this.createTable(tableName, schemaPrecision, schemaScale);
        TestParquetDecimalScaling.writeParquetDecimalsRecord(this.getParquetWritePath(tableName), (List<ParquetDecimalInsert>)ImmutableList.of((Object)new ParquetDecimalInsert("value", forceFixedLengthArray, precision, scale, values)), writerVersion);
        String query = String.format("SELECT * FROM tpch.%s", tableName);
        String expectedMessage = String.format("Cannot cast DECIMAL\\(%d, %d\\) '.*' to DECIMAL\\(%d, %d\\)", precision, scale, schemaPrecision, schemaScale);
        this.assertQueryFails(query, expectedMessage);
        this.dropTable(tableName);
    }

    @Test
    public void testParquetLongFixedLenByteArrayWithTrinoShortDecimal() {
        for (ParquetProperties.WriterVersion writerVersion : ParquetProperties.WriterVersion.values()) {
            this.testParquetLongFixedLenByteArrayWithTrinoShortDecimal(5, 2, 19, 2, "-5", writerVersion);
            this.testParquetLongFixedLenByteArrayWithTrinoShortDecimal(5, 2, 20, 2, "999.99", writerVersion);
            this.testParquetLongFixedLenByteArrayWithTrinoShortDecimal(7, 2, 24, 2, "-99999.99", writerVersion);
            this.testParquetLongFixedLenByteArrayWithTrinoShortDecimal(10, 2, 26, 2, "99999999.99", writerVersion);
            this.testParquetLongFixedLenByteArrayWithTrinoShortDecimal(14, 4, 30, 4, "99999999.99", writerVersion);
            this.testParquetLongFixedLenByteArrayWithTrinoShortDecimal(18, 8, 32, 8, "1234567890.12345678", writerVersion);
            this.testParquetLongFixedLenByteArrayWithTrinoShortDecimal(18, 8, 32, 8, "123456789012.12345678", writerVersion);
            this.testParquetLongFixedLenByteArrayWithTrinoShortDecimal(18, 8, 38, 8, "4989875563210.12345678", writerVersion);
        }
    }

    private void testParquetLongFixedLenByteArrayWithTrinoShortDecimal(int schemaPrecision, int schemaScale, int parquetPrecision, int parquetScale, String writeValue, ParquetProperties.WriterVersion writerVersion) {
        String tableName = TestParquetDecimalScaling.generateTableName("rounded_decimals", parquetPrecision, parquetScale);
        this.createTable(tableName, schemaPrecision, schemaScale);
        int byteArrayLength = ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[parquetPrecision - 1];
        MessageType schema = MessageTypeParser.parseMessageType((String)String.format("message hive_record { optional fixed_len_byte_array(%d) value (DECIMAL(%d, %d)); }", byteArrayLength, schemaPrecision, schemaScale));
        ImmutableList inspectors = ImmutableList.of((Object)new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(parquetPrecision, parquetScale)));
        TestParquetDecimalScaling.createParquetFile(this.getParquetWritePath(tableName), ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"value"), (List)inspectors), new Iterator[]{ImmutableList.of((Object)HiveDecimal.create((String)writeValue)).stream().iterator()}, schema, Collections.singletonList("hive_record"), writerVersion);
        if (Decimals.overflows((BigInteger)new BigDecimal(writeValue).unscaledValue(), (int)schemaPrecision)) {
            String query = String.format("SELECT * FROM tpch.%s", tableName);
            String expectedMessage = String.format("Could not read unscaled value %s into a short decimal from column .*", new BigDecimal(writeValue).unscaledValue());
            this.assertQueryFails(query, expectedMessage);
        } else {
            this.assertValues(tableName, schemaScale, (List<String>)ImmutableList.of((Object)writeValue));
        }
        this.dropTable(tableName);
    }

    protected void createTable(String tableName, int precision, int scale) {
        this.assertUpdate(String.format("CREATE TABLE tpch.%s (value decimal(%d, %d)) WITH (format = 'PARQUET')", tableName, precision, scale));
    }

    protected void dropTable(String tableName) {
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    private void assertValues(String tableName, int scale, List<String> expected) {
        MaterializedResult materializedRows = this.computeActual(String.format("SELECT value FROM tpch.%s", tableName));
        List actualValues = (List)materializedRows.getMaterializedRows().stream().map(row -> row.getField(0)).map(BigDecimal.class::cast).collect(ImmutableList.toImmutableList());
        Object[] expectedValues = (BigDecimal[])expected.stream().map(value -> new BigDecimal((String)value).setScale(scale, RoundingMode.UNNECESSARY)).toArray(BigDecimal[]::new);
        Assertions.assertThat((List)actualValues).containsExactlyInAnyOrder(expectedValues);
    }

    private void assertRoundedValues(String tableName, int scale, List<String> expected) {
        MaterializedResult materializedRows = this.computeActual(String.format("SELECT value FROM tpch.%s", tableName));
        List actualValues = (List)materializedRows.getMaterializedRows().stream().map(row -> row.getField(0)).map(BigDecimal.class::cast).collect(ImmutableList.toImmutableList());
        Object[] expectedValues = (BigDecimal[])expected.stream().map(value -> new BigDecimal((String)value).setScale(scale, RoundingMode.HALF_UP)).toArray(BigDecimal[]::new);
        Assertions.assertThat((List)actualValues).containsExactlyInAnyOrder(expectedValues);
    }

    private static java.nio.file.Path getBasePath() {
        try {
            return Files.createTempDirectory("parquet", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path getParquetWritePath(String tableName) {
        return new Path(this.basePath.toString(), String.format("hive_data/tpch/%s/%s", tableName, UUID.randomUUID()));
    }

    private static void createParquetFile(Path path, StandardStructObjectInspector inspector, Iterator<?>[] iterators, MessageType parquetSchema, List<String> columnNames, ParquetProperties.WriterVersion writerVersion) {
        Properties tableProperties = TestParquetDecimalScaling.createTableProperties(columnNames, Collections.singletonList(inspector));
        JobConf jobConf = new JobConf(false);
        jobConf.setEnum("parquet.compression", (Enum)CompressionCodecName.UNCOMPRESSED);
        jobConf.setBoolean("parquet.enable.dictionary", false);
        jobConf.setEnum("parquet.writer.version", (Enum)writerVersion);
        try {
            FileSinkOperator.RecordWriter recordWriter = new TestingMapredParquetOutputFormat(Optional.of(parquetSchema), true, DateTimeZone.getDefault()).getHiveRecordWriter(jobConf, path, Text.class, false, tableProperties, () -> {});
            Object row = inspector.create();
            ImmutableList fields = ImmutableList.copyOf((Collection)inspector.getAllStructFieldRefs());
            while (Arrays.stream(iterators).allMatch(Iterator::hasNext)) {
                for (int i = 0; i < fields.size(); ++i) {
                    Object value = iterators[i].next();
                    inspector.setStructFieldData(row, (StructField)fields.get(i), value);
                }
                ParquetHiveSerDe serde = new ParquetHiveSerDe();
                serde.initialize((Configuration)jobConf, tableProperties, null);
                Writable record = serde.serialize(row, (ObjectInspector)inspector);
                recordWriter.write(record);
            }
            recordWriter.close(false);
        }
        catch (IOException | SerDeException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeParquetDecimalsRecord(Path output, List<ParquetDecimalInsert> inserts, ParquetProperties.WriterVersion writerVersion) {
        List fields = (List)inserts.stream().map(ParquetDecimalInsert::schemaFieldDeclaration).collect(ImmutableList.toImmutableList());
        MessageType schema = MessageTypeParser.parseMessageType((String)String.format("message hive_record { %s; }", Joiner.on((String)"; ").join((Iterable)fields)));
        List inspectors = (List)inserts.stream().map(ParquetDecimalInsert::getParquetObjectInspector).collect(ImmutableList.toImmutableList());
        List columnNames = (List)inserts.stream().map(ParquetDecimalInsert::getColumnName).collect(ImmutableList.toImmutableList());
        Iterator[] values = (Iterator[])inserts.stream().map(ParquetDecimalInsert::getValues).map(Iterable::iterator).toArray(Iterator[]::new);
        TestParquetDecimalScaling.createParquetFile(output, ObjectInspectorFactory.getStandardStructObjectInspector((List)columnNames, (List)inspectors), values, schema, Collections.singletonList("hive_record"), writerVersion);
    }

    private static Properties createTableProperties(List<String> columnNames, List<ObjectInspector> objectInspectors) {
        Properties tableProperties = new Properties();
        tableProperties.setProperty("columns", Joiner.on((char)',').join(columnNames));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(Iterables.transform(objectInspectors, ObjectInspector::getTypeName)));
        return tableProperties;
    }

    private static String generateTableName(String testCase, int precision, int scale) {
        return String.format("%s_%d_%d_%d", testCase, precision, scale, ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE));
    }

    protected static class ParquetDecimalInsert {
        private final String columnName;
        private final boolean forceFixedLengthArray;
        private final int precision;
        private final int scale;
        private final List<String> values;

        public ParquetDecimalInsert(String columnName, boolean forceFixedLengthArray, int precision, int scale, List<String> values) {
            this.columnName = columnName;
            this.forceFixedLengthArray = forceFixedLengthArray;
            this.precision = precision;
            this.scale = scale;
            this.values = values;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String parquetStorage() {
            if (!this.forceFixedLengthArray && this.precision > 0 && this.precision < 10) {
                return "INT32";
            }
            if (!this.forceFixedLengthArray && this.precision >= 10 && this.precision < 18) {
                return "INT64";
            }
            if (this.precision > 38 || this.precision < 0) {
                throw new IllegalArgumentException("Scale cannot be greater than 38 or less than 0");
            }
            return String.format("fixed_len_byte_array(%d)", ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[this.precision - 1]);
        }

        public ObjectInspector getParquetObjectInspector() {
            if (!this.forceFixedLengthArray && this.precision > 0 && this.precision < 10) {
                return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
            }
            if (!this.forceFixedLengthArray && this.precision >= 10 && this.precision < 18) {
                return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
            }
            if (this.precision > 38 || this.precision < 0) {
                throw new IllegalArgumentException("Scale cannot be greater than 38 or less than 0");
            }
            return new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(this.precision, this.scale));
        }

        public String schemaFieldDeclaration() {
            return String.format("optional %s %s (DECIMAL(%d, %d))", this.parquetStorage(), this.columnName, this.precision, this.scale);
        }

        public static String maximumValue(int precision, int scale) {
            return String.format("%s.%s", "9".repeat(precision - scale), "9".repeat(scale));
        }

        public static String minimumValue(int precision, int scale) {
            return "-" + ParquetDecimalInsert.maximumValue(precision, scale);
        }

        public Iterable<?> getValues() {
            ImmutableList inserts = ImmutableList.copyOf(this.values);
            return (Iterable)inserts.stream().map(this::convertValue).collect(ImmutableList.toImmutableList());
        }

        private Object convertValue(String value) {
            BigDecimal bigValue = new BigDecimal(value).setScale(this.scale, RoundingMode.UNNECESSARY);
            if (!this.forceFixedLengthArray && this.precision > 0 && this.precision < 10) {
                return bigValue.unscaledValue().intValue();
            }
            if (!this.forceFixedLengthArray && this.precision >= 10 && this.precision < 18) {
                return bigValue.unscaledValue().longValue();
            }
            if (this.precision > 38 || this.precision < 0) {
                throw new IllegalArgumentException("Scale could not be greater than 38 or less than 0");
            }
            return HiveDecimal.create((BigDecimal)bigValue);
        }
    }
}

