/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestParquetReaderConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ParquetReaderConfig)ConfigAssertions.recordDefaults(ParquetReaderConfig.class)).setIgnoreStatistics(false).setMaxReadBlockSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxReadBlockRowCount(8192).setMaxMergeDistance(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxBufferSize(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setUseColumnIndex(true).setUseBloomFilter(true).setSmallFileThreshold(DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setVectorizedDecodingEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"parquet.ignore-statistics", (Object)"true").put((Object)"parquet.max-read-block-size", (Object)"66kB").put((Object)"parquet.max-read-block-row-count", (Object)"500").put((Object)"parquet.max-buffer-size", (Object)"1431kB").put((Object)"parquet.max-merge-distance", (Object)"342kB").put((Object)"parquet.use-column-index", (Object)"false").put((Object)"parquet.use-bloom-filter", (Object)"false").put((Object)"parquet.small-file-threshold", (Object)"1kB").put((Object)"parquet.experimental.vectorized-decoding.enabled", (Object)"false").buildOrThrow();
        ParquetReaderConfig expected = new ParquetReaderConfig().setIgnoreStatistics(true).setMaxReadBlockSize(DataSize.of((long)66L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setMaxReadBlockRowCount(500).setMaxBufferSize(DataSize.of((long)1431L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setMaxMergeDistance(DataSize.of((long)342L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setUseColumnIndex(false).setUseBloomFilter(false).setSmallFileThreshold(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setVectorizedDecodingEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

