/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestParquetWriterConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ParquetWriterConfig)ConfigAssertions.recordDefaults(ParquetWriterConfig.class)).setBlockSize(DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setPageSize(DataSize.ofBytes((long)0x100000L)).setPageValueCount(60000).setBatchSize(10000).setValidationPercentage(5.0));
    }

    @Test
    public void testLegacyProperties() {
        ConfigAssertions.assertDeprecatedEquivalence(ParquetWriterConfig.class, Map.of("parquet.writer.validation-percentage", "42", "parquet.writer.block-size", "33MB", "parquet.writer.page-size", "7MB"), (Map[])new Map[]{Map.of("parquet.optimized-writer.validation-percentage", "42", "hive.parquet.writer.block-size", "33MB", "hive.parquet.writer.page-size", "7MB")});
    }

    @Test
    public void testExplicitPropertyMappings() {
        Map<String, String> properties = Map.of("parquet.writer.block-size", "234MB", "parquet.writer.page-size", "6MB", "parquet.writer.page-value-count", "10000", "parquet.writer.batch-size", "100", "parquet.writer.validation-percentage", "10");
        ParquetWriterConfig expected = new ParquetWriterConfig().setBlockSize(DataSize.of((long)234L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setPageSize(DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setPageValueCount(10000).setBatchSize(100).setValidationPercentage(10.0);
        ConfigAssertions.assertFullMapping(properties, (Object)expected);
    }
}

