/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.io.Resources;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.parquet.ParquetUtil;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimestampMicros {
    @Test
    public void testTimestampMicros() throws Exception {
        this.testTimestampMicros(HiveTimestampPrecision.MILLISECONDS, LocalDateTime.parse("2020-10-12T16:26:02.907"));
        this.testTimestampMicros(HiveTimestampPrecision.MICROSECONDS, LocalDateTime.parse("2020-10-12T16:26:02.906668"));
        this.testTimestampMicros(HiveTimestampPrecision.NANOSECONDS, LocalDateTime.parse("2020-10-12T16:26:02.906668"));
    }

    private void testTimestampMicros(HiveTimestampPrecision timestampPrecision, LocalDateTime expected) throws Exception {
        File parquetFile = new File(Resources.getResource((String)"issue-5483.parquet").toURI());
        TimestampType columnType = TimestampType.createTimestampType((int)timestampPrecision.getPrecision());
        try (ConnectorPageSource pageSource = ParquetUtil.createPageSource(HiveTestUtils.SESSION, parquetFile, List.of(HiveColumnHandle.createBaseColumn((String)"created", (int)0, (HiveType)HiveType.HIVE_TIMESTAMP, (Type)columnType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty())), (TupleDomain<HiveColumnHandle>)TupleDomain.all());){
            MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)HiveTestUtils.SESSION, (ConnectorPageSource)pageSource, List.of(columnType)).toTestTypes();
            Assertions.assertThat((List)result.getMaterializedRows()).containsOnly((Object[])new MaterializedRow[]{new MaterializedRow(List.of(expected))});
        }
    }

    @Test
    public void testTimestampMicrosAsTimestampWithTimeZone() throws Exception {
        this.testTimestampMicrosAsTimestampWithTimeZone(HiveTimestampPrecision.MILLISECONDS, LocalDateTime.parse("2020-10-12T16:26:02.907"));
        this.testTimestampMicrosAsTimestampWithTimeZone(HiveTimestampPrecision.MICROSECONDS, LocalDateTime.parse("2020-10-12T16:26:02.906668"));
        this.testTimestampMicrosAsTimestampWithTimeZone(HiveTimestampPrecision.NANOSECONDS, LocalDateTime.parse("2020-10-12T16:26:02.906668"));
    }

    private void testTimestampMicrosAsTimestampWithTimeZone(HiveTimestampPrecision timestampPrecision, LocalDateTime expected) throws Exception {
        File parquetFile = new File(Resources.getResource((String)"issue-5483.parquet").toURI());
        TimestampWithTimeZoneType columnType = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)timestampPrecision.getPrecision());
        try (ConnectorPageSource pageSource = ParquetUtil.createPageSource(HiveTestUtils.SESSION, parquetFile, List.of(HiveColumnHandle.createBaseColumn((String)"created", (int)0, (HiveType)HiveType.HIVE_TIMESTAMP, (Type)columnType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty())), (TupleDomain<HiveColumnHandle>)TupleDomain.all());){
            MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)HiveTestUtils.SESSION, (ConnectorPageSource)pageSource, List.of(columnType)).toTestTypes();
            Assertions.assertThat((List)result.getMaterializedRows()).containsOnly((Object[])new MaterializedRow[]{new MaterializedRow(List.of(expected.atZone(ZoneId.of("UTC"))))});
        }
    }
}

