/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet.write;

import io.trino.plugin.hive.parquet.write.TestDataWritableWriteSupport;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.write.DataWritableWriteSupport;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.parquet.hadoop.DisabledMemoryManager;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.schema.MessageType;
import org.joda.time.DateTimeZone;

public class TestingMapredParquetOutputFormat
extends MapredParquetOutputFormat {
    private final Optional<MessageType> schema;

    public TestingMapredParquetOutputFormat(Optional<MessageType> schema, boolean singleLevelArray, DateTimeZone dateTimeZone) {
        super((OutputFormat)new ParquetOutputFormat((WriteSupport)new TestDataWritableWriteSupport(singleLevelArray, dateTimeZone)));
        this.schema = Objects.requireNonNull(schema, "schema is null");
    }

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jobConf, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        if (this.schema.isPresent()) {
            DataWritableWriteSupport.setSchema((MessageType)this.schema.get(), (Configuration)jobConf);
            return this.getParquerRecordWriterWrapper(this.realOutputFormat, jobConf, finalOutPath.toString(), progress, tableProperties);
        }
        return super.getHiveRecordWriter(jobConf, finalOutPath, valueClass, isCompressed, tableProperties, progress);
    }

    private static void replaceHadoopParquetMemoryManager() {
        try {
            Field memoryManager = ParquetOutputFormat.class.getDeclaredField("memoryManager");
            memoryManager.setAccessible(true);
            memoryManager.set(null, (Object)new DisabledMemoryManager());
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        TestingMapredParquetOutputFormat.replaceHadoopParquetMemoryManager();
    }
}

