/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.projection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.projection.DateProjection;
import io.trino.plugin.hive.projection.InvalidProjectionException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestDateProjectionFactory {
    TestDateProjectionFactory() {
    }

    @Test
    void testTypeSupport() {
        new DateProjection("test", (Type)VarcharType.VARCHAR, (Map)ImmutableMap.of((Object)"partition_projection_format", (Object)"yyyy-MM-dd", (Object)"partition_projection_range", (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-01-03")));
        new DateProjection("test", (Type)DateType.DATE, (Map)ImmutableMap.of((Object)"partition_projection_format", (Object)"yyyy-MM-dd", (Object)"partition_projection_range", (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-01-03")));
        new DateProjection("test", (Type)TimestampType.TIMESTAMP_SECONDS, (Map)ImmutableMap.of((Object)"partition_projection_format", (Object)"yyyy-MM-dd", (Object)"partition_projection_range", (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-01-03")));
        new DateProjection("test", (Type)TimestampType.TIMESTAMP_MICROS, (Map)ImmutableMap.of((Object)"partition_projection_format", (Object)"yyyy-MM-dd", (Object)"partition_projection_range", (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-01-03")));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DateProjection("test", (Type)TimestampType.TIMESTAMP_NANOS, (Map)ImmutableMap.of((Object)"partition_projection_format", (Object)"yyyy-MM-dd", (Object)"partition_projection_range", (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-01-03")))).isInstanceOf(InvalidProjectionException.class)).hasMessage("Column projection for column 'test' failed. Unsupported column type: timestamp(9)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DateProjection("test", (Type)BigintType.BIGINT, (Map)ImmutableMap.of((Object)"partition_projection_format", (Object)"yyyy-MM-dd", (Object)"partition_projection_range", (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-01-03")))).isInstanceOf(InvalidProjectionException.class)).hasMessage("Column projection for column 'test' failed. Unsupported column type: bigint");
    }

    @Test
    void testCreate() {
        DateProjection projection = new DateProjection("test", (Type)VarcharType.VARCHAR, (Map)ImmutableMap.of((Object)"partition_projection_format", (Object)"yyyy-MM-dd", (Object)"partition_projection_range", (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-01-03")));
        Assertions.assertThat((List)projection.getProjectedValues(Optional.empty())).containsExactly((Object[])new String[]{"2020-01-01", "2020-01-02", "2020-01-03"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.all((Type)VarcharType.VARCHAR)))).containsExactly((Object[])new String[]{"2020-01-01", "2020-01-02", "2020-01-03"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.none((Type)VarcharType.VARCHAR)))).isEmpty();
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-01-02"))))).containsExactly((Object[])new String[]{"2020-01-02"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2222-01-01"))))).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DateProjection("test", (Type)VarcharType.VARCHAR, (Map)ImmutableMap.of((Object)"ignored", (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-01-02", (Object)"2020-01-03")))).isInstanceOf(InvalidProjectionException.class)).hasMessage("Column projection for column 'test' failed. Missing required property: 'partition_projection_format'");
    }
}

