/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.projection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.projection.EnumProjection;
import io.trino.plugin.hive.projection.InvalidProjectionException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestEnumProjectionFactory {
    TestEnumProjectionFactory() {
    }

    @Test
    void testIsSupported() {
        new EnumProjection("test", (Type)VarcharType.VARCHAR, (Map)ImmutableMap.of((Object)"partition_projection_values", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new EnumProjection("test", (Type)BigintType.BIGINT, (Map)ImmutableMap.of((Object)"partition_projection_values", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")))).isInstanceOf(InvalidProjectionException.class)).hasMessage("Column projection for column 'test' failed. Unsupported column type: bigint");
    }

    @Test
    void testCreate() {
        EnumProjection projection = new EnumProjection("test", (Type)VarcharType.VARCHAR, (Map)ImmutableMap.of((Object)"partition_projection_values", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        Assertions.assertThat((List)projection.getProjectedValues(Optional.empty())).containsExactly((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.all((Type)VarcharType.VARCHAR)))).containsExactly((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.none((Type)VarcharType.VARCHAR)))).isEmpty();
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))))).containsExactly((Object[])new String[]{"b"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"x"))))).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new EnumProjection("test", (Type)VarcharType.VARCHAR, (Map)ImmutableMap.of((Object)"ignored", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")))).isInstanceOf(InvalidProjectionException.class)).hasMessage("Column projection for column 'test' failed. Missing required property: 'partition_projection_values'");
        Assertions.assertThatThrownBy(() -> new EnumProjection("test", (Type)VarcharType.VARCHAR, (Map)ImmutableMap.of((Object)"partition_projection_values", (Object)"invalid"))).isInstanceOf(ClassCastException.class);
    }
}

