/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.projection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.projection.IntegerProjection;
import io.trino.plugin.hive.projection.InvalidProjectionException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestIntegerProjectionFactory {
    TestIntegerProjectionFactory() {
    }

    @Test
    void testIsSupported() {
        new IntegerProjection("test", (Type)VarcharType.VARCHAR, (Map)ImmutableMap.of((Object)"partition_projection_range", (Object)ImmutableList.of((Object)"1", (Object)"3")));
        new IntegerProjection("test", (Type)IntegerType.INTEGER, (Map)ImmutableMap.of((Object)"partition_projection_range", (Object)ImmutableList.of((Object)"1", (Object)"3")));
        new IntegerProjection("test", (Type)BigintType.BIGINT, (Map)ImmutableMap.of((Object)"partition_projection_range", (Object)ImmutableList.of((Object)"1", (Object)"3")));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new IntegerProjection("test", (Type)DateType.DATE, (Map)ImmutableMap.of((Object)"partition_projection_range", (Object)ImmutableList.of((Object)"1", (Object)"3")))).isInstanceOf(InvalidProjectionException.class)).hasMessage("Column projection for column 'test' failed. Unsupported column type: date");
    }

    @Test
    void testCreateBasic() {
        IntegerProjection projection = new IntegerProjection("test", (Type)IntegerType.INTEGER, (Map)ImmutableMap.of((Object)"partition_projection_range", (Object)ImmutableList.of((Object)"1", (Object)"3")));
        Assertions.assertThat((List)projection.getProjectedValues(Optional.empty())).containsExactly((Object[])new String[]{"1", "2", "3"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.all((Type)IntegerType.INTEGER)))).containsExactly((Object[])new String[]{"1", "2", "3"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.none((Type)IntegerType.INTEGER)))).isEmpty();
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)))).containsExactly((Object[])new String[]{"2"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L)))).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new IntegerProjection("test", (Type)IntegerType.INTEGER, (Map)ImmutableMap.of((Object)"ignored", (Object)ImmutableList.of((Object)"1", (Object)"3")))).isInstanceOf(InvalidProjectionException.class)).hasMessage("Column projection for column 'test' failed. Missing required property: 'partition_projection_range'");
        Assertions.assertThatThrownBy(() -> new IntegerProjection("test", (Type)IntegerType.INTEGER, (Map)ImmutableMap.of((Object)"partition_projection_range", (Object)"invalid"))).isInstanceOf(ClassCastException.class);
    }

    @Test
    void testInterval() {
        IntegerProjection projection = new IntegerProjection("test", (Type)IntegerType.INTEGER, (Map)ImmutableMap.of((Object)"partition_projection_range", (Object)ImmutableList.of((Object)"10", (Object)"30"), (Object)"partition_projection_interval", (Object)10));
        Assertions.assertThat((List)projection.getProjectedValues(Optional.empty())).containsExactly((Object[])new String[]{"10", "20", "30"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.all((Type)IntegerType.INTEGER)))).containsExactly((Object[])new String[]{"10", "20", "30"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.none((Type)IntegerType.INTEGER)))).isEmpty();
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L)))).containsExactly((Object[])new String[]{"20"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.singleValue((Type)IntegerType.INTEGER, (Object)70L)))).isEmpty();
    }

    @Test
    void testCreateDigits() {
        IntegerProjection projection = new IntegerProjection("test", (Type)IntegerType.INTEGER, (Map)ImmutableMap.of((Object)"partition_projection_range", (Object)ImmutableList.of((Object)"1", (Object)"3"), (Object)"partition_projection_digits", (Object)3));
        Assertions.assertThat((List)projection.getProjectedValues(Optional.empty())).containsExactly((Object[])new String[]{"001", "002", "003"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.all((Type)IntegerType.INTEGER)))).containsExactly((Object[])new String[]{"001", "002", "003"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.none((Type)IntegerType.INTEGER)))).isEmpty();
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)))).containsExactly((Object[])new String[]{"002"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L)))).isEmpty();
    }
}

