/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.units.Duration;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.TestingTokenAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class S3HiveQueryRunner {
    private S3HiveQueryRunner() {
    }

    public static QueryRunner create(HiveMinioDataLake hiveMinioDataLake, Map<String, String> additionalHiveProperties) throws Exception {
        return ((Builder)((Object)S3HiveQueryRunner.builder(hiveMinioDataLake).setHiveProperties(additionalHiveProperties))).build();
    }

    public static Builder builder(HiveMinioDataLake hiveMinioDataLake) {
        return S3HiveQueryRunner.builder().setHiveMetastoreEndpoint(hiveMinioDataLake.getHiveHadoop().getHiveMetastoreEndpoint()).setS3Endpoint("http://" + String.valueOf(hiveMinioDataLake.getMinio().getMinioApiEndpoint())).setS3Region("us-east-1").setS3AccessKey("accesskey").setS3SecretKey("secretkey").setBucketName(hiveMinioDataLake.getBucketName());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void main(String[] args) throws Exception {
        HiveMinioDataLake hiveMinioDataLake = new HiveMinioDataLake("tpch");
        hiveMinioDataLake.start();
        DistributedQueryRunner queryRunner = ((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)S3HiveQueryRunner.builder(hiveMinioDataLake).addCoordinatorProperty("http-server.http.port", "8080")).setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.security", (Object)"allow-all")))).setSkipTimezoneSetup(true))).setInitialTables(TpchTable.getTables()))).build();
        Logger log = Logger.get(S3HiveQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }

    static {
        Logging.initialize();
    }

    public static class Builder
    extends HiveQueryRunner.Builder<Builder> {
        private URI hiveMetastoreEndpoint;
        private Duration thriftMetastoreTimeout = TestingTokenAwareMetastoreClientFactory.TIMEOUT;
        private ThriftMetastoreConfig thriftMetastoreConfig = new ThriftMetastoreConfig();
        private String s3Region;
        private String s3Endpoint;
        private String s3AccessKey;
        private String s3SecretKey;
        private String bucketName;

        @CanIgnoreReturnValue
        public Builder setHiveMetastoreEndpoint(URI hiveMetastoreEndpoint) {
            this.hiveMetastoreEndpoint = Objects.requireNonNull(hiveMetastoreEndpoint, "hiveMetastoreEndpoint is null");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setThriftMetastoreTimeout(Duration thriftMetastoreTimeout) {
            this.thriftMetastoreTimeout = Objects.requireNonNull(thriftMetastoreTimeout, "thriftMetastoreTimeout is null");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setThriftMetastoreConfig(ThriftMetastoreConfig thriftMetastoreConfig) {
            this.thriftMetastoreConfig = Objects.requireNonNull(thriftMetastoreConfig, "thriftMetastoreConfig is null");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setS3Region(String s3Region) {
            this.s3Region = Objects.requireNonNull(s3Region, "s3Region is null");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setS3Endpoint(String s3Endpoint) {
            this.s3Endpoint = Objects.requireNonNull(s3Endpoint, "s3Endpoint is null");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setS3AccessKey(String s3AccessKey) {
            this.s3AccessKey = Objects.requireNonNull(s3AccessKey, "s3AccessKey is null");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setS3SecretKey(String s3SecretKey) {
            this.s3SecretKey = Objects.requireNonNull(s3SecretKey, "s3SecretKey is null");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setBucketName(String bucketName) {
            this.bucketName = Objects.requireNonNull(bucketName, "bucketName is null");
            return this;
        }

        @Override
        public DistributedQueryRunner build() throws Exception {
            Objects.requireNonNull(this.hiveMetastoreEndpoint, "hiveMetastoreEndpoint is null");
            Objects.requireNonNull(this.s3Region, "s3Region is null");
            Objects.requireNonNull(this.s3Endpoint, "s3Endpoint is null");
            Objects.requireNonNull(this.s3AccessKey, "s3AccessKey is null");
            Objects.requireNonNull(this.s3SecretKey, "s3SecretKey is null");
            Objects.requireNonNull(this.bucketName, "bucketName is null");
            String lowerCaseS3Endpoint = this.s3Endpoint.toLowerCase(Locale.ENGLISH);
            Preconditions.checkArgument((lowerCaseS3Endpoint.startsWith("http://") || lowerCaseS3Endpoint.startsWith("https://") ? 1 : 0) != 0, (String)"Expected http URI for S3 endpoint; got %s", (Object)this.s3Endpoint);
            this.addHiveProperty("fs.hadoop.enabled", "false");
            this.addHiveProperty("fs.native-s3.enabled", "true");
            this.addHiveProperty("s3.region", this.s3Region);
            this.addHiveProperty("s3.endpoint", this.s3Endpoint);
            this.addHiveProperty("s3.aws-access-key", this.s3AccessKey);
            this.addHiveProperty("s3.aws-secret-key", this.s3SecretKey);
            this.addHiveProperty("s3.path-style-access", "true");
            this.setMetastore(distributedQueryRunner -> new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(this.hiveMetastoreEndpoint, this.thriftMetastoreTimeout).thriftMetastoreConfig(this.thriftMetastoreConfig).build(arg_0 -> ((DistributedQueryRunner)distributedQueryRunner).registerResource(arg_0))));
            this.setInitialSchemasLocationBase("s3a://" + this.bucketName);
            return super.build();
        }
    }
}

